/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.datatype;

import com.sqlapp.data.converter.Converters;
import com.sqlapp.data.db.datatype.DbDataType;
import com.sqlapp.data.db.datatype.LengthProperties;
import com.sqlapp.data.schemas.CharacterSemantics;
import com.sqlapp.data.schemas.SchemaUtils;
import com.sqlapp.data.schemas.properties.DataTypeLengthProperties;
import com.sqlapp.data.schemas.properties.DataTypeSetProperties;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.ToStringBuilder;
import java.util.regex.Matcher;

public abstract class AbstractLengthType<T extends DbDataType<T>>
extends DbDataType<T>
implements LengthProperties<T> {
    private static final long serialVersionUID = 8982873757752848020L;
    private Long defaultLength = null;
    private Long maxLength = null;

    @Override
    protected void initialize(String typeName) {
        this.setFixedLength(true);
        this.setTypeName(typeName);
        this.setCreateFormat(typeName + "(", ")");
        this.addFormats(typeName);
        this.addSizeFormat(typeName);
        for (String alias : this.getDataType().getAliasNames()) {
            this.addSizeFormat(alias);
        }
    }

    public T setCreateFormat(String start, String end) {
        this.setCreateFormat(start + "{l}" + end);
        return this.instance();
    }

    @Override
    public boolean matchLength(DataTypeLengthProperties<?> column) {
        return column.getLength() != null && this.getMaxLength() != null && this.getMaxLength().compareTo(column.getLength()) >= 0;
    }

    @Override
    protected void buildToString(ToStringBuilder builder) {
        builder.add("defaultLength", (Object)this.defaultLength);
        builder.add("maxLength", (Object)this.maxLength);
    }

    @Override
    public Long getDefaultLength() {
        return this.defaultLength;
    }

    @Override
    public T setDefaultLength(Long defaultLength) {
        this.defaultLength = defaultLength;
        return this.instance();
    }

    public T setDefaultLength(Number defaultLength) {
        this.defaultLength = Converters.getDefault().convertObject(defaultLength, Long.class);
        return this.instance();
    }

    @Override
    public Long getMaxLength() {
        return this.maxLength;
    }

    @Override
    public T setMaxLength(Long maxLength) {
        this.maxLength = maxLength;
        return this.instance();
    }

    public T setMaxLength(long maxLength) {
        this.maxLength = maxLength;
        return this.instance();
    }

    @Override
    public long getLength(Long length) {
        long ret;
        long l = ret = this.getDefaultLength() != null ? this.getDefaultLength() : 0L;
        if (length != null && this.getMaxLength() != null) {
            ret = this.getMaxLength() > length ? length.longValue() : this.getMaxLength().longValue();
        }
        return ret;
    }

    @Override
    protected void parseAndSet(Matcher matcher, DataTypeLengthProperties<?> column) {
        if (matcher.groupCount() == 0 && this.getDefaultLength() != null) {
            column.setLength(this.getDefaultLength());
        }
        SchemaUtils.setDataTypeNameInternal(this.getTypeName(), column);
        if (matcher.groupCount() > 0) {
            Long size = AbstractLengthType.getLong(matcher, 1);
            if (size != null) {
                if (matcher.groupCount() > 1) {
                    String unit = matcher.group(2);
                    if ("K".equalsIgnoreCase(unit)) {
                        size = size * (long)CommonUtils.LEN_1KB;
                    } else if ("M".equalsIgnoreCase(unit)) {
                        size = size * (long)CommonUtils.LEN_1MB;
                    } else if ("G".equalsIgnoreCase(unit)) {
                        size = size * (long)CommonUtils.LEN_1GB;
                    }
                }
                column.setLength(size);
            } else if (this.getDefaultLength() != null) {
                column.setLength(this.getDefaultLength());
            }
            if (matcher.groupCount() > 2) {
                String c = matcher.group(3);
                if (column instanceof DataTypeSetProperties) {
                    ((DataTypeSetProperties)column).setCharacterSemantics(CharacterSemantics.parse(c));
                }
            }
        }
    }

    @Override
    public T addSizeFormat(String dataTypeName) {
        this.addFormats(dataTypeName + "\\s*\\(\\s*([0-9]+)\\s*(K|M|G){0,1}\\s*(CHAR|BYTE|C|B){0,1}\\s*\\)\\s*", dataTypeName + "\\s*");
        return this.instance();
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof AbstractLengthType)) {
            return false;
        }
        AbstractLengthType objValue = (AbstractLengthType)obj;
        if (!CommonUtils.eq(this.getMaxLength(), objValue.getMaxLength())) {
            return false;
        }
        return CommonUtils.eq(this.getDefaultLength(), objValue.getDefaultLength());
    }
}

