/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.datatype;

import com.sqlapp.data.converter.ByteArrayConverter;
import com.sqlapp.data.converter.Converter;
import com.sqlapp.data.converter.HexBinaryConverter;
import com.sqlapp.data.db.datatype.AbstractLengthType;
import com.sqlapp.data.db.datatype.DataType;
import com.sqlapp.data.db.datatype.DefaultJdbcTypeHandler;
import com.sqlapp.util.CommonUtils;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.JDBCType;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class BlobType
extends AbstractLengthType<BlobType> {
    private static final long serialVersionUID = -8658816953027318522L;
    protected ByteArrayConverter converter = new ByteArrayConverter();

    public BlobType() {
        this(DataType.BLOB.getTypeName());
    }

    protected BlobType(String dataTypeName) {
        this.setDataType(DataType.BLOB);
        this.initialize(dataTypeName);
        this.setJdbcTypeHandler(new BlobTypeHandler(this.getDataType().getJdbcType(), this.converter));
        this.setDefaultLength(CommonUtils.LEN_2GB);
        this.setSupportsArray(false);
        this.setLiteralPrefix("0x");
        this.setLiteralSuffix("");
        this.setSqlTextConverter(new HexBinaryConverter());
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        return obj instanceof BlobType;
    }

    private static class BlobTypeHandler
    extends DefaultJdbcTypeHandler {
        private static final long serialVersionUID = -3446371652551511555L;

        public BlobTypeHandler(JDBCType jdbcType, Converter<?> converter) {
            super(jdbcType, converter);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setObject(PreparedStatement stmt, int parameterIndex, Object x) throws SQLException {
            if (x == null) {
                stmt.setNull(parameterIndex, 2004);
                return;
            }
            if (x instanceof Blob) {
                stmt.setBlob(parameterIndex, (Blob)x);
                return;
            }
            if (x instanceof InputStream) {
                stmt.setBlob(parameterIndex, (InputStream)x);
                return;
            }
            Blob blob = null;
            try {
                blob = stmt.getConnection().createBlob();
                byte[] bytes = (byte[])CommonUtils.cast(this.statementConverter.convertObject(x));
                blob.setBytes(0L, bytes);
                stmt.setBlob(parameterIndex, blob);
            }
            finally {
                if (blob != null) {
                    blob.free();
                }
            }
        }
    }
}

