/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.datatype;

import com.sqlapp.data.converter.TimeConverter;
import com.sqlapp.data.converter.ZonedDateTimeConverter;
import com.sqlapp.data.db.datatype.DataType;
import com.sqlapp.data.db.datatype.DefaultJdbcTypeHandler;
import com.sqlapp.data.db.datatype.TimeType;

public class TimeWithTimeZoneType
extends TimeType {
    private static final long serialVersionUID = -8658816953027318522L;
    private TimeConverter converter = null;

    public TimeWithTimeZoneType() {
        this(DataType.TIME_WITH_TIMEZONE.getTypeName());
    }

    public TimeWithTimeZoneType(String dataTypeName) {
        this.setDataType(DataType.TIME_WITH_TIMEZONE);
        this.initialize(dataTypeName);
        this.setCreateFormat("TIME(", ") WITH TIMEZONE");
        this.setFormats("TIME\\s*(\\s*[0-9]+\\s*)\\s*WITH\\s+TIMEZONE\\s*", "TIME\\s+WITH\\s+TIME\\s*ZONE\\s*");
        this.addFormats("TIMETZ\\s*\\(\\s*([0-9])+\\s*\\)\\s*", "TIMESTZ\\s*");
        this.converter = new TimeConverter();
        this.converter.setZonedDateTimeConverter((ZonedDateTimeConverter)((ZonedDateTimeConverter)ZonedDateTimeConverter.newInstance().setParseFormats("H:m:s.SSS Z", "H:m:s.SSS z", "H:m:s.SSS", "H:m:s Z", "H:m:s", "H:m Z", "H:m")).setFormat("HH:mm:ss.SSS Z"));
        this.setJdbcTypeHandler(new DefaultJdbcTypeHandler(this.getDataType().getJdbcType(), this.converter));
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        return obj instanceof TimeWithTimeZoneType;
    }
}

