/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.datatype;

import com.sqlapp.data.converter.TimestampConverter;
import com.sqlapp.data.converter.ZonedDateTimeConverter;
import com.sqlapp.data.db.datatype.DataType;
import com.sqlapp.data.db.datatype.DefaultJdbcTypeHandler;
import com.sqlapp.data.db.datatype.TimestampType;

public class TimestampWithTimeZoneType
extends TimestampType {
    private static final long serialVersionUID = -8658816953027318522L;
    private TimestampConverter converter = null;

    public TimestampWithTimeZoneType() {
        this(DataType.TIMESTAMP_WITH_TIMEZONE.getTypeName());
    }

    protected TimestampWithTimeZoneType(String dataTypeName) {
        this.setDataType(DataType.TIMESTAMP_WITH_TIMEZONE);
        this.initialize(dataTypeName);
        this.setLiteral("{ts '", "'}");
        this.setCreateFormat("TIMESTAMP(", ") WITH TIMEZONE");
        this.setFormats("TIMESTAMP\\s*\\(\\s*([0-9])+\\s*\\)\\s*WITH\\s+TIME\\s*ZONE\\s*", "TIMESTAMP\\s+WITH\\s+TIME\\s*ZONE\\s*");
        this.addFormats("TIMESTAMPTZ\\s*\\(\\s*([0-9])+\\s*\\)\\s*", "TIMESTAMPTZ\\s*");
        this.converter = new TimestampConverter();
        this.converter.setZonedDateTimeConverter((ZonedDateTimeConverter)((ZonedDateTimeConverter)ZonedDateTimeConverter.newInstance().setParseFormats("uuuu-M-d H:m:s.SSS Z", "uuuu-M-d H:m:s.SSS z", "uuuu-M-d H:m:s.SSS", "uuuu-M-d H:m:s Z", "uuuu-M-d H:m:s", "uuuu-M-d H:m Z", "uuuu-M-d H:m", "uuuu-M-d")).setFormat("uuuu-MM-dd HH:mm:ss.SSS Z"));
        this.setJdbcTypeHandler(new DefaultJdbcTypeHandler(this.getDataType().getJdbcType(), this.converter));
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        return obj instanceof TimestampWithTimeZoneType;
    }
}

