/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect;

import com.sqlapp.data.converter.Converter;
import com.sqlapp.data.db.datatype.DataType;
import com.sqlapp.data.db.datatype.DbDataType;
import com.sqlapp.data.db.datatype.DbDataTypeCollection;
import com.sqlapp.data.db.datatype.DefaultJdbcTypeHandler;
import com.sqlapp.data.db.datatype.LengthProperties;
import com.sqlapp.data.db.datatype.PrecisionProperties;
import com.sqlapp.data.db.datatype.ScaleProperties;
import com.sqlapp.data.db.dialect.DefaultCase;
import com.sqlapp.data.db.dialect.jdbc.metadata.JdbcCatalogReader;
import com.sqlapp.data.db.dialect.util.SqlSplitter;
import com.sqlapp.data.db.metadata.CatalogReader;
import com.sqlapp.data.db.metadata.MetadataReaderUtils;
import com.sqlapp.data.db.sql.SimpleSqlFactoryRegistry;
import com.sqlapp.data.db.sql.SqlFactoryRegistry;
import com.sqlapp.data.db.sql.SqlOperation;
import com.sqlapp.data.schemas.CascadeRule;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.DbCommonObject;
import com.sqlapp.data.schemas.Domain;
import com.sqlapp.data.schemas.Index;
import com.sqlapp.data.schemas.IndexType;
import com.sqlapp.data.schemas.Schema;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.SchemaUtils;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.data.schemas.properties.DataTypeLengthProperties;
import com.sqlapp.data.schemas.properties.DataTypeProperties;
import com.sqlapp.exceptions.FieldNotFoundException;
import com.sqlapp.jdbc.sql.JdbcHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.AbstractSqlBuilder;
import com.sqlapp.util.CaseInsensitiveMap;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.DateUtils;
import com.sqlapp.util.SqlBuilder;
import java.io.Serializable;
import java.sql.JDBCType;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Pattern;

public class Dialect
implements Serializable,
Comparable<Dialect> {
    private static final long serialVersionUID = -6651943701544804926L;
    public static final String COLUMN_SIZE = "SIZE";
    public static final String COLUMN_PRECISION = "PRECISION";
    public static final String COLUMN_SCALE = "SCALE";
    public static final String COLUMN_DEFAULT_VALUE = "DEFAULT_VALUE";
    private final String[] SYSTEM_SCHEMA = new String[0];
    public static final String DefaultDbType = "Standard";
    private final DbDataTypeCollection dbDataTypes = new DbDataTypeCollection();
    private final Map<String, IndexType> indexTypeNameMap = new CaseInsensitiveMap<IndexType>();
    private final Pattern quatePattern = Pattern.compile("[a-z0-9_$]+", 2);
    private final Supplier<Dialect> nextVersionDialectSupplier;

    protected Dialect(Supplier<Dialect> nextVersionDialectSupplier) {
        this.registerDataType();
        this.nextVersionDialectSupplier = nextVersionDialectSupplier;
    }

    protected void registerDataType() {
        this.getDbDataTypes().addChar(254L);
        this.getDbDataTypes().addVarchar(2000L);
        this.getDbDataTypes().addLongVarchar(2000L);
        this.getDbDataTypes().addClob("CLOB", CommonUtils.LEN_2GB);
        this.getDbDataTypes().addNChar(254L);
        this.getDbDataTypes().addNVarchar(2000L);
        this.getDbDataTypes().addLongNVarchar(2000L);
        this.getDbDataTypes().addNClob("NCLOB", CommonUtils.LEN_2GB);
        this.getDbDataTypes().addBlob("BLOB", CommonUtils.LEN_2GB);
        this.getDbDataTypes().addTinyInt();
        this.getDbDataTypes().addSmallInt();
        this.getDbDataTypes().addInt();
        this.getDbDataTypes().addBigInt();
        this.getDbDataTypes().addReal();
        this.getDbDataTypes().addDouble();
        this.getDbDataTypes().addDate().setDefaultValueLiteral(this.getCurrentDateFunction());
        this.getDbDataTypes().addTime().setDefaultValueLiteral(this.getCurrentTimeFunction());
        this.getDbDataTypes().addTimestamp().setDefaultValueLiteral(this.getCurrentTimestampFunction());
        this.getDbDataTypes().addDecimal();
        this.getDbDataTypes().addNumeric();
    }

    public DbDataType<?> getDbDataType(DataTypeLengthProperties<?> column) {
        Domain domain;
        Schema schema;
        if (column.getDataType() != null && (column.getDataType().isOther() || column.getDataType().isDomain()) && column instanceof DbCommonObject && (schema = ((DbCommonObject)((Object)column)).getAncestor(Schema.class)) != null && (domain = (Domain)schema.getDomains().get(column.getDataTypeName())) != null) {
            return this.getDbDataTypes().getDbType(domain.getDataType(), domain.getLength());
        }
        return this.getDbDataTypes().getDbType(column.getDataType(), column.getLength());
    }

    public boolean setDbType(int sqlType, String productDataType, Long lengthOrPrecision, Integer scale, DataTypeLengthProperties<?> column) {
        return this.setDbType(DataType.valueOf(sqlType), productDataType, lengthOrPrecision, scale, column);
    }

    public boolean setDbType(DataType dataType, String productDataType, Long lengthOrPrecision, Integer scale, DataTypeLengthProperties<?> column) {
        Set<DbDataType<?>> set = CommonUtils.set();
        return this.setDbType(dataType, productDataType, lengthOrPrecision, scale, column, set);
    }

    private boolean setDbType(DataType dataType, String productDataType, Long lengthOrPrecision, Integer scale, DataTypeLengthProperties<?> column, Set<DbDataType<?>> set) {
        boolean bool;
        if (dataType != null && (dataType.isType() || dataType.isDomain() || dataType.isOther())) {
            column.setDataType(dataType);
            SchemaUtils.setDataTypeNameInternal(productDataType, column);
            column.setLength(lengthOrPrecision);
            column.setScale(scale);
            return true;
        }
        DbDataType<?> dbDataType = this.getDbDataTypes().match(productDataType, lengthOrPrecision, column);
        if (set.contains(dbDataType)) {
            return false;
        }
        if (dbDataType == null) {
            column.setDataType(dataType);
        } else {
            dbDataType.parseAndSet(productDataType, column);
            set.add(dbDataType);
            DataType sarrogation = null;
            if (lengthOrPrecision == null) {
                lengthOrPrecision = column.getLength();
            }
            if (scale == null) {
                scale = column.getScale();
            }
            if (lengthOrPrecision != null) {
                boolean bool2;
                if (!dbDataType.matchLength(column) && (bool2 = this.setDbType(column.getDataType(), productDataType, column.getLength(), column.getScale(), column, set))) {
                    return bool2;
                }
                sarrogation = dbDataType.getSizeSarrogation(lengthOrPrecision);
            }
            if (sarrogation != null) {
                column.setDataType(sarrogation);
            }
        }
        dbDataType = this.getDbDataType(column);
        if (dbDataType != null) {
            set.add(dbDataType);
            if (dbDataType.isFixedLength() || dbDataType.isFixedPrecision()) {
                this.setLengthOrPrecision(dbDataType, lengthOrPrecision, column);
            } else if (dbDataType.getDataType().isFixedSize()) {
                column.setLength(lengthOrPrecision);
            } else {
                column.setLength(null);
            }
            if (dbDataType.isFixedScale()) {
                this.setScale(dbDataType, scale, column);
            } else {
                column.setScale(null);
            }
        } else {
            if (column.getDataType() == null) {
                if (dataType == null) {
                    column.setDataType(DataType.OTHER);
                } else {
                    column.setDataType(dataType);
                }
            }
            if (column.getDataType().isFixedSize()) {
                if (lengthOrPrecision != null) {
                    column.setLength(lengthOrPrecision);
                } else {
                    column.setLength(null);
                }
            } else {
                column.setLength(null);
            }
            if (column.getDataType().isFixedScale()) {
                if (scale != null) {
                    column.setScale(scale);
                } else {
                    column.setScale(null);
                }
            } else {
                column.setScale(null);
            }
        }
        if (column.getDataTypeName() == null) {
            if (column.getDataType() == null) {
                SchemaUtils.setDataTypeNameInternal(productDataType, column);
            } else if (column.getDataType().isOther() || column.getDataType().isDomain() || column.getDataType().isType()) {
                SchemaUtils.setDataTypeNameInternal(productDataType, column);
            }
        } else if (this.matchDataTypeName(column.getDataType(), column.getDataTypeName()) && !(bool = SchemaUtils.setDataTypeNameInternal(null, column))) {
            throw new FieldNotFoundException(SchemaProperties.DATA_TYPE_NAME.getLabel(), this);
        }
        return true;
    }

    private void setLengthOrPrecision(DbDataType<?> dbDataType, Long lengthOrPrecision, DataTypeLengthProperties<?> column) {
        if (lengthOrPrecision != null) {
            LengthProperties pp;
            if (dbDataType instanceof PrecisionProperties) {
                PrecisionProperties pp2 = (PrecisionProperties)((Object)dbDataType);
                if (pp2.getMaxPrecision() != null && pp2.getMaxPrecision().longValue() < lengthOrPrecision) {
                    column.setLength(pp2.getMaxPrecision().longValue());
                    return;
                }
            } else if (dbDataType instanceof LengthProperties && (pp = (LengthProperties)((Object)dbDataType)).getMaxLength() != null && pp.getMaxLength() < lengthOrPrecision) {
                column.setLength(pp.getMaxLength());
                return;
            }
            column.setLength(lengthOrPrecision);
        } else if (dbDataType instanceof LengthProperties) {
            column.setLength(((LengthProperties)((Object)dbDataType)).getDefaultLength());
        } else if (dbDataType instanceof PrecisionProperties) {
            column.setLength(((PrecisionProperties)((Object)dbDataType)).getDefaultPrecision());
        } else {
            column.setLength(null);
        }
    }

    private void setScale(DbDataType<?> dbDataType, Integer scale, DataTypeLengthProperties<?> column) {
        if (scale != null) {
            ScaleProperties sp;
            if (dbDataType instanceof ScaleProperties && (sp = (ScaleProperties)((Object)dbDataType)).getMaxScale() != null && sp.getMaxScale() < scale) {
                column.setScale(sp.getMaxScale());
                return;
            }
            column.setScale(scale);
        } else if (dbDataType instanceof ScaleProperties) {
            column.setScale(((ScaleProperties)((Object)dbDataType)).getDefaultScale());
        } else {
            column.setScale(null);
        }
    }

    public boolean setDbType(String productDataType, Long lengthOrPrecision, Integer scale, DataTypeLengthProperties<?> column) {
        return this.setDbType(null, productDataType, lengthOrPrecision, scale, column);
    }

    public void setDbType(String productDataType, DataTypeProperties<?> column) {
        Column temp = new Column();
        this.setDbType(productDataType, null, null, temp);
        column.setDataType(temp.getDataType());
        SchemaUtils.setDataTypeNameInternal(column.getDataTypeName(), temp);
    }

    protected void setIndexTypeName(String name, IndexType indexType) {
        this.indexTypeNameMap.put(name, indexType);
    }

    public String getProductName() {
        return DefaultDbType;
    }

    public String getSimpleName() {
        return DefaultDbType.toLowerCase();
    }

    public boolean supportsLimit() {
        return false;
    }

    public boolean supportsLimitOffset() {
        return false;
    }

    public boolean supportsIdentity() {
        return false;
    }

    public String getIdentityColumnString() {
        return null;
    }

    public boolean supportsSequence() {
        return false;
    }

    public boolean supportsWith() {
        return false;
    }

    public boolean supportsWithRecursive() {
        return false;
    }

    public boolean supportsTop() {
        return false;
    }

    public boolean supportsRownum() {
        return false;
    }

    public boolean supportsFunctionOverload() {
        return false;
    }

    public boolean supportsProcedureOverload() {
        return false;
    }

    public boolean supportsDomain() {
        return false;
    }

    public String domainCheckConstraintColumnName() {
        return null;
    }

    public String getIdentityInsertString() {
        return null;
    }

    public String getIdentitySelectString() {
        return null;
    }

    public String getSequenceNextValString(String sequenceName) {
        return null;
    }

    public boolean supportsMerge() {
        return false;
    }

    public char getCloseQuote() {
        return '\"';
    }

    public char getOpenQuote() {
        return '\"';
    }

    public boolean recommendsNTypeChar() {
        return false;
    }

    public boolean supportsColumnSequence() {
        return false;
    }

    public boolean supportsColumnFormula() {
        return false;
    }

    public String getCurrentDateFunction() {
        return "TO_DATE(TO_CHAR(CURRENT_TIMESTAMP, 'YYYY-MM-DD'), 'YYYY-MM-DD')";
    }

    public String getCurrentDateTimeFunction() {
        return "CURRENT_DATETIME";
    }

    public String getCurrentTimeFunction() {
        return "CURRENT_TIME";
    }

    public String getCurrentTimeWithTimeZoneFunction() {
        return null;
    }

    public String getCurrentTimestampFunction() {
        return "CURRENT_TIMESTAMP";
    }

    public String getCurrentTimestampWithTimeZoneFunction() {
        return "CURRENT_TIMESTAMP";
    }

    public String defaultSchema() {
        return null;
    }

    public boolean supportsDefaultValueFunction() {
        return false;
    }

    public boolean supportsDropCascade() {
        return false;
    }

    public boolean supportsCascadeDelete() {
        return false;
    }

    public DefaultCase getDefaultCase() {
        return DefaultCase.UpperCase;
    }

    public boolean supportsRuleOnDelete(CascadeRule rule) {
        return rule == CascadeRule.None;
    }

    public boolean supportsCascadeUpdate() {
        return false;
    }

    public boolean supportsCatalog() {
        return false;
    }

    public boolean supportsSchema() {
        return false;
    }

    public boolean supportsIndexNameTableScope() {
        return false;
    }

    public boolean supportsRuleOnUpdate(CascadeRule rule) {
        return rule == CascadeRule.None;
    }

    public boolean supportsCascadeRistrict() {
        return false;
    }

    public boolean supportsBatchExecuteResult() {
        return true;
    }

    public boolean supportsBatchExecuteGeneratedKeys() {
        return false;
    }

    public boolean isQuoted(String target) {
        if (CommonUtils.isEmpty(target)) {
            return false;
        }
        return target.charAt(0) == this.getOpenQuote() && target.charAt(target.length() - 1) == this.getCloseQuote();
    }

    public boolean needQuote(String target) {
        if (CommonUtils.isEmpty(target)) {
            return false;
        }
        if (this.isQuoted(target)) {
            return false;
        }
        boolean ret = this.quatePattern.matcher(target).matches();
        if (ret) {
            if (this.getDefaultCase() == DefaultCase.LowerCase) {
                if (CommonUtils.eq(target.toLowerCase(), target)) {
                    return false;
                }
            } else if (this.getDefaultCase() == DefaultCase.UpperCase) {
                if (CommonUtils.eq(target.toUpperCase(), target)) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    public String quote(String target) {
        if (CommonUtils.isEmpty(target)) {
            return target;
        }
        if (this.isQuoted(target)) {
            return target;
        }
        if (!this.needQuote(target)) {
            return target;
        }
        return this.doQuote(target);
    }

    protected String doQuote(String target) {
        StringBuilder builder = new StringBuilder(target.length() + 2);
        builder.append(this.getOpenQuote()).append(target).append(this.getCloseQuote());
        return builder.toString();
    }

    public String unQuote(String target) {
        if (this.isQuoted(target)) {
            return CommonUtils.unwrap(target, this.getCloseQuote(), this.getCloseQuote());
        }
        return target;
    }

    public boolean storesMixedCaseIdentifiers() {
        return false;
    }

    public boolean storesLowerCaseIdentifiers() {
        return false;
    }

    public String nativeCaseString(String value) {
        if (CommonUtils.isEmpty(value)) {
            return value;
        }
        if (!this.storesMixedCaseIdentifiers()) {
            if (this.storesLowerCaseIdentifiers()) {
                return value.toLowerCase();
            }
            return value.toUpperCase();
        }
        return value;
    }

    public boolean isOptimisticLockColumn(Column column) {
        return column.getDataType().isNumeric() && ("LOCK_VERSION".equalsIgnoreCase(column.getName()) || "LockVersion".equalsIgnoreCase(column.getName()));
    }

    protected void setDecimalType(Column column) {
        if (column.getScale() != 0) {
            return;
        }
        if (column.getLength() == 1L) {
            column.setDataType(DataType.BIT);
        } else if (column.getLength() < 3L) {
            column.setDataType(DataType.TINYINT);
        } else if (column.getLength() < 5L) {
            column.setDataType(DataType.SMALLINT);
        } else if (column.getLength() < 10L) {
            column.setDataType(DataType.INT);
        } else if (column.getLength() < 20L) {
            column.setDataType(DataType.BIGINT);
        } else {
            column.setDataType(DataType.DECIMAL);
        }
    }

    public String getSqlValueDefinition(Column column, Object value) {
        DbDataType<?> dbDataType = this.getDbDataType(column);
        if (dbDataType == null) {
            column.setDataTypeName(column.getDataTypeName());
            System.out.println(column);
        }
        if (value == null) {
            if (column.isNotNull() && column.getDefaultValue() != null) {
                return column.getDefaultValue();
            }
            return "NULL";
        }
        Converter converter = dbDataType.getSqlTextConverter();
        if (converter == null) {
            converter = dbDataType.getConverter();
        }
        if (converter == null) {
            converter = column.getConverter();
        }
        if (column.getDataType() != null && column.getDataType().isBinary() && value instanceof String) {
            String text = (String)value;
            return "'" + text + "'";
        }
        String text = converter.convertString(converter.convertObject(value));
        StringBuilder builder = new StringBuilder();
        if (dbDataType.getLiteralPrefix() != null) {
            builder.append(dbDataType.getLiteralPrefix());
        }
        if ("'".equals(dbDataType.getLiteralPrefix()) || "N'".equalsIgnoreCase(dbDataType.getLiteralPrefix())) {
            if ("'".equals(dbDataType.getLiteralSuffix())) {
                builder.append(text.replace("'", "''"));
            } else {
                builder.append(text);
            }
        } else {
            builder.append(text);
        }
        if (dbDataType.getLiteralSuffix() != null) {
            builder.append(dbDataType.getLiteralSuffix());
        }
        return builder.toString();
    }

    public String getValueForDisplay(Column column, Object value) {
        DbDataType<?> dbDataType = this.getDbDataType(column);
        if (value == null) {
            return "<NULL>";
        }
        Converter converter = dbDataType.getSqlTextConverter();
        if (converter == null) {
            converter = dbDataType.getConverter();
        }
        if (converter == null) {
            converter = column.getConverter();
        }
        String text = converter.convertString(converter.convertObject(value));
        return text;
    }

    public String[] getSystemSchema() {
        return this.SYSTEM_SCHEMA;
    }

    public DbDataTypeCollection getDbDataTypes() {
        return this.dbDataTypes;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        return this.getClass().equals(obj.getClass());
    }

    public IndexType getIndexType(String indexTypeName) {
        if (this.indexTypeNameMap.containsKey(indexTypeName)) {
            return this.indexTypeNameMap.get(indexTypeName);
        }
        return IndexType.parse(indexTypeName);
    }

    public boolean supportsIndexType(Table table, Index obj, IndexType indexType) {
        return this.indexTypeNameMap.containsValue(indexType);
    }

    public CatalogReader getCatalogReader() {
        return new JdbcCatalogReader(this);
    }

    public int hashCode() {
        return this.getProductName().hashCode();
    }

    public Dialect getNextVersionDialect() {
        if (this.nextVersionDialectSupplier == null) {
            return null;
        }
        return this.nextVersionDialectSupplier.get();
    }

    public String getObjectFullName(String catalogName, String schemaName, String objectName) {
        StringBuilder builder = new StringBuilder(CommonUtils.size(catalogName) + CommonUtils.size(schemaName) + CommonUtils.size(objectName) + 2);
        if (!CommonUtils.isEmpty(catalogName)) {
            builder.append(catalogName);
            builder.append('.');
        }
        if (!CommonUtils.isEmpty(schemaName)) {
            builder.append(schemaName);
            builder.append('.');
        }
        builder.append(objectName);
        return builder.toString();
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public SqlFactoryRegistry createSqlFactoryRegistry() {
        return new SimpleSqlFactoryRegistry(this);
    }

    public Set<Class<?>> supportedSchemaTypes() {
        return MetadataReaderUtils.supportedSchemaTypes(this.getCatalogReader());
    }

    @Override
    public int compareTo(Dialect o) {
        if (this.equals(o)) {
            return 0;
        }
        Set<Dialect> set = this.getNexts(this);
        if (set.contains(o)) {
            return -1;
        }
        set = this.getNexts(o);
        if (set.contains(this)) {
            return 1;
        }
        return 0;
    }

    private Set<Dialect> getNexts(Dialect o) {
        Set<Dialect> set = CommonUtils.linkedSet();
        while (o.getNextVersionDialect() != null && o != o.getNextVersionDialect()) {
            set.add(o.getNextVersionDialect());
            o = o.getNextVersionDialect();
        }
        return set;
    }

    public boolean supportsStandardOffsetFetchRows() {
        return false;
    }

    public AbstractSqlBuilder<?> createSqlBuilder() {
        return new SqlBuilder(this);
    }

    public SqlSplitter createSqlSplitter() {
        return new SqlSplitter(this);
    }

    public JdbcHandler createJdbcHandler(SqlNode sqlNode) {
        JdbcHandler jdbcHandler = new JdbcHandler(sqlNode);
        return jdbcHandler;
    }

    public void setChangeAndResetSqlDelimiter(SqlOperation operation) {
    }

    protected String getDelimiter(String sql, String[] delimiters) {
        for (int i = 0; i < delimiters.length; ++i) {
            String del = delimiters[i];
            if (sql.contains(del)) continue;
            return del;
        }
        int len = 2;
        while (true) {
            StringBuilder builder = new StringBuilder(len);
            for (int i = 0; i < delimiters.length; ++i) {
                for (int j = 0; j < len; ++j) {
                    builder.append(delimiters[i]);
                }
                String del = builder.toString();
                if (sql.contains(del)) continue;
                return del;
            }
            ++len;
        }
    }

    public boolean isDdlRollbackable() {
        return false;
    }

    public boolean matchDataTypeName(DataType dataType, String dataTypeName) {
        if (dataType == null) {
            return false;
        }
        if (dataTypeName == null) {
            return false;
        }
        if (CommonUtils.eqIgnoreCase(dataType.getTypeName(), dataTypeName)) {
            return true;
        }
        return dataType == DataType.BOOLEAN && "bool".equalsIgnoreCase(dataTypeName);
    }

    public static class DateTimeTypeHandler
    extends DefaultJdbcTypeHandler {
        private static final long serialVersionUID = -3446371652551511555L;

        public DateTimeTypeHandler(JDBCType jdbcType, Converter<?> converter) {
            super(jdbcType, converter);
        }

        @Override
        public void setObject(PreparedStatement stmt, int parameterIndex, Object x) throws SQLException {
            if (x == null) {
                stmt.setNull(parameterIndex, JDBCType.TIMESTAMP.getVendorTypeNumber());
                return;
            }
            Date val = (Date)CommonUtils.cast(this.statementConverter.convertObject(x));
            stmt.setObject(parameterIndex, (Object)DateUtils.truncateMilisecond(val), JDBCType.TIMESTAMP);
        }
    }
}

