/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.resolver.ProductNameDialectResolver;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.util.ClassFinder;
import com.sqlapp.util.DbUtils;
import com.sqlapp.util.SimpleBeanUtils;
import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DialectResolver
implements Serializable {
    protected static final Logger logger = LogManager.getLogger(DialectResolver.class);
    private static final long serialVersionUID = 1L;
    private final List<ProductNameDialectResolver> resolverList = new ArrayList<ProductNameDialectResolver>();
    private final Map<String, ProductNameDialectResolver> resolverMap = new ConcurrentHashMap<String, ProductNameDialectResolver>();
    private static final DialectResolver instance = new DialectResolver();
    private static final Dialect DEFAULT_DIALECT = new Dialect(null);

    public static DialectResolver getInstance() {
        return instance;
    }

    private DialectResolver() {
        this.initializeResolverList();
    }

    protected List<ProductNameDialectResolver> getResolverList() {
        return this.resolverList;
    }

    protected synchronized void initializeResolverList() {
        if (this.resolverList.size() > 0) {
            return;
        }
        List<Class<? extends ProductNameDialectResolver>> classes = this.getResolvers(Thread.currentThread().getContextClassLoader());
        if (classes.size() == 0) {
            classes = this.getResolvers(DialectResolver.class.getClassLoader());
        }
        for (Class<? extends ProductNameDialectResolver> clazz : classes) {
            ProductNameDialectResolver resolver = (ProductNameDialectResolver)SimpleBeanUtils.newInstance(clazz, new Object[0]);
            this.resolverList.add(resolver);
        }
        Collections.sort(this.resolverList);
        logger.debug("resolverList=" + this.resolverList);
        logger.debug("resolverList.size()=" + this.resolverList.size());
    }

    private List<Class<? extends ProductNameDialectResolver>> getResolvers(ClassLoader classLoader) {
        ClassFinder finder = new ClassFinder(classLoader);
        finder.setFilter(new Predicate<Class<?>>(){

            @Override
            public boolean test(Class<?> obj) {
                if (Modifier.isAbstract(obj.getModifiers())) {
                    return false;
                }
                return ProductNameDialectResolver.class.isAssignableFrom(obj);
            }
        });
        List<Class<? extends ProductNameDialectResolver>> classes = finder.findRecursive(DialectResolver.class.getPackage().getName());
        return classes;
    }

    public Dialect getDialect(Connection connection) {
        return this.getDialect(DbUtils.getDatabaseMetaData(connection));
    }

    public Dialect getDialect(DatabaseMetaData databaseMetaData) {
        ProductVersionInfo productVersionInfo = DbUtils.getProductVersionInfo(databaseMetaData);
        return this.getDialect(productVersionInfo.getName(), productVersionInfo.getMajorVersion(), productVersionInfo.getMinorVersion(), productVersionInfo.getRevision());
    }

    public Dialect getDialect(String dbProductName, int majorVersion, int minorVersion) {
        return this.getDialect(dbProductName, majorVersion, minorVersion, null);
    }

    public Dialect getDefaultDialect() {
        return DEFAULT_DIALECT;
    }

    public Dialect getDialect(String dbProductName, int majorVersion, int minorVersion, Integer revision) {
        ProductNameDialectResolver resolver = null;
        if (dbProductName != null) {
            dbProductName = dbProductName.trim();
        }
        if (dbProductName != null && this.getResolverMap().containsKey(dbProductName)) {
            resolver = this.getResolverMap().get(dbProductName);
            return resolver.getDialect(majorVersion, minorVersion, revision);
        }
        int size = this.getResolverList().size();
        for (int i = 0; i < size; ++i) {
            resolver = this.getResolverList().get(i);
            Dialect dialect = resolver.getDialect(dbProductName, majorVersion, minorVersion, revision);
            if (dialect == null) continue;
            this.getResolverMap().put(dbProductName, resolver);
            return dialect;
        }
        return this.getDefaultDialect();
    }

    public Map<String, ProductNameDialectResolver> getResolverMap() {
        return this.resolverMap;
    }
}

