/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.information_schema.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.TriggerReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.data.schemas.Trigger;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

public class ISTriggerReader
extends TriggerReader {
    protected ISTriggerReader(Dialect dialect) {
        super(dialect);
    }

    @Override
    protected List<Trigger> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlNode(productVersionInfo);
        final List<Trigger> result = CommonUtils.list();
        final Dialect dialect = this.getDialect();
        this.execute(connection, node, context, new ResultSetNextHandler(){

            @Override
            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                Trigger trigger = ISTriggerReader.this.createTrigger(rs);
                trigger.setDialect(dialect);
                result.add(trigger);
            }
        });
        return result;
    }

    protected Trigger createTrigger(ExResultSet rs) throws SQLException {
        Trigger trigger = new Trigger(this.getString(rs, "trigger_name"));
        trigger.setCatalogName(this.getString(rs, "TRIGGER_CATALOG"));
        trigger.setSchemaName(this.getString(rs, "TRIGGER_SCHEMA"));
        trigger.getEventManipulation().add(this.getString(rs, "EVENT_MANIPULATION"));
        trigger.setTableSchemaName(this.getString(rs, "EVENT_OBJECT_SCHEMA"));
        trigger.setTableName(this.getString(rs, "EVENT_OBJECT_TABLE"));
        trigger.setActionCondition(this.getString(rs, "ACTION_CONDITION"));
        trigger.setStatement(this.getString(rs, "ACTION_STATEMENT"));
        trigger.setActionTiming(this.getString(rs, "ACTION_TIMING"));
        trigger.setActionOrientation(this.getString(rs, "ACTION_ORIENTATION"));
        trigger.setActionReferenceOldRow(this.getString(rs, "ACTION_REFERENCE_OLD_ROW"));
        trigger.setActionReferenceNewRow(this.getString(rs, "ACTION_REFERENCE_NEW_ROW"));
        trigger.setCreatedAt(rs.getTimestamp("CREATED"));
        return trigger;
    }

    protected SqlNode getSqlNode(ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlNodeCache(ISTriggerReader.class).getString("triggers.sql");
        return node;
    }
}

