/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.jdbc.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.jdbc.metadata.JdbcProcedureArgumentReader;
import com.sqlapp.data.db.metadata.ProcedureReader;
import com.sqlapp.data.db.metadata.RoutineArgumentReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.Procedure;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.DbUtils;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.List;

public class JdbcProcedureReader
extends ProcedureReader {
    public JdbcProcedureReader(Dialect dialect) {
        super(dialect);
    }

    @Override
    protected List<Procedure> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        List<Procedure> list;
        ExResultSet rs = null;
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            rs = new ExResultSet(databaseMetaData.getProcedures(CommonUtils.coalesce(CommonUtils.emptyToNull(this.getCatalogName(context)), CommonUtils.emptyToNull(this.getCatalogName())), CommonUtils.coalesce(CommonUtils.emptyToNull(this.getSchemaName(context)), CommonUtils.emptyToNull(this.getSchemaName())), CommonUtils.coalesce(CommonUtils.emptyToNull(this.getObjectName(context)), CommonUtils.emptyToNull(this.getObjectName()))));
            List<Procedure> result = CommonUtils.list();
            while (rs.next()) {
                Procedure obj = this.createProcedure(rs);
                result.add(obj);
            }
            list = result;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                DbUtils.close(rs);
                throw throwable;
            }
        }
        DbUtils.close(rs);
        return list;
    }

    protected Procedure createProcedure(ExResultSet rs) throws SQLException {
        String catalog_name = this.getString(rs, "PROCEDURE_CAT");
        String schema_name = this.getString(rs, "PROCEDURE_SCHEM");
        String procedure_name = this.getString(rs, "PROCEDURE_NAME");
        String specific_name = this.getString(rs, "SPECIFIC_NAME");
        Procedure obj = new Procedure(procedure_name);
        obj.setCatalogName(catalog_name);
        obj.setSchemaName(schema_name);
        obj.setSpecificName(specific_name);
        obj.setRemarks(this.getString(rs, "REMARKS"));
        return obj;
    }

    @Override
    protected RoutineArgumentReader<?> newRoutineArgumentReader() {
        return new JdbcProcedureArgumentReader(this.getDialect());
    }
}

