/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.jdbc.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.jdbc.metadata.JdbcMetadataUtils;
import com.sqlapp.data.db.metadata.SynonymReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.data.schemas.Synonym;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.util.CommonUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

public class JdbcSynonymReader
extends SynonymReader {
    private String[] tableTypes = new String[]{"SYNONYM"};

    public JdbcSynonymReader(Dialect dialect) {
        super(dialect);
    }

    @Override
    protected List<Synonym> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        try {
            List<Table> tables = JdbcMetadataUtils.getMetadata(connection, CommonUtils.coalesce(CommonUtils.emptyToNull(this.getCatalogName(context)), CommonUtils.emptyToNull(this.getCatalogName())), CommonUtils.coalesce(CommonUtils.emptyToNull(this.getSchemaName(context)), CommonUtils.emptyToNull(this.getSchemaName())), CommonUtils.coalesce(CommonUtils.emptyToNull(this.getObjectName(context)), CommonUtils.emptyToNull(this.getObjectName())), this.getTableTypes());
            List<Synonym> result = CommonUtils.list();
            for (Table table : tables) {
                Synonym s = new Synonym(table.getName());
                result.add(s);
            }
            return result;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    protected String[] getTableTypes() {
        return this.tableTypes;
    }
}

