/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.AbstractCatalogNamedObjectMetadataReader;
import com.sqlapp.data.db.metadata.AssemblyFileReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.Assembly;
import com.sqlapp.data.schemas.DbObjects;
import com.sqlapp.data.schemas.SchemaObjectProperties;
import java.sql.Connection;
import java.sql.SQLException;

public abstract class AssemblyReader
extends AbstractCatalogNamedObjectMetadataReader<Assembly> {
    protected AssemblyReader(Dialect dialect) {
        super(dialect);
    }

    @Override
    protected void setMetadataDetail(Connection connection, Assembly obj) throws SQLException {
        obj.setDialect(this.getDialect());
        this.setObjectName(obj.getName());
        AssemblyFileReader assemblyFileReader = this.getAssemblyFileReader();
        if (assemblyFileReader != null) {
            assemblyFileReader.loadFull(connection, obj);
        }
    }

    protected AssemblyFileReader getAssemblyFileReader() {
        AssemblyFileReader reader = this.newAssemblyFileReader();
        if (reader != null) {
            reader.setCatalogName(this.getCatalogName());
            reader.setObjectName(this.getObjectName());
            this.initializeChild(reader);
        }
        return reader;
    }

    protected abstract AssemblyFileReader newAssemblyFileReader();

    @Override
    protected SchemaObjectProperties getSchemaObjectProperties() {
        return SchemaObjectProperties.ASSEMBLIES;
    }

    @Override
    protected String getNameLabel() {
        return DbObjects.ASSEMBLY.getCamelCaseNameLabel();
    }

    @Override
    protected String getObjectName(ParametersContext context) {
        return (String)context.get(this.getNameLabel());
    }
}

