/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.AbstractSchemaObjectReader;
import com.sqlapp.data.db.metadata.FunctionFamilyReader;
import com.sqlapp.data.db.metadata.MetadataReader;
import com.sqlapp.data.db.metadata.OperatorFamilyReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.DbObjects;
import com.sqlapp.data.schemas.FunctionFamily;
import com.sqlapp.data.schemas.OperatorClass;
import com.sqlapp.data.schemas.OperatorFamily;
import com.sqlapp.data.schemas.SchemaObjectProperties;
import com.sqlapp.util.CommonUtils;
import java.sql.Connection;
import java.util.List;

public abstract class OperatorClassReader
extends AbstractSchemaObjectReader<OperatorClass> {
    protected static final String OPERATOR_CLASS_NAME = "operator_class_name";

    protected OperatorClassReader(Dialect dialect) {
        super(dialect);
    }

    @Override
    protected SchemaObjectProperties getSchemaObjectProperties() {
        return SchemaObjectProperties.OPERATOR_CLASSES;
    }

    @Override
    protected String getNameLabel() {
        return DbObjects.OPERATOR_CLASS.getCamelCaseNameLabel();
    }

    @Override
    public List<OperatorClass> getAllFull(Connection connection) {
        ParametersContext context = this.defaultParametersContext(connection);
        List<OperatorClass> operatorClassList = this.getAll(connection, context);
        this.loadAllMetadata(connection, operatorClassList);
        return operatorClassList;
    }

    protected void loadAllMetadata(Connection connection, List<OperatorClass> operatorClassList) {
        FunctionFamilyReader fReader;
        OperatorFamilyReader oReader = this.getOperatorFamilyReader();
        if (oReader != null) {
            List<OperatorFamily> operatorFamilyList = oReader.getAllFull(connection);
            for (OperatorClass operatorClass : operatorClassList) {
                OperatorClassReader.addOperatorFamilies(operatorFamilyList, operatorClass);
            }
        }
        if ((fReader = this.getFunctionFamilyReader()) != null) {
            List<FunctionFamily> functionFamilyList = fReader.getAllFull(connection);
            for (OperatorClass operatorClass : operatorClassList) {
                OperatorClassReader.addFunctionFamilies(functionFamilyList, operatorClass);
            }
        }
    }

    protected static void addOperatorFamilies(List<OperatorFamily> operatorFamilyList, OperatorClass operatorClass) {
        for (OperatorFamily operatorFamily : operatorFamilyList) {
            if (!CommonUtils.eq(operatorClass.getCatalogName(), operatorFamily.getCatalogName()) || !CommonUtils.eq(operatorClass.getSchemaName(), operatorFamily.getSchemaName()) || !CommonUtils.eq(operatorClass.getName(), operatorFamily.getOperatorClassName())) continue;
            operatorClass.getOperatorFamilies().add(operatorFamily);
        }
    }

    protected static void addFunctionFamilies(List<FunctionFamily> functionFamilyList, OperatorClass operatorClass) {
        for (FunctionFamily functionFamily : functionFamilyList) {
            if (!CommonUtils.eq(operatorClass.getCatalogName(), functionFamily.getCatalogName()) || !CommonUtils.eq(operatorClass.getSchemaName(), functionFamily.getSchemaName()) || !CommonUtils.eq(operatorClass.getName(), functionFamily.getOperatorClassName())) continue;
            operatorClass.getFunctionFamilies().add(functionFamily);
        }
    }

    protected OperatorFamilyReader getOperatorFamilyReader() {
        OperatorFamilyReader reader = this.newOperatorFamilyReader();
        reader.setCatalogName(this.getCatalogName());
        reader.setSchemaName(this.getSchemaName());
        reader.setObjectName(this.getObjectName());
        this.setReaderParameter(reader);
        return reader;
    }

    protected void setReaderParameter(MetadataReader<?, ?> reader) {
        if (reader != null) {
            this.initializeChild(reader);
        }
    }

    protected abstract OperatorFamilyReader newOperatorFamilyReader();

    protected FunctionFamilyReader getFunctionFamilyReader() {
        FunctionFamilyReader reader = this.newFunctionFamilyReader();
        reader.setCatalogName(this.getCatalogName());
        reader.setSchemaName(this.getSchemaName());
        reader.setObjectName(this.getObjectName());
        this.setReaderParameter(reader);
        return reader;
    }

    protected abstract FunctionFamilyReader newFunctionFamilyReader();
}

