/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.AbstractCatalogNamedObjectMetadataReader;
import com.sqlapp.data.db.metadata.AbstractSchemaObjectReader;
import com.sqlapp.data.db.metadata.CatalogReader;
import com.sqlapp.data.db.metadata.ConstantReader;
import com.sqlapp.data.db.metadata.DbLinkReader;
import com.sqlapp.data.db.metadata.DimensionReader;
import com.sqlapp.data.db.metadata.DomainReader;
import com.sqlapp.data.db.metadata.EventReader;
import com.sqlapp.data.db.metadata.ExternalTableReader;
import com.sqlapp.data.db.metadata.FunctionReader;
import com.sqlapp.data.db.metadata.MaskReader;
import com.sqlapp.data.db.metadata.MetadataReader;
import com.sqlapp.data.db.metadata.MetadataReaderUtils;
import com.sqlapp.data.db.metadata.MviewLogReader;
import com.sqlapp.data.db.metadata.MviewReader;
import com.sqlapp.data.db.metadata.OperatorClassReader;
import com.sqlapp.data.db.metadata.OperatorReader;
import com.sqlapp.data.db.metadata.PackageBodyReader;
import com.sqlapp.data.db.metadata.PackageReader;
import com.sqlapp.data.db.metadata.ProcedureReader;
import com.sqlapp.data.db.metadata.RuleReader;
import com.sqlapp.data.db.metadata.SequenceReader;
import com.sqlapp.data.db.metadata.SettingReader;
import com.sqlapp.data.db.metadata.SynonymReader;
import com.sqlapp.data.db.metadata.TableLinkReader;
import com.sqlapp.data.db.metadata.TableReader;
import com.sqlapp.data.db.metadata.TriggerReader;
import com.sqlapp.data.db.metadata.TypeBodyReader;
import com.sqlapp.data.db.metadata.TypeReader;
import com.sqlapp.data.db.metadata.ViewReader;
import com.sqlapp.data.db.metadata.XmlSchemaReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.Catalog;
import com.sqlapp.data.schemas.Schema;
import com.sqlapp.data.schemas.SchemaCollection;
import com.sqlapp.data.schemas.SchemaObjectProperties;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.SchemaUtils;
import com.sqlapp.data.schemas.SettingCollection;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

public abstract class SchemaReader
extends AbstractCatalogNamedObjectMetadataReader<Schema> {
    private String schemaName;
    private SettingCollection settings = null;

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    protected SchemaReader(Dialect dialect) {
        super(dialect);
    }

    @Override
    protected SchemaCollection getSchemaObjectList(Catalog catalog) {
        return catalog.getSchemas();
    }

    @Override
    protected SchemaObjectProperties getSchemaObjectProperties() {
        return SchemaObjectProperties.SCHEMAS;
    }

    @Override
    public void loadFull(Connection connection, Schema schema) throws SQLException {
        this.setCommonBefore(connection);
        schema.setDialect(this.getDialect());
        CatalogReader.setProductInfo(connection, this.getDialect(), schema);
        this.setSchemaBefore(connection, schema);
        this.loadFull(connection, this.getDomainReader(), schema);
        this.loadFull(connection, this.getTypeReader(), schema);
        this.loadFull(connection, this.getTypeBodyReader(), schema);
        this.loadFull(connection, this.getTableReader(), schema);
        this.loadFull(connection, this.getViewReader(), schema);
        this.loadFull(connection, this.getMviewReader(), schema);
        this.loadFull(connection, this.getMviewLogReader(), schema);
        this.loadFull(connection, this.getMaskReader(), schema);
        this.loadFull(connection, this.getSequenceReader(), schema);
        this.loadFull(connection, this.getTriggerReader(), schema);
        this.loadFull(connection, this.getDbLinkReader(), schema);
        this.loadFull(connection, this.getRuleReader(), schema);
        this.loadFull(connection, this.getTableLinkReader(), schema);
        this.loadFull(connection, this.getFunctionReader(), schema);
        this.loadFull(connection, this.getProcedureReader(), schema);
        this.loadFull(connection, this.getPackageReader(), schema);
        this.loadFull(connection, this.getPackageBodyReader(), schema);
        this.loadFull(connection, this.getConstantReader(), schema);
        this.loadFull(connection, this.getXmlSchemaReader(), schema);
        this.loadFull(connection, this.getOperatorReader(), schema);
        this.loadFull(connection, this.getOperatorClassReader(), schema);
        this.loadFull(connection, this.getExternalTableReader(), schema);
        this.loadFull(connection, this.getEventReader(), schema);
        this.loadFull(connection, this.getDimensionReader(), schema);
        this.loadFull(connection, this.getSynonymReader(), schema);
        this.setSchemaAfter(connection, schema);
        SchemaUtils.validate(schema);
    }

    public void load(Connection connection, Schema schema) throws SQLException {
        this.setCommonBefore(connection);
        schema.setDialect(this.getDialect());
        CatalogReader.setProductInfo(connection, this.getDialect(), schema);
        this.setSchemaBefore(connection, schema);
        this.load(connection, this.getDomainReader(), schema);
        this.load(connection, this.getTypeReader(), schema);
        this.load(connection, this.getTypeBodyReader(), schema);
        this.load(connection, this.getTableReader(), schema);
        this.load(connection, this.getViewReader(), schema);
        this.load(connection, this.getMviewReader(), schema);
        this.load(connection, this.getMviewLogReader(), schema);
        this.load(connection, this.getMaskReader(), schema);
        this.load(connection, this.getSequenceReader(), schema);
        this.load(connection, this.getTriggerReader(), schema);
        this.load(connection, this.getDbLinkReader(), schema);
        this.load(connection, this.getRuleReader(), schema);
        this.load(connection, this.getTableLinkReader(), schema);
        this.load(connection, this.getFunctionReader(), schema);
        this.load(connection, this.getProcedureReader(), schema);
        this.load(connection, this.getPackageReader(), schema);
        this.load(connection, this.getPackageBodyReader(), schema);
        this.load(connection, this.getConstantReader(), schema);
        this.load(connection, this.getXmlSchemaReader(), schema);
        this.load(connection, this.getOperatorReader(), schema);
        this.load(connection, this.getOperatorClassReader(), schema);
        this.load(connection, this.getExternalTableReader(), schema);
        this.load(connection, this.getEventReader(), schema);
        this.load(connection, this.getDimensionReader(), schema);
        this.load(connection, this.getSynonymReader(), schema);
        this.setSchemaAfter(connection, schema);
    }

    @Override
    protected void setMetadataDetail(Connection connection, Schema schema) throws SQLException {
        this.loadFull(connection, schema);
    }

    protected SettingCollection getSettings() {
        return this.settings;
    }

    protected void setSettings(SettingCollection settings) {
        this.settings = settings;
    }

    protected void setCommonBefore(Connection connection) {
        CatalogReader catalogReader;
        SettingReader settingReader;
        if (this.settings == null && (settingReader = (catalogReader = (CatalogReader)this.getParent()).getSettingReader()) != null) {
            List list = settingReader.getAllFull(connection);
            this.settings = (SettingCollection)SchemaUtils.createInstance("settings");
            this.settings.addAll(list);
        }
    }

    protected void setSchemaBefore(Connection connection, Schema schema) {
    }

    protected void setSchemaAfter(Connection connection, Schema schema) {
    }

    private void loadFull(Connection connection, AbstractSchemaObjectReader<?> reader, Schema schema) {
        if (reader != null) {
            reader.setCatalogName(schema.getCatalogName());
            reader.setSchemaName(schema.getName());
            reader.loadFull(connection, schema);
        }
    }

    private void load(Connection connection, AbstractSchemaObjectReader<?> reader, Schema schema) {
        if (reader != null) {
            reader.setCatalogName(schema.getCatalogName());
            reader.setSchemaName(schema.getName());
            reader.load(connection, schema);
        }
    }

    public String getCurrentSchemaName(Connection connection) {
        try {
            return connection.getSchema();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public TableReader getTableReader() {
        TableReader reader = this.newTableReader();
        this.setReaderParameter(reader);
        return reader;
    }

    protected void setReaderParameter(AbstractSchemaObjectReader<?> reader) {
        if (reader != null) {
            reader.setCatalogName(this.getCatalogName());
            reader.setSchemaName(this.getSchemaName());
            reader.setObjectName(this.getObjectName());
            this.initializeChild(reader);
        }
    }

    protected abstract TableReader newTableReader();

    public ViewReader getViewReader() {
        ViewReader reader = this.newViewReader();
        this.setReaderParameter(reader);
        return reader;
    }

    protected abstract ViewReader newViewReader();

    public MviewReader getMviewReader() {
        MviewReader reader = this.newMviewReader();
        this.setReaderParameter(reader);
        return reader;
    }

    protected abstract MviewReader newMviewReader();

    public MviewLogReader getMviewLogReader() {
        MviewLogReader reader = this.newMviewLogReader();
        this.setReaderParameter(reader);
        return reader;
    }

    protected abstract MviewLogReader newMviewLogReader();

    public SequenceReader getSequenceReader() {
        SequenceReader reader = this.newSequenceReader();
        this.setReaderParameter(reader);
        return reader;
    }

    protected abstract SequenceReader newSequenceReader();

    public DbLinkReader getDbLinkReader() {
        DbLinkReader reader = this.newDbLinkReader();
        this.setReaderParameter(reader);
        return reader;
    }

    protected abstract DbLinkReader newDbLinkReader();

    public DomainReader getDomainReader() {
        DomainReader reader = this.newDomainReader();
        this.setReaderParameter(reader);
        return reader;
    }

    protected abstract DomainReader newDomainReader();

    public TypeReader getTypeReader() {
        TypeReader reader = this.newTypeReader();
        this.setReaderParameter(reader);
        return reader;
    }

    protected abstract TypeReader newTypeReader();

    public TypeBodyReader getTypeBodyReader() {
        TypeBodyReader reader = this.newTypeBodyReader();
        this.setReaderParameter(reader);
        return reader;
    }

    protected abstract TypeBodyReader newTypeBodyReader();

    public SynonymReader getSynonymReader() {
        SynonymReader reader = this.newSynonymReader();
        this.setReaderParameter(reader);
        return reader;
    }

    protected abstract SynonymReader newSynonymReader();

    public TableLinkReader getTableLinkReader() {
        TableLinkReader reader = this.newTableLinkReader();
        this.setReaderParameter(reader);
        return reader;
    }

    protected abstract TableLinkReader newTableLinkReader();

    public RuleReader getRuleReader() {
        RuleReader reader = this.newRuleReader();
        this.setReaderParameter(reader);
        return reader;
    }

    protected abstract RuleReader newRuleReader();

    public FunctionReader getFunctionReader() {
        FunctionReader reader = this.newFunctionReader();
        this.setReaderParameter(reader);
        return reader;
    }

    protected abstract FunctionReader newFunctionReader();

    public ProcedureReader getProcedureReader() {
        ProcedureReader reader = this.newProcedureReader();
        this.setReaderParameter(reader);
        return reader;
    }

    protected abstract ProcedureReader newProcedureReader();

    public PackageReader getPackageReader() {
        PackageReader reader = this.newPackageReader();
        this.setReaderParameter(reader);
        return reader;
    }

    protected abstract PackageReader newPackageReader();

    public PackageBodyReader getPackageBodyReader() {
        PackageBodyReader reader = this.newPackageBodyReader();
        this.setReaderParameter(reader);
        return reader;
    }

    protected abstract PackageBodyReader newPackageBodyReader();

    public ConstantReader getConstantReader() {
        ConstantReader reader = this.newConstantReader();
        this.setReaderParameter(reader);
        return reader;
    }

    protected abstract ConstantReader newConstantReader();

    public TriggerReader getTriggerReader() {
        TriggerReader reader = this.newTriggerReader();
        this.setReaderParameter(reader);
        return reader;
    }

    protected abstract TriggerReader newTriggerReader();

    public XmlSchemaReader getXmlSchemaReader() {
        XmlSchemaReader reader = this.newXmlSchemaReader();
        this.setReaderParameter(reader);
        return reader;
    }

    protected abstract XmlSchemaReader newXmlSchemaReader();

    public OperatorReader getOperatorReader() {
        OperatorReader reader = this.newOperatorReader();
        this.setReaderParameter(reader);
        return reader;
    }

    protected abstract OperatorReader newOperatorReader();

    public OperatorClassReader getOperatorClassReader() {
        OperatorClassReader reader = this.newOperatorClassReader();
        this.setReaderParameter(reader);
        return reader;
    }

    protected abstract OperatorClassReader newOperatorClassReader();

    public ExternalTableReader getExternalTableReader() {
        ExternalTableReader reader = this.newExternalTableReader();
        this.setReaderParameter(reader);
        return reader;
    }

    protected abstract ExternalTableReader newExternalTableReader();

    public DimensionReader getDimensionReader() {
        DimensionReader reader = this.newDimensionReader();
        this.setReaderParameter(reader);
        return reader;
    }

    protected abstract DimensionReader newDimensionReader();

    public EventReader getEventReader() {
        EventReader reader = this.newEventReader();
        this.setReaderParameter(reader);
        return reader;
    }

    protected abstract EventReader newEventReader();

    public MaskReader getMaskReader() {
        MaskReader reader = this.newMaskReader();
        this.setReaderParameter(reader);
        return reader;
    }

    protected abstract MaskReader newMaskReader();

    @Override
    protected ParametersContext defaultParametersContext(Connection connection) {
        ParametersContext context = this.newParametersContext(connection, this.getCatalogName());
        context.put(this.getNameLabel(), (Object)this.nativeCaseString(connection, this.getSchemaName()));
        return context;
    }

    @Override
    protected String getNameLabel() {
        return SchemaProperties.SCHEMA_NAME.getLabel();
    }

    protected <T extends MetadataReader<?, ?>> T getMetadataReader(String name) {
        if ("schema".equalsIgnoreCase(name) || "schemas".equalsIgnoreCase(name)) {
            return (T)this;
        }
        return MetadataReaderUtils.getMetadataReader(this, name);
    }
}

