/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.AbstractNamedMetadataReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.DbObjects;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.Type;
import com.sqlapp.data.schemas.TypeColumn;
import com.sqlapp.data.schemas.TypeColumnCollection;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.TripleKeyMap;
import java.sql.Connection;
import java.util.List;

public abstract class TypeColumnReader
extends AbstractNamedMetadataReader<TypeColumn, Type> {
    protected final String TYPE_NAME = "type_name";
    private String schemaName = null;
    private String columnName = null;

    protected TypeColumnReader(Dialect dialect) {
        super(dialect);
    }

    @Override
    public void loadFull(Connection connection, Type tp) {
        List list = this.getAllFull(connection);
        int size = list.size();
        TypeColumnCollection c = this.getSchemaObjectList(tp);
        for (int i = 0; i < size; ++i) {
            TypeColumn obj = (TypeColumn)list.get(i);
            c.add(obj);
        }
    }

    @Override
    public void load(Connection connection, Type tp) {
        List list = this.getAll(connection);
        int size = list.size();
        TypeColumnCollection c = this.getSchemaObjectList(tp);
        for (int i = 0; i < size; ++i) {
            TypeColumn obj = (TypeColumn)list.get(i);
            c.add(obj);
        }
    }

    protected TypeColumnCollection getSchemaObjectList(Type tp) {
        return tp.getColumns();
    }

    @Override
    protected ParametersContext defaultParametersContext(Connection connection) {
        ParametersContext context = this.newParametersContext(connection, this.getCatalogName(), this.getSchemaName());
        context.put(DbObjects.TYPE.getCamelCaseNameLabel(), (Object)this.nativeCaseString(connection, this.getObjectName()));
        context.put(this.getNameLabel(), (Object)this.nativeCaseString(connection, this.getColumnName()));
        return context;
    }

    protected TripleKeyMap<String, String, String, List<TypeColumn>> toKeyMap(List<TypeColumn> list) {
        TripleKeyMap<String, String, String, List<TypeColumn>> map = new TripleKeyMap<String, String, String, List<TypeColumn>>();
        for (TypeColumn obj : list) {
            List<TypeColumn> tableConsts = map.get(obj.getCatalogName(), obj.getSchemaName(), obj.getDataTypeName());
            if (tableConsts == null) {
                tableConsts = CommonUtils.list();
                map.put(obj.getCatalogName(), obj.getSchemaName(), obj.getDataTypeName(), tableConsts);
            }
            tableConsts.add(obj);
        }
        return map;
    }

    @Override
    protected String getNameLabel() {
        return SchemaProperties.COLUMN_NAME.getLabel();
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    protected TypeColumn createObject() {
        TypeColumn obj = new TypeColumn();
        obj.setDialect(this.getDialect());
        return obj;
    }

    protected TypeColumn createObject(String name) {
        TypeColumn obj = new TypeColumn(name);
        obj.setDialect(this.getDialect());
        return obj;
    }
}

