/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.sql;

import com.sqlapp.data.db.sql.AbstractTableFactory;
import com.sqlapp.data.db.sql.AddTableObjectDetailFactory;
import com.sqlapp.data.db.sql.SqlOperation;
import com.sqlapp.data.db.sql.SqlType;
import com.sqlapp.data.schemas.CheckConstraint;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.Constraint;
import com.sqlapp.data.schemas.DbObjectDifference;
import com.sqlapp.data.schemas.ExcludeConstraint;
import com.sqlapp.data.schemas.ForeignKeyConstraint;
import com.sqlapp.data.schemas.Index;
import com.sqlapp.data.schemas.SchemaUtils;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.data.schemas.UniqueConstraint;
import com.sqlapp.util.AbstractSqlBuilder;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.FlexList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public abstract class AbstractCreateTableFactory<S extends AbstractSqlBuilder<?>>
extends AbstractTableFactory<S> {
    @Override
    public List<SqlOperation> createSql(Table table) {
        List<SqlOperation> sqlList = CommonUtils.list();
        Object builder = this.createSqlBuilder();
        this.addCreateObject(table, builder);
        ((AbstractSqlBuilder)((AbstractSqlBuilder)builder).lineBreak()).brackets(() -> {
            builder.indent(() -> {
                for (int i = 0; i < table.getColumns().size(); ++i) {
                    Column column = (Column)table.getColumns().get(i);
                    builder.lineBreak();
                    ((AbstractSqlBuilder)builder.comma(i > 0)).space(2, i == 0);
                    ((AbstractSqlBuilder)((AbstractSqlBuilder)builder.name(column)).space()).definition(column, this.getOptions().getTableOptions().getWithColumnRemarks().test(column));
                }
                this.addIndexDefinitions(table, builder);
                this.addConstraintDefinitions(table, builder);
            });
            builder.lineBreak();
        });
        this.addOption(table, builder);
        this.addSql(sqlList, (AbstractSqlBuilder<?>)builder, SqlType.CREATE, table);
        this.addIndexDefinitions(table, sqlList);
        this.addOtherDefinitions(table, sqlList);
        return sqlList;
    }

    @Override
    protected List<Table> sort(List<Table> c) {
        return SchemaUtils.getNewSortedTableList(c, Table.TableOrder.CREATE.getComparator());
    }

    @Override
    protected List<DbObjectDifference> sortDbObjectDifference(List<DbObjectDifference> list) {
        return this.sort(list, Table.TableOrder.CREATE.getComparator());
    }

    private List<DbObjectDifference> sort(List<DbObjectDifference> list, Comparator<Table> comparator) {
        List tables = CommonUtils.list(list.size());
        for (DbObjectDifference dbObjectDifference : list) {
            tables.add((Table)dbObjectDifference.getTarget());
        }
        Collections.sort(tables, comparator);
        FlexList<DbObjectDifference> result = new FlexList<DbObjectDifference>();
        for (int i = 0; i < tables.size(); ++i) {
            Table table = (Table)tables.get(i);
            for (DbObjectDifference dbObjectDifference : list) {
                if (table != dbObjectDifference.getTarget()) continue;
                result.add(dbObjectDifference);
            }
        }
        return result;
    }

    protected void addCreateObject(Table obj, S builder) {
        ((AbstractSqlBuilder)((AbstractSqlBuilder)builder).create()).table();
        ((AbstractSqlBuilder)builder).name(obj, this.getOptions().isDecorateSchemaName());
    }

    protected void addIndexDefinitions(Table table, S builder) {
    }

    protected void addConstraintDefinitions(Table table, S builder) {
        this.addUniqueConstraintDefinitions(table, builder);
        this.addCheckConstraintDefinitions(table, builder);
        this.addForeignKeyConstraintDefinitions(table, builder);
        this.addExcludeConstraintDefinitions(table, builder);
    }

    protected void addOtherDefinitions(Table table, List<SqlOperation> result) {
    }

    protected void addIndexDefinitions(Table table, List<SqlOperation> result) {
        for (Index index : table.getIndexes()) {
            this.addCreateIndexDefinition(table, index, result);
        }
    }

    protected void addCreateIndexDefinition(Table table, Index index, List<SqlOperation> result) {
        Object builder = this.createSqlBuilder();
        this.addCreateIndexDefinition(index, builder);
        this.add(result, this.createOperation(((AbstractSqlBuilder)builder).toString(), SqlType.CREATE, index));
    }

    protected void addUniqueConstraintDefinitions(Table table, S builder) {
        for (UniqueConstraint uniqueConstraint : table.getConstraints().getUniqueConstraints()) {
            this.addConstraintDefinition(uniqueConstraint, builder);
        }
    }

    protected void addConstraintDefinition(Constraint obj, S builder) {
        AddTableObjectDetailFactory sqlFactory = this.getAddTableObjectDetailOperationFactory(obj);
        if (sqlFactory != null) {
            ((AbstractSqlBuilder)((AbstractSqlBuilder)builder).lineBreak()).comma();
            if (obj.getParent() != null) {
                sqlFactory.addObjectDetail(obj, obj.getParent().getParent(), builder);
            } else {
                sqlFactory.addObjectDetail(obj, null, builder);
            }
        }
    }

    protected void addExcludeConstraintDefinitions(Table table, S builder) {
        for (ExcludeConstraint excludeConstraint : table.getConstraints().getExcludeConstraints()) {
            this.addConstraintDefinition(excludeConstraint, builder);
        }
    }

    protected void addCheckConstraintDefinitions(Table table, S builder) {
        for (CheckConstraint checkConstraint : table.getConstraints().getCheckConstraints()) {
            this.addConstraintDefinition(checkConstraint, builder);
        }
    }

    protected void addForeignKeyConstraintDefinitions(Table table, S builder) {
        for (ForeignKeyConstraint constraint : table.getConstraints().getForeignKeyConstraints()) {
            this.addConstraintDefinition(constraint, builder);
        }
    }

    protected void addOption(Table table, S builder) {
    }
}

