/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.sql;

import com.sqlapp.data.db.sql.SimpleSqlFactory;
import com.sqlapp.data.db.sql.SqlOperation;
import com.sqlapp.data.db.sql.SqlType;
import com.sqlapp.data.schemas.AbstractNamedObject;
import com.sqlapp.data.schemas.AbstractSchemaObject;
import com.sqlapp.data.schemas.DbCommonObject;
import com.sqlapp.data.schemas.Mview;
import com.sqlapp.data.schemas.PublicSynonym;
import com.sqlapp.data.schemas.TypeBody;
import com.sqlapp.util.AbstractSqlBuilder;
import com.sqlapp.util.CommonUtils;
import java.util.List;

public abstract class AbstractDropNamedObjectFactory<T extends AbstractNamedObject<?>, S extends AbstractSqlBuilder<?>>
extends SimpleSqlFactory<T, S> {
    @Override
    public List<SqlOperation> createSql(T obj) {
        Object builder = this.createSqlBuilder();
        this.addDropObject(obj, builder);
        List<SqlOperation> sqlList = CommonUtils.list();
        this.addSql(sqlList, (AbstractSqlBuilder<?>)builder, SqlType.DROP, (DbCommonObject<?>)obj);
        return sqlList;
    }

    protected void addDropObject(T obj, S builder) {
        ((AbstractSqlBuilder)((AbstractSqlBuilder)builder).drop()).space();
        ((AbstractSqlBuilder)builder)._add(obj.getClass().getSimpleName().toUpperCase());
        if (obj instanceof AbstractSchemaObject) {
            ((AbstractSqlBuilder)builder).name((AbstractSchemaObject)obj, this.getOptions().isDecorateSchemaName());
        } else {
            ((AbstractSqlBuilder)builder).name((AbstractNamedObject<?>)obj);
        }
    }

    protected void appendName(T obj, S builder) {
        if (obj instanceof Mview) {
            ((AbstractSqlBuilder)((AbstractSqlBuilder)builder).materialized()).view();
        } else if (obj instanceof TypeBody) {
            ((AbstractSqlBuilder)((AbstractSqlBuilder)builder).type()).body();
        } else if (obj instanceof PublicSynonym) {
            ((AbstractSqlBuilder)((AbstractSqlBuilder)builder)._add("PUBLIC")).synonym();
        } else {
            ((AbstractSqlBuilder)builder)._add(obj.getClass().getSimpleName().toUpperCase());
        }
    }
}

