/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.sql;

import com.sqlapp.data.db.datatype.DbDataType;
import com.sqlapp.data.db.sql.AddTableObjectDetailFactory;
import com.sqlapp.data.db.sql.SimpleSqlFactory;
import com.sqlapp.data.db.sql.SqlType;
import com.sqlapp.data.db.sql.TableLockMode;
import com.sqlapp.data.schemas.AbstractDbObject;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.Index;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.data.schemas.UniqueConstraint;
import com.sqlapp.util.AbstractSqlBuilder;
import com.sqlapp.util.CommonUtils;
import java.util.List;

public abstract class AbstractTableFactory<S extends AbstractSqlBuilder<?>>
extends SimpleSqlFactory<Table, S> {
    protected void addSelectAllColumns(Table obj, S builder) {
        if (this.getOptions().getTableOptions().getSelectAllColumnASAsterisk().test(obj)) {
            ((AbstractSqlBuilder)builder).lineBreak();
            ((AbstractSqlBuilder)builder)._add("*");
            ((AbstractSqlBuilder)builder).lineBreak();
        } else {
            boolean first = true;
            for (Column column : obj.getColumns()) {
                ((AbstractSqlBuilder)builder).lineBreak();
                ((AbstractSqlBuilder)builder).comma(!first);
                ((AbstractSqlBuilder)builder).name(column);
                String comment = (String)this.getOptions().getTableOptions().getSelectColumnComment().apply((String)((Object)column));
                if (!CommonUtils.isEmpty(comment) && !CommonUtils.eqIgnoreCase(comment, column.getName())) {
                    ((AbstractSqlBuilder)((AbstractSqlBuilder)builder).space()).addComment(comment);
                }
                first = false;
            }
            ((AbstractSqlBuilder)builder).lineBreak();
        }
    }

    protected void addUniqueColumnsCondition(Table table, S builder) {
        ((AbstractSqlBuilder)builder).setQuateObjectName(this.getOptions().isQuateColumnName());
        List<Column> columns = table.getUniqueColumns();
        ((AbstractSqlBuilder)builder).indent(() -> {
            if (CommonUtils.isEmpty(columns)) {
                for (Column column : table.getColumns()) {
                    builder.lineBreak();
                    ((AbstractSqlBuilder)builder.and()).name(column);
                    ((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)builder.space()).eq()).space())._add(this.getValueDefinitionSimple(column));
                }
            } else {
                for (Column column : columns) {
                    builder.lineBreak();
                    ((AbstractSqlBuilder)builder.and()).name(column);
                    ((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)builder.space()).eq()).space())._add(this.getValueDefinitionSimple(column));
                }
            }
        });
        ((AbstractSqlBuilder)builder).setQuateObjectName(false);
    }

    protected void addLockVersionColumnCondition(Table table, S builder) {
        ((AbstractSqlBuilder)builder).indent(() -> {
            for (Column column : table.getColumns()) {
                if (!this.isOptimisticLockColumn(column)) continue;
                builder.lineBreak();
                ((AbstractSqlBuilder)builder.and()).name(column);
                String value = this.getOptimisticLockColumnCondition(column);
                ((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)builder.space()).eq()).space())._add(value);
                break;
            }
        });
    }

    protected void addConditionColumns(Table obj, S builder) {
        ((AbstractSqlBuilder)builder).indent(() -> {
            for (Column column : obj.getColumns()) {
                this.addConditions(column, builder);
            }
        });
    }

    protected void addConditions(Column column, S builder) {
        this.addConditionIn(column, builder);
        this.addConditionNotIn(column, builder);
        if (column.getDataType() == null) {
            return;
        }
        if (column.getDataType().isCharacter()) {
            this.addConditionStartsWith(column, builder);
            this.addConditionEndsWith(column, builder);
            this.addConditionContains(column, builder);
        } else if (!column.getDataType().isBinary() && !column.getDataType().isBoolean()) {
            this.addConditionGt(column, builder);
            this.addConditionLt(column, builder);
            this.addConditionGte(column, builder);
            this.addConditionLte(column, builder);
        }
    }

    protected TableLockMode getLockMode(Table table) {
        return this.getOptions().getTableOptions().getLockMode().apply(table);
    }

    protected void addConditionIn(Column column, S builder) {
        ((AbstractSqlBuilder)((AbstractSqlBuilder)builder).lineBreak())._add(this.toIfIsNotEmptyExpression(column.getName()));
        ((AbstractSqlBuilder)builder).lineBreak();
        ((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)builder).and()).space()).name(column)).space()).in()).space()).addComment(column.getName());
        this.addConditionInValue(column, builder);
        ((AbstractSqlBuilder)((AbstractSqlBuilder)builder).lineBreak())._add(this.getEndIfExpression());
    }

    protected void addConditionNotIn(Column column, S builder) {
        ((AbstractSqlBuilder)((AbstractSqlBuilder)builder).lineBreak())._add(this.toIfIsNotEmptyExpression(column.getName() + "_neq"));
        ((AbstractSqlBuilder)builder).lineBreak();
        ((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)builder).and()).space()).name(column)).space()).not()).in()).space()).addComment(column.getName() + "_neq");
        this.addConditionInValue(column, builder);
        ((AbstractSqlBuilder)((AbstractSqlBuilder)builder).lineBreak())._add(this.getEndIfExpression());
    }

    protected String toIfExpression(String column) {
        return (String)this.getOptions().getTableOptions().getIfStartExpression().apply(column);
    }

    protected String toIfIsNotEmptyExpression(String column) {
        return (String)this.getOptions().getTableOptions().getIfStartExpression().apply(this.toIsNotEmptyExpression(column));
    }

    protected String toIsNotEmptyExpression(String column) {
        return (String)this.getOptions().getTableOptions().getIsNotEmptyExpression().apply(column);
    }

    protected String getEndIfExpression() {
        return (String)this.getOptions().getTableOptions().getEndIfExpression().get();
    }

    protected void addConditionContains(Column column, S builder) {
        ((AbstractSqlBuilder)((AbstractSqlBuilder)builder).lineBreak())._add(this.toIfIsNotEmptyExpression(column.getName() + "_contains"));
        ((AbstractSqlBuilder)builder).lineBreak();
        ((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)builder).and()).space()).name(column)).space()).like()).space()).addComment("'%' + " + column.getName() + "_contains + '%'");
        this.addConditionValue(column, builder);
        ((AbstractSqlBuilder)((AbstractSqlBuilder)builder).lineBreak())._add(this.getEndIfExpression());
    }

    protected void addConditionStartsWith(Column column, S builder) {
        ((AbstractSqlBuilder)((AbstractSqlBuilder)builder).lineBreak())._add(this.toIfIsNotEmptyExpression(column.getName() + "_startsWith"));
        ((AbstractSqlBuilder)builder).lineBreak();
        ((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)builder).and()).space()).name(column)).space()).like()).space()).addComment(column.getName() + "_startsWith + '%'");
        this.addConditionValue(column, builder);
        ((AbstractSqlBuilder)((AbstractSqlBuilder)builder).lineBreak())._add(this.getEndIfExpression());
    }

    protected void addConditionEndsWith(Column column, S builder) {
        ((AbstractSqlBuilder)((AbstractSqlBuilder)builder).lineBreak())._add(this.toIfIsNotEmptyExpression(column.getName() + "_endsWith"));
        ((AbstractSqlBuilder)builder).lineBreak();
        ((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)builder).and()).space()).name(column)).space()).like()).space()).addComment("'%' + " + column.getName() + "_endsWith");
        this.addConditionValue(column, builder);
        ((AbstractSqlBuilder)((AbstractSqlBuilder)builder).lineBreak())._add(this.getEndIfExpression());
    }

    protected void addConditionGt(Column column, S builder) {
        ((AbstractSqlBuilder)((AbstractSqlBuilder)builder).lineBreak())._add(this.toIfIsNotEmptyExpression(column.getName() + "_gt"));
        ((AbstractSqlBuilder)builder).lineBreak();
        ((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)builder).and()).space()).name(column)).space()).gt()).space()).addComment(column.getName() + "_gt");
        this.addConditionValue(column, builder);
        ((AbstractSqlBuilder)((AbstractSqlBuilder)builder).lineBreak())._add(this.getEndIfExpression());
    }

    protected void addConditionLt(Column column, S builder) {
        ((AbstractSqlBuilder)((AbstractSqlBuilder)builder).lineBreak())._add(this.toIfIsNotEmptyExpression(column.getName() + "_lt"));
        ((AbstractSqlBuilder)builder).lineBreak();
        ((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)builder).and()).space()).name(column)).space()).lt()).space()).addComment(column.getName() + "_lt");
        this.addConditionValue(column, builder);
        ((AbstractSqlBuilder)((AbstractSqlBuilder)builder).lineBreak())._add(this.getEndIfExpression());
    }

    protected void addConditionGte(Column column, S builder) {
        ((AbstractSqlBuilder)((AbstractSqlBuilder)builder).lineBreak())._add(this.toIfIsNotEmptyExpression(column.getName() + "_gte"));
        ((AbstractSqlBuilder)builder).lineBreak();
        ((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)builder).and()).space()).name(column)).space()).gte()).space()).addComment(column.getName() + "_gte");
        this.addConditionValue(column, builder);
        ((AbstractSqlBuilder)((AbstractSqlBuilder)builder).lineBreak())._add(this.getEndIfExpression());
    }

    protected void addConditionLte(Column column, S builder) {
        ((AbstractSqlBuilder)((AbstractSqlBuilder)builder).lineBreak())._add(this.toIfIsNotEmptyExpression(column.getName() + "_lte"));
        ((AbstractSqlBuilder)builder).lineBreak();
        ((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)builder).and()).space()).name(column)).space()).lte()).space()).addComment(column.getName() + "_lte");
        this.addConditionValue(column, builder);
        ((AbstractSqlBuilder)((AbstractSqlBuilder)builder).lineBreak())._add(this.getEndIfExpression());
    }

    protected void addConditionInValue(Column column, S builder) {
        if (column.getDataType() == null) {
            ((AbstractSqlBuilder)builder)._add("('')");
        } else {
            ((AbstractSqlBuilder)builder)._add("(");
            ((AbstractSqlBuilder)builder)._add(this.getDefaultValueLiteral(column));
            ((AbstractSqlBuilder)builder)._add(")");
        }
    }

    protected void addConditionValue(Column column, S builder) {
        if (column.getDataType() == null) {
            ((AbstractSqlBuilder)builder)._add("''");
        } else {
            ((AbstractSqlBuilder)builder)._add(this.getDefaultValueLiteral(column));
        }
    }

    protected String getDefaultValueLiteral(Column column) {
        DbDataType<?> dbDataType = this.getDialect().getDbDataType(column);
        return dbDataType.getDefaultValueLiteral();
    }

    protected void addCreateIndexDefinition(Index index, S builder) {
        if (index == null) {
            return;
        }
        AddTableObjectDetailFactory sqlFactory = this.getAddTableObjectDetailOperationFactory(index);
        if (sqlFactory != null) {
            ((AbstractSqlBuilder)builder).create();
            sqlFactory.addObjectDetail(index, index.getTable(), builder);
        }
    }

    protected <X extends AbstractDbObject<?>, Y extends AbstractSqlBuilder<?>> AddTableObjectDetailFactory<X, Y> getAddTableObjectDetailOperationFactory(X obj) {
        Object factory = this.getSqlFactoryRegistry().getSqlFactory(obj, SqlType.CREATE);
        if (factory instanceof AddTableObjectDetailFactory) {
            return (AddTableObjectDetailFactory)factory;
        }
        return null;
    }

    protected UniqueConstraint getUniqueConstraint(Table table) {
        UniqueConstraint constraint = table.getConstraints().getPrimaryKeyConstraint();
        if (constraint == null) {
            constraint = CommonUtils.first(table.getConstraints().getUniqueConstraints());
        }
        return constraint;
    }
}

