/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.sql;

import com.sqlapp.data.db.sql.SqlExecutor;
import com.sqlapp.data.db.sql.SqlOperation;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.DbUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;

public class ConnectionSqlExecutor
implements SqlExecutor {
    private Connection connection = null;
    private boolean autoClose = true;

    public ConnectionSqlExecutor(Connection connection) {
        this.connection = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Collection<SqlOperation> operations) throws SQLException {
        Connection connection = this.getConnection();
        Statement statement = null;
        try {
            statement = connection.createStatement();
            for (SqlOperation operation : operations) {
                if (CommonUtils.isEmpty(operation.getSqlText())) continue;
                statement.execute(operation.getSqlText());
            }
        }
        finally {
            DbUtils.close(statement);
            this.close(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(SqlOperation ... operations) throws SQLException {
        Connection connection = this.getConnection();
        Statement statement = null;
        try {
            statement = connection.createStatement();
            for (SqlOperation operation : operations) {
                if (CommonUtils.isEmpty(operation.getSqlText())) continue;
                statement.execute(operation.getSqlText());
            }
        }
        finally {
            DbUtils.close(statement);
            this.close(connection);
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    protected void close(Connection connection) {
        try {
            if (this.isAutoClose()) {
                connection.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public boolean isAutoClose() {
        return this.autoClose;
    }

    public void setAutoClose(boolean autoClose) {
        this.autoClose = autoClose;
    }
}

