/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.sql;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.sql.AbstractSqlFactory;
import com.sqlapp.data.db.sql.AddObjectDetail;
import com.sqlapp.data.db.sql.SqlType;
import com.sqlapp.data.schemas.AbstractDbObject;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.DbCommonObject;
import com.sqlapp.util.AbstractSqlBuilder;

public abstract class SimpleSqlFactory<T extends DbCommonObject<?>, S extends AbstractSqlBuilder<?>>
extends AbstractSqlFactory<T, S> {
    protected S createSqlBuilder() {
        return this.createSqlBuilder(this.getDialect());
    }

    @Override
    protected S newSqlBuilder(Dialect dialect) {
        return (S)dialect.createSqlBuilder();
    }

    protected <X extends AbstractDbObject<?>, Y extends AbstractSqlBuilder<?>> AddObjectDetail<X, Y> getAddObjectDetail(X obj, SqlType sqlType) {
        Object factory = this.getSqlFactoryRegistry().getSqlFactory(obj, sqlType);
        if (factory instanceof AddObjectDetail) {
            return (AddObjectDetail)factory;
        }
        return null;
    }

    protected boolean isInsertable(Column column) {
        return this.getOptions().getTableOptions().getInsertableColumn().test(column);
    }

    protected boolean isUpdateable(Column column) {
        if (!this.getOptions().getTableOptions().getUpdateableColumn().test(column)) {
            return false;
        }
        return !this.getOptions().getTableOptions().getCreatedAtColumn().test(column);
    }
}

