/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.sql;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.sql.AlterCatalogFactory;
import com.sqlapp.data.db.sql.AlterSchemaFactory;
import com.sqlapp.data.db.sql.AlterTableFactory;
import com.sqlapp.data.db.sql.CompositeSqlFactory;
import com.sqlapp.data.db.sql.CreateCatalogFactory;
import com.sqlapp.data.db.sql.CreateCheckConstraintFactory;
import com.sqlapp.data.db.sql.CreateForeignKeyConstraintFactory;
import com.sqlapp.data.db.sql.CreateIndexFactory;
import com.sqlapp.data.db.sql.CreateSchemaFactory;
import com.sqlapp.data.db.sql.CreateTableFactory;
import com.sqlapp.data.db.sql.CreateUniqueConstraintFactory;
import com.sqlapp.data.db.sql.CreateViewFactory;
import com.sqlapp.data.db.sql.DeleteAllTableFactory;
import com.sqlapp.data.db.sql.DeleteByPkTableFactory;
import com.sqlapp.data.db.sql.DeleteRowFactory;
import com.sqlapp.data.db.sql.DeleteTableFactory;
import com.sqlapp.data.db.sql.DropNamedObjectFactory;
import com.sqlapp.data.db.sql.DropTableFactory;
import com.sqlapp.data.db.sql.DropViewFactory;
import com.sqlapp.data.db.sql.EmptySqlFactoryRegistry;
import com.sqlapp.data.db.sql.InsertRowFactory;
import com.sqlapp.data.db.sql.InsertSelectRowFactory;
import com.sqlapp.data.db.sql.InsertSelectTableFactory;
import com.sqlapp.data.db.sql.InsertTableFactory;
import com.sqlapp.data.db.sql.MergeByPkTableFactory;
import com.sqlapp.data.db.sql.MergeRowFactory;
import com.sqlapp.data.db.sql.Options;
import com.sqlapp.data.db.sql.SelectAllTableFactory;
import com.sqlapp.data.db.sql.SelectByPkTableFactory;
import com.sqlapp.data.db.sql.SelectTableFactory;
import com.sqlapp.data.db.sql.SqlFactory;
import com.sqlapp.data.db.sql.SqlFactoryRegistry;
import com.sqlapp.data.db.sql.SqlType;
import com.sqlapp.data.db.sql.TruncateTableFactory;
import com.sqlapp.data.db.sql.UpdateAllTableFactory;
import com.sqlapp.data.db.sql.UpdateByPkTableFactory;
import com.sqlapp.data.db.sql.UpdateRowFactory;
import com.sqlapp.data.db.sql.UpdateTableFactory;
import com.sqlapp.data.schemas.Catalog;
import com.sqlapp.data.schemas.CheckConstraint;
import com.sqlapp.data.schemas.DbCommonObject;
import com.sqlapp.data.schemas.DbLink;
import com.sqlapp.data.schemas.DbObject;
import com.sqlapp.data.schemas.DbObjectDifference;
import com.sqlapp.data.schemas.Domain;
import com.sqlapp.data.schemas.ForeignKeyConstraint;
import com.sqlapp.data.schemas.Function;
import com.sqlapp.data.schemas.Index;
import com.sqlapp.data.schemas.Mview;
import com.sqlapp.data.schemas.PackageBody;
import com.sqlapp.data.schemas.Procedure;
import com.sqlapp.data.schemas.Row;
import com.sqlapp.data.schemas.RowCollection;
import com.sqlapp.data.schemas.Schema;
import com.sqlapp.data.schemas.SchemaUtils;
import com.sqlapp.data.schemas.State;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.data.schemas.TableLink;
import com.sqlapp.data.schemas.Trigger;
import com.sqlapp.data.schemas.Type;
import com.sqlapp.data.schemas.TypeBody;
import com.sqlapp.data.schemas.UniqueConstraint;
import com.sqlapp.data.schemas.View;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.SimpleBeanUtils;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SimpleSqlFactoryRegistry
implements SqlFactoryRegistry {
    private final Map<SqlType, Class<? extends SqlFactory<?>>> sqlFactories = CommonUtils.map();
    private Map<Class<?>, Map<SqlType, Class<? extends SqlFactory<?>>>> objectSqlFactories = CommonUtils.map();
    private Map<Class<?>, Map<State, List<SqlType>>> objectStateSqlFactories = CommonUtils.map();
    private final Dialect dialect;
    private SqlFactoryRegistry notFoundSqlFactoryRegistry = new EmptySqlFactoryRegistry();
    private Options option = new Options();

    public SimpleSqlFactoryRegistry(Dialect dialect) {
        this.dialect = dialect;
        this.initialize();
    }

    protected void initialize() {
        this.initializeAllSqls();
        this.registerDropSqlFactories();
        this.getObjectSqlFactories().forEach((k, v) -> v.forEach((k1, v1) -> {
            SqlType sqlType = k1;
            if (sqlType.getState() != null) {
                this.registerSqlFactory((Class<?>)k, sqlType.getState(), sqlType);
            }
        }));
        this.initializeAllStateSqls();
    }

    protected void initializeAllSqls() {
        this.initializeTableSqls();
        this.initializeRowSqls();
        this.registerSqlFactory(Catalog.class, SqlType.CREATE, CreateCatalogFactory.class);
        this.registerSqlFactory(Catalog.class, SqlType.ALTER, AlterCatalogFactory.class);
        this.registerSqlFactory(Schema.class, SqlType.CREATE, CreateSchemaFactory.class);
        this.registerSqlFactory(Schema.class, SqlType.ALTER, AlterSchemaFactory.class);
        this.registerSqlFactory(Index.class, SqlType.CREATE, CreateIndexFactory.class);
        this.registerSqlFactory(CheckConstraint.class, SqlType.CREATE, CreateCheckConstraintFactory.class);
        this.registerSqlFactory(UniqueConstraint.class, SqlType.CREATE, CreateUniqueConstraintFactory.class);
        this.registerSqlFactory(ForeignKeyConstraint.class, SqlType.CREATE, CreateForeignKeyConstraintFactory.class);
        this.registerSqlFactory(View.class, SqlType.CREATE, CreateViewFactory.class);
        this.registerSqlFactory(View.class, SqlType.DROP, DropViewFactory.class);
    }

    private void initializeTableSqls() {
        this.initializeTableDclSqls();
        this.initializeTableDdlSqls();
        this.initializeTableDmlSqls();
    }

    private void initializeTableDclSqls() {
    }

    private void initializeTableDdlSqls() {
        this.registerSqlFactory(Table.class, SqlType.CREATE, CreateTableFactory.class);
        this.registerSqlFactory(Table.class, SqlType.ALTER, AlterTableFactory.class);
        this.registerSqlFactory(Table.class, SqlType.DROP, DropTableFactory.class);
        this.registerSqlFactory(Table.class, SqlType.TRUNCATE, TruncateTableFactory.class);
    }

    private void initializeTableDmlSqls() {
        this.registerSqlFactory(Table.class, SqlType.DELETE_ALL, DeleteAllTableFactory.class);
        this.registerSqlFactory(Table.class, SqlType.DELETE, DeleteTableFactory.class);
        this.registerSqlFactory(Table.class, SqlType.DELETE_BY_PK, DeleteByPkTableFactory.class);
        this.registerSqlFactory(Table.class, SqlType.SELECT, SelectTableFactory.class);
        this.registerSqlFactory(Table.class, SqlType.SELECT_ALL, SelectAllTableFactory.class);
        this.registerSqlFactory(Table.class, SqlType.SELECT_BY_PK, SelectByPkTableFactory.class);
        this.registerSqlFactory(Table.class, SqlType.INSERT, InsertTableFactory.class);
        this.registerSqlFactory(Table.class, SqlType.UPDATE, UpdateTableFactory.class);
        this.registerSqlFactory(Table.class, SqlType.UPDATE_ALL, UpdateAllTableFactory.class);
        this.registerSqlFactory(Table.class, SqlType.UPDATE_BY_PK, UpdateByPkTableFactory.class);
        this.registerSqlFactory(Table.class, SqlType.INSERT_SELECT_BY_PK, InsertSelectTableFactory.class);
        this.registerSqlFactory(Table.class, SqlType.MERGE_BY_PK, MergeByPkTableFactory.class);
    }

    private void initializeRowSqls() {
        this.registerRowSqlFactory(SqlType.INSERT_ROW, InsertRowFactory.class);
        this.registerRowSqlFactory(SqlType.UPDATE_ROW, UpdateRowFactory.class);
        this.registerRowSqlFactory(SqlType.DELETE_ROW, DeleteRowFactory.class);
        this.registerRowSqlFactory(SqlType.INSERT_SELECT_ROW, InsertSelectRowFactory.class);
        this.registerRowSqlFactory(SqlType.MERGE_ROW, MergeRowFactory.class);
    }

    protected void registerRowSqlFactory(SqlType sqlType, Class<? extends SqlFactory<?>> commandClass) {
        this.registerSqlFactory(RowCollection.class, sqlType, commandClass);
        this.registerSqlFactory(Row.class, sqlType, commandClass);
    }

    protected void initializeAllStateSqls() {
        this.regiserDefaultStateSqlFactory(Table.class);
        this.registerSqlFactory(Table.class, State.Modified, SqlType.ALTER);
        this.regiserDefaultStateSqlFactory(View.class);
        this.regiserDefaultStateSqlFactory(Mview.class);
        this.regiserDefaultStateSqlFactory(Trigger.class);
        this.regiserDefaultStateSqlFactory(Procedure.class);
        this.regiserDefaultStateSqlFactory(Function.class);
        this.regiserDefaultStateSqlFactory(Package.class);
        this.regiserDefaultStateSqlFactory(PackageBody.class);
        this.regiserDefaultStateSqlFactory(Domain.class);
        this.regiserDefaultStateSqlFactory(Type.class);
        this.regiserDefaultStateSqlFactory(TypeBody.class);
        this.regiserDefaultStateSqlFactory(Schema.class);
        this.regiserDefaultStateSqlFactory(DbLink.class);
        this.regiserDefaultStateSqlFactory(TableLink.class);
        this.registerSqlFactory(Row.class, State.Added, SqlType.INSERT);
        this.registerSqlFactory(Row.class, State.Deleted, SqlType.DELETE_BY_PK);
        this.registerSqlFactory(Row.class, State.Modified, SqlType.UPDATE);
    }

    private void regiserDefaultStateSqlFactory(Class<?> clazz) {
        this.registerSqlFactory(clazz, State.Added, SqlType.CREATE);
        this.registerSqlFactory(clazz, State.Deleted, SqlType.DROP);
    }

    protected void registerSqlFactory(Class<?> objectClass, State state, SqlType ... sqlTypes) {
        this.registerSqlFactory(objectClass, state, CommonUtils.list(sqlTypes));
    }

    protected void registerSqlFactory(Class<?> objectClass, State state, List<SqlType> sqlTypes) {
        Map<State, List<SqlType>> stateOperations = this.getObjectStateSqlFactories().get(objectClass);
        if (stateOperations == null) {
            stateOperations = CommonUtils.map();
            this.getObjectStateSqlFactories().put(objectClass, stateOperations);
        }
        stateOperations.put(state, sqlTypes);
    }

    @Override
    public void deregisterSqlFactory(Class<?> objectClass, SqlType sqlType) {
        Map<SqlType, Class<SqlFactory<?>>> sqlFactoryMap = this.getObjectSqlFactories().get(objectClass);
        if (sqlFactoryMap != null) {
            sqlFactoryMap.remove((Object)sqlType);
        }
    }

    @Override
    public void deregisterSqlFactory(Class<?> sqlFactoryClass) {
        this.getObjectSqlFactories().remove(sqlFactoryClass);
    }

    @Override
    public void deregisterSqlFactory(Class<?> objectClass, SqlType ... sqlTypes) {
        Map<SqlType, Class<SqlFactory<?>>> sqlFactoryMap = this.getObjectSqlFactories().get(objectClass);
        if (sqlFactoryMap != null && sqlTypes != null) {
            for (SqlType sqlType : sqlTypes) {
                sqlFactoryMap.remove((Object)sqlType);
            }
        }
    }

    @Override
    public void registerSqlFactory(Class<?> objectClass, SqlType sqlType, Class<? extends SqlFactory<?>> sqlFactoryClass) {
        Map<SqlType, Class<SqlFactory<Object>>> sqlFactories = this.getObjectSqlFactories().get(objectClass);
        if (sqlFactories == null) {
            sqlFactories = CommonUtils.map();
            this.getObjectSqlFactories().put(objectClass, sqlFactories);
        }
        this.registerSqlFactory(sqlFactories, sqlType, sqlFactoryClass);
    }

    protected void registerDropSqlFactories() {
        Set<Class<?>> objectClass = SchemaUtils.getDroppableClasses();
        Set<Class<?>> supportedClass = this.getDialect().supportedSchemaTypes();
        Set<Class<?>> dropableClass = CommonUtils.and(objectClass, supportedClass);
        for (Class<?> clazz : dropableClass) {
            Class<SqlFactory<?>> sqlFactoryClazz = this.getSqlFactoryClass(clazz, SqlType.DROP);
            if (sqlFactoryClazz != null) continue;
            this.registerSqlFactory(clazz, SqlType.DROP, DropNamedObjectFactory.class);
        }
    }

    private Class<SqlFactory<?>> getSqlFactoryClass(Class<?> clazz, SqlType sqlType) {
        Map<SqlType, Class<SqlFactory<?>>> sqlFactoryMap = this.getObjectSqlFactories().get(clazz);
        if (sqlFactoryMap == null) {
            return null;
        }
        return sqlFactoryMap.get((Object)sqlType);
    }

    protected <T extends DbCommonObject<?>, U extends SqlFactory<?>> U handleUnknownOperation(T dbObject, State state) {
        return this.notFoundSqlFactoryRegistry.getSqlFactory(dbObject, state);
    }

    private void registerSqlFactory(Map<SqlType, Class<? extends SqlFactory<?>>> sqlFactories, SqlType sqlType, Class<? extends SqlFactory<?>> sqlFactoryClass) {
        sqlFactories.put(sqlType, sqlFactoryClass);
    }

    public <T> T newInstance(Class clazz) {
        if (clazz == null) {
            return null;
        }
        Object command = SimpleBeanUtils.getInstance(clazz).newInstance(this);
        this.initialize((SqlFactory)command);
        return command;
    }

    protected <T> void initialize(SqlFactory<?> sqlFactory) {
        SimpleBeanUtils.setValue(sqlFactory, "sqlFactoryRegistry", this);
    }

    protected <T extends DbCommonObject<?>, U extends SqlFactory<?>> U initializeSqls(T dbObject, SqlFactory<?> sqlFactory) {
        if (this.getOption() != null && sqlFactory != null) {
            sqlFactory.setOptions(this.getOption().clone());
        }
        return (U)sqlFactory;
    }

    protected Map<Class<?>, Map<State, List<SqlType>>> getObjectStateSqlFactories() {
        return this.objectStateSqlFactories;
    }

    protected void setObjectStateSqlFactories(Map<Class<?>, Map<State, List<SqlType>>> objectStateSqlFactories) {
        this.objectStateSqlFactories = objectStateSqlFactories;
    }

    protected Map<Class<?>, Map<SqlType, Class<? extends SqlFactory<?>>>> getObjectSqlFactories() {
        return this.objectSqlFactories;
    }

    protected void setSqlFactories(Map<Class<?>, Map<SqlType, Class<? extends SqlFactory<?>>>> objectSqlFactories) {
        this.objectSqlFactories = objectSqlFactories;
    }

    @Override
    public Dialect getDialect() {
        return this.dialect;
    }

    public void setNotFoundSqlRegistry(SqlFactoryRegistry notFoundSqlFactoryRegistry) {
        this.notFoundSqlFactoryRegistry = notFoundSqlFactoryRegistry;
        if (this.notFoundSqlFactoryRegistry != null && this.notFoundSqlFactoryRegistry instanceof EmptySqlFactoryRegistry) {
            ((EmptySqlFactoryRegistry)notFoundSqlFactoryRegistry).setSqlFactoryRegistry(this);
        }
    }

    @Override
    public <T extends DbCommonObject<?>, U extends SqlFactory<?>> U getSqlFactory(T dbObject, SqlType sqlType) {
        U sqlFactory = null;
        sqlFactory = dbObject instanceof Table ? (U)this.getSqlFactoryInternal((T)((Table)dbObject), sqlType) : (U)this.getSqlFactoryBySqlTypeFromAll(dbObject.getClass(), sqlType);
        if (sqlFactory == null) {
            sqlFactory = this.handleUnknownSqlFactory(dbObject, sqlType);
        }
        return sqlFactory;
    }

    protected <T extends DbCommonObject<?>, U extends SqlFactory<?>> U handleUnknownSqlFactory(T dbObject, SqlType sqlType) {
        return this.initializeSqls(dbObject, (SqlFactory<?>)this.notFoundSqlFactoryRegistry.getSqlFactory(dbObject, sqlType));
    }

    protected <T extends DbCommonObject<?>, U extends SqlFactory<T>> U getSqlFactoryInternal(T dbObject, SqlType ... sqlTypes) {
        if (CommonUtils.isEmpty(sqlTypes)) {
            return null;
        }
        CompositeSqlFactory sqlFactory = null;
        if (sqlTypes.length == 1) {
            sqlFactory = (CompositeSqlFactory)this.getSqlFactoryInternal(dbObject, CommonUtils.first(sqlTypes));
        } else {
            CompositeSqlFactory compositeOperation;
            List<SqlFactory<?>> commands = CommonUtils.list();
            for (SqlType sqlType : sqlTypes) {
                sqlFactory = this.getSqlFactoryInternal(dbObject, sqlType);
                commands.add(sqlFactory);
            }
            sqlFactory = compositeOperation = new CompositeSqlFactory(commands);
        }
        return (U)sqlFactory;
    }

    protected <T extends DbCommonObject<?>, U extends SqlFactory<?>> U getSqlFactoryInternal(T dbObject, SqlType sqlType) {
        U sqlFactory = this.getSqlFactoryBySqlTypeFromAll(dbObject.getClass(), sqlType);
        return this.initializeSqls(dbObject, (SqlFactory<?>)sqlFactory);
    }

    private <U extends SqlFactory<?>> U getSqlFactoryBySqlTypeFromAll(Class<?> clazz, SqlType sqlType) {
        Map<SqlType, Class<SqlFactory<?>>> sqlFactorys = this.getObjectSqlFactories().get(clazz);
        if (sqlFactorys == null) {
            return null;
        }
        Class<? extends SqlFactory<?>> sqlFactoryClass = sqlFactorys.get((Object)sqlType);
        if (sqlFactoryClass == null) {
            return null;
        }
        SqlFactory sqlFactory = (SqlFactory)this.newInstance(sqlFactoryClass);
        return (U)sqlFactory;
    }

    @Override
    public <U extends SqlFactory<?>> U getSqlFactory(DbObjectDifference difference, SqlType sqlType) {
        U obj = this.getSqlFactoryInternal((T)((DbCommonObject)difference.getOriginal()), sqlType);
        this.setDialect((SqlFactory<?>)obj, difference.getOriginal());
        if (obj != null) {
            return obj;
        }
        obj = this.handleUnknownSqlFactory(difference, sqlType);
        this.setDialect((SqlFactory<?>)obj, difference.getOriginal());
        return obj;
    }

    protected <U extends SqlFactory<?>> U handleUnknownSqlFactory(DbObjectDifference difference, SqlType sqlType) {
        return this.notFoundSqlFactoryRegistry.getSqlFactory(difference, sqlType);
    }

    @Override
    public <T extends DbCommonObject<?>, U extends SqlFactory<?>> U getSqlFactory(T dbObject, State state) {
        List<SqlType> sqlTypes = null;
        U operation = null;
        if (dbObject instanceof DbObject) {
            sqlTypes = this.getSqlTypes((DbObject)dbObject, state);
            Map<SqlType, Class<? extends SqlFactory<?>>> sqlFactoryMap = this.getObjectSqlFactories().get(dbObject.getClass());
            if (sqlTypes != null) {
                operation = this.getSqlFactory(sqlFactoryMap, sqlTypes.toArray(new SqlType[0]));
            }
        }
        if (operation == null) {
            return this.handleUnknownOperation(dbObject, state);
        }
        return operation;
    }

    protected List<SqlType> getSqlTypes(DbObject<?> object, State state) {
        Map<State, List<SqlType>> map = this.getObjectStateSqlFactories().get(object.getClass());
        if (map == null) {
            return null;
        }
        return map.get((Object)state);
    }

    protected <U extends SqlFactory<?>> U getSqlFactory(Map<SqlType, Class<? extends SqlFactory<?>>> sqlFactoryMap, SqlType ... sqlTypes) {
        if (CommonUtils.isEmpty(sqlTypes)) {
            return null;
        }
        if (CommonUtils.isEmpty(sqlFactoryMap)) {
            return null;
        }
        SqlFactory sqlFactory = null;
        if (sqlTypes.length == 1) {
            sqlFactory = (SqlFactory)this.newInstance(sqlFactoryMap.get((Object)CommonUtils.first(sqlTypes)));
        } else {
            List<SqlFactory<?>> operations = CommonUtils.list();
            for (SqlType sqlType : sqlTypes) {
                sqlFactory = (SqlFactory)this.newInstance(sqlFactoryMap.get((Object)sqlType));
                operations.add(sqlFactory);
            }
            CompositeSqlFactory compositeOperation = new CompositeSqlFactory(operations);
            sqlFactory = compositeOperation;
        }
        return (U)sqlFactory;
    }

    protected <T extends DbCommonObject<?>, U extends SqlFactory<T>> U getSqlFactory(Map<SqlType, Class<? extends SqlFactory<?>>> sqlFactoryMap, List<SqlType> sqlTypes) {
        if (CommonUtils.isEmpty(sqlTypes)) {
            return null;
        }
        return this.getSqlFactory(sqlFactoryMap, sqlTypes.toArray(new SqlType[0]));
    }

    @Override
    public <U extends SqlFactory<?>> U getSqlFactory(DbObjectDifference difference) {
        SqlFactory<?> ret = null;
        ret = difference.getState() == State.Deleted ? (SqlFactory<?>)this.getSqlFactory((DbCommonObject)difference.getOriginal(), difference.getState()) : (SqlFactory<?>)this.getSqlFactory((DbCommonObject)difference.getTarget(), difference.getState());
        this.setDialect(ret, difference.getOriginal());
        return (U)ret;
    }

    protected void setDialect(SqlFactory<?> sqlFactory, Object val) {
        if (sqlFactory == null) {
            return;
        }
        Dialect dialect = null;
        if (val != null) {
            dialect = (Dialect)SimpleBeanUtils.getValue(val, "dialect");
        }
        if (dialect == null) {
            dialect = this.getDialect();
        }
        SimpleBeanUtils.setValue(sqlFactory, "dialect", dialect);
    }

    protected <T extends DbCommonObject<?>, U extends SqlFactory<T>> U handleUnknownSqlFactory(DbObjectDifference difference) {
        return this.notFoundSqlFactoryRegistry.getSqlFactory(difference);
    }

    @Override
    public Options getOption() {
        return this.option;
    }

    @Override
    public void setOption(Options operationOption) {
        this.option = operationOption;
    }

    @Override
    public SqlFactory<?> getSqlFactory(SqlType sqlType) {
        Class<? extends SqlFactory<?>> sqlFactoryClass = this.sqlFactories.get((Object)sqlType);
        if (sqlFactoryClass != null) {
            SqlFactory sqlFactory = (SqlFactory)this.newInstance(sqlFactoryClass);
            return sqlFactory;
        }
        return this.notFoundSqlFactoryRegistry.getSqlFactory(sqlType);
    }

    @Override
    public void registerSqlFactory(SqlType sqlType, Class<? extends SqlFactory<?>> sqlFactoryClass) {
        this.sqlFactories.put(sqlType, sqlFactoryClass);
    }

    @Override
    public void deregisterSqlFactory(SqlType sqlType) {
        this.sqlFactories.remove((Object)sqlType);
    }
}

