/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.sql;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.sql.Options;
import com.sqlapp.data.db.sql.SqlFactory;
import com.sqlapp.data.db.sql.SqlOperation;
import com.sqlapp.data.db.sql.SqlType;
import com.sqlapp.data.schemas.DbCommonObject;
import com.sqlapp.data.schemas.DbObjectDifference;
import com.sqlapp.data.schemas.DbObjectDifferenceCollection;
import com.sqlapp.data.schemas.State;
import com.sqlapp.util.CommonUtils;
import java.util.List;

public interface SqlFactoryRegistry {
    default public <T extends DbCommonObject<?>> List<SqlOperation> createSql(T dbObject, SqlType sqlType) {
        Object sqlFactory = this.getSqlFactory(dbObject, sqlType);
        return sqlFactory.createSql(dbObject);
    }

    default public List<SqlOperation> createSql(SqlType sqlType) {
        SqlFactory<?> sqlFactory = this.getSqlFactory(sqlType);
        return sqlFactory.createSql();
    }

    default public List<SqlOperation> createSql(DbObjectDifference difference, SqlType sqlType) {
        Object sqlFactory = this.getSqlFactory(difference, sqlType);
        return sqlFactory.createDiffSql(difference);
    }

    default public <T extends DbCommonObject<?>> List<SqlOperation> createSql(T dbObject, State state) {
        Object sqlFactory = this.getSqlFactory(dbObject, state);
        return sqlFactory.createSql(dbObject);
    }

    default public List<SqlOperation> createSql(DbObjectDifference difference) {
        Object sqlFactory = this.getSqlFactory(difference);
        return sqlFactory.createDiffSql(difference);
    }

    default public List<SqlOperation> createSql(DbObjectDifferenceCollection differences) {
        List<SqlOperation> list = CommonUtils.list();
        for (DbObjectDifference diff : differences.getList(State.Deleted)) {
            list.addAll(this.createSql(diff));
        }
        for (DbObjectDifference diff : differences.getList(State.Added, State.Modified)) {
            list.addAll(this.createSql(diff));
        }
        return list;
    }

    public <T extends DbCommonObject<?>, U extends SqlFactory<?>> U getSqlFactory(T var1, SqlType var2);

    public SqlFactory<?> getSqlFactory(SqlType var1);

    public <U extends SqlFactory<?>> U getSqlFactory(DbObjectDifference var1, SqlType var2);

    public <T extends DbCommonObject<?>, U extends SqlFactory<?>> U getSqlFactory(T var1, State var2);

    public <U extends SqlFactory<?>> U getSqlFactory(DbObjectDifference var1);

    public Dialect getDialect();

    public void registerSqlFactory(SqlType var1, Class<? extends SqlFactory<?>> var2);

    public void registerSqlFactory(Class<?> var1, SqlType var2, Class<? extends SqlFactory<?>> var3);

    public void deregisterSqlFactory(SqlType var1);

    public void deregisterSqlFactory(Class<?> var1, SqlType var2);

    public void deregisterSqlFactory(Class<?> var1, SqlType ... var2);

    public void deregisterSqlFactory(Class<?> var1);

    public Options getOption();

    public void setOption(Options var1);
}

