/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.sql;

import com.sqlapp.data.db.sql.SqlType;
import com.sqlapp.data.schemas.DbCommonObject;
import com.sqlapp.util.CommonUtils;
import java.io.Serializable;
import java.util.Collection;

public class SqlOperation
implements Serializable {
    private static final long serialVersionUID = 1518852564523842052L;
    public static SqlOperation UNDO_OPERATION = new SqlOperation("-- //@UNDO ", SqlType.COMMENT);
    public static SqlOperation EMPTY_LINE_OPERATION = new SqlOperation("", SqlType.EMPTY_LINE);
    public static SqlOperation COMMENT_SEPARATOR_OPERATION = new SqlOperation("-- ###################################################################################################", SqlType.COMMENT);
    private SqlType sqlType = null;
    private String sqlText = null;
    private String startStatementTerminator = null;
    private String endStatementTerminator = null;
    private String terminator = null;
    private transient DbCommonObject<?>[] originals = null;
    private transient DbCommonObject<?>[] targets = null;

    public SqlOperation() {
    }

    public SqlOperation(String sqlText) {
        this(sqlText, null);
    }

    public SqlOperation(String sqlText, SqlType sqlType) {
        this(sqlText, sqlType, (DbCommonObject)null, (DbCommonObject)null);
    }

    public SqlOperation(String sqlText, SqlType sqlType, DbCommonObject<?> original) {
        this(sqlText, sqlType, original, null);
    }

    public SqlOperation(String sqlText, SqlType sqlType, DbCommonObject<?> original, DbCommonObject<?> target) {
        this.sqlText = sqlText;
        this.sqlType = sqlType;
        this.originals = original != null ? new DbCommonObject[]{original} : new DbCommonObject[0];
        this.targets = target != null ? new DbCommonObject[]{target} : new DbCommonObject[0];
    }

    public SqlOperation(String sqlText, SqlType sqlType, Collection<? extends DbCommonObject<?>> originals) {
        this(sqlText, sqlType, SqlOperation.toArray(originals));
    }

    public SqlOperation(String sqlText, SqlType sqlType, Collection<? extends DbCommonObject<?>> originals, Collection<? extends DbCommonObject<?>> targets) {
        this(sqlText, sqlType, SqlOperation.toArray(originals), SqlOperation.toArray(targets));
    }

    private static DbCommonObject<?>[] toArray(Collection<? extends DbCommonObject<?>> args) {
        if (args == null) {
            return null;
        }
        return args.toArray(new DbCommonObject[0]);
    }

    public SqlOperation(String sqlText, SqlType sqlType, DbCommonObject<?>[] originals) {
        this(sqlText, sqlType, originals, null);
    }

    public SqlOperation(String sqlText, SqlType sqlType, DbCommonObject<?>[] originals, DbCommonObject<?>[] targets) {
        this.sqlText = sqlText;
        this.sqlType = sqlType;
        this.originals = originals;
        this.targets = targets;
    }

    public <T extends DbCommonObject<?>> T getOriginal() {
        return (T)CommonUtils.first(this.originals);
    }

    public DbCommonObject<?>[] getOriginals() {
        return this.originals;
    }

    public <T extends DbCommonObject<?>> T getTarget() {
        return (T)CommonUtils.first(this.targets);
    }

    public DbCommonObject<?>[] getTargets() {
        return this.targets;
    }

    public SqlType getSqlType() {
        return this.sqlType;
    }

    public String getSqlText() {
        return this.sqlText;
    }

    public String getStartStatementTerminator() {
        return this.startStatementTerminator;
    }

    public void setStartStatementTerminator(String startStatementTerminator) {
        this.startStatementTerminator = startStatementTerminator;
    }

    public String getEndStatementTerminator() {
        return this.endStatementTerminator;
    }

    public void setEndStatementTerminator(String endStatementTerminator) {
        this.endStatementTerminator = endStatementTerminator;
    }

    public SqlOperation setSqlText(String sqlText) {
        this.sqlText = sqlText;
        return this;
    }

    public String getTerminator() {
        return this.terminator;
    }

    public void setTerminator(String terminator) {
        this.terminator = terminator;
    }

    public String toString() {
        return this.sqlText;
    }
}

