/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.geometry;

import com.sqlapp.data.converter.Converters;
import com.sqlapp.data.geometry.AbstractMultiPoint;
import com.sqlapp.data.geometry.AbstractPoint2D;
import com.sqlapp.data.geometry.Box3D;
import com.sqlapp.data.geometry.Line;
import com.sqlapp.data.geometry.Lseg3D;
import com.sqlapp.data.geometry.Point;
import com.sqlapp.data.geometry.Point3D;
import com.sqlapp.data.geometry.ToLowerDimensionType;
import com.sqlapp.util.CommonUtils;

public final class Line3D
extends AbstractMultiPoint<Point3D>
implements ToLowerDimensionType<Line> {
    private static final long serialVersionUID = 7043949685038533776L;

    public Line3D(Point3D point1, Point3D point2) {
        super((AbstractPoint2D[])new Point3D[]{point1, point2});
    }

    public Line3D(double x1, double y1, double z1, double x2, double y2, double z2) {
        ((Point3D[])this.points)[0] = this.newPoint(x1, y1, z1);
        ((Point3D[])this.points)[1] = this.newPoint(x2, y2, z2);
    }

    public Line3D() {
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        return obj instanceof Line3D;
    }

    @Override
    public Line3D clone() {
        return (Line3D)super.clone();
    }

    protected Point3D[] newArray(int size) {
        return new Point3D[size];
    }

    @Override
    protected Point3D newPoint(double ... a) {
        return new Point3D(a[0], a[1], a[2]);
    }

    @Override
    public int getDimension() {
        return 3;
    }

    @Override
    public Line toLowerDimension() {
        Point[] points = new Point[((Point3D[])this.points).length];
        for (int i = 0; i < points.length; ++i) {
            points[i] = ((Point3D[])this.points)[i].toLowerDimension();
        }
        return new Line(points[0], points[1]);
    }

    @Override
    public Line3D setValue(String text) {
        text = text.replace("(", "").replace(")", "");
        String[] values = CommonUtils.split(text, "\\s*,\\s*");
        double[] vals = Converters.getDefault().convertObject(values, double[].class);
        this.setPoint(vals);
        return this;
    }

    public Lseg3D toLseg() {
        Lseg3D ret = new Lseg3D(((Point3D[])this.getPoints())[0].clone(), ((Point3D[])this.getPoints())[1].clone());
        return ret;
    }

    public Box3D toBox() {
        Box3D ret = new Box3D(((Point3D[])this.getPoints())[0].clone(), ((Point3D[])this.getPoints())[1].clone());
        return ret;
    }
}

