/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.geometry;

import com.sqlapp.data.converter.Converters;
import com.sqlapp.data.geometry.AbstractMultiPoint;
import com.sqlapp.data.geometry.Path;
import com.sqlapp.data.geometry.Point;
import com.sqlapp.data.geometry.Point3D;
import com.sqlapp.data.geometry.Polygon3D;
import com.sqlapp.data.geometry.ToLowerDimensionType;
import com.sqlapp.util.CommonUtils;

public class Path3D
extends AbstractMultiPoint<Point3D>
implements ToLowerDimensionType<Path> {
    private static final long serialVersionUID = 3280634501061893212L;
    public boolean open = false;

    public Path3D(boolean open, Point3D ... points) {
        this.open = open;
        this.setPoints(points);
    }

    public Path3D(Point3D ... points) {
        this.setPoints(points);
    }

    public Path3D(double ... points) {
        this(false, points);
    }

    public Path3D(boolean open, double ... points) {
        super(points);
        this.open = open;
    }

    public Path3D() {
    }

    @Override
    protected char getOpen() {
        if (this.open) {
            return '[';
        }
        return '(';
    }

    @Override
    protected char getClose() {
        if (this.open) {
            return ']';
        }
        return ')';
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof Path3D)) {
            return false;
        }
        Path3D cst = (Path3D)obj;
        return CommonUtils.eq(this.open, cst.open);
    }

    @Override
    public Path3D clone() {
        return (Path3D)super.clone();
    }

    protected Point3D[] newArray(int size) {
        return new Point3D[size];
    }

    @Override
    protected Point3D newPoint(double ... a) {
        return new Point3D(a[0], a[1], a[2]);
    }

    @Override
    public int getDimension() {
        return 3;
    }

    @Override
    public Path toLowerDimension() {
        Point[] points = new Point[((Point3D[])this.points).length];
        for (int i = 0; i < points.length; ++i) {
            points[i] = ((Point3D[])this.points)[i].toLowerDimension();
        }
        return new Path(points);
    }

    @Override
    public Path3D setValue(String text) {
        boolean open = false;
        if (text.contains("[")) {
            text = text.replace("[", "").replace("]", "");
            open = true;
        } else {
            text = text.replace("(", "").replace(")", "");
        }
        String[] values = CommonUtils.split(text, "\\s*,\\s*");
        double[] vals = Converters.getDefault().convertObject(values, double[].class);
        this.open = open;
        this.setPoint(vals);
        return this;
    }

    public Polygon3D toPolygon() {
        Polygon3D ret = new Polygon3D();
        ret.setPoints((Point3D[])this.getPoints());
        return ret;
    }
}

