/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.geometry;

import com.sqlapp.data.converter.Converters;
import com.sqlapp.data.geometry.AbstractPoint2D;
import com.sqlapp.data.geometry.Point;
import com.sqlapp.data.geometry.ToLowerDimensionType;
import com.sqlapp.util.CommonUtils;

public class Point3D
extends AbstractPoint2D
implements ToLowerDimensionType<Point> {
    private static final long serialVersionUID = 3280634501061893212L;
    public double z = 0.0;

    public Point3D(double x, double y, double z) {
        super(x, y);
        this.z = z;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("(").append(this.getX()).append(",").append(this.getY()).append(",").append(this.getZ()).append(")");
        return builder.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof Point3D)) {
            return false;
        }
        Point3D cst = (Point3D)obj;
        return CommonUtils.eq(this.getZ(), cst.getZ());
    }

    public double getZ() {
        return this.z;
    }

    public void setZ(double z) {
        this.z = z;
    }

    @Override
    public Point3D clone() {
        return new Point3D(this.getX(), this.getY(), this.getZ());
    }

    @Override
    public int getDimension() {
        return 3;
    }

    @Override
    public Point toLowerDimension() {
        return new Point(this.getX(), this.getY());
    }

    @Override
    public Point3D setValue(String text) {
        text = CommonUtils.unwrap(text, "(", ")");
        String[] values = CommonUtils.split(text, "\\s*,\\s*");
        double[] vals = Converters.getDefault().convertObject(values, double[].class);
        this.setX(vals[0]);
        this.setY(vals[1]);
        this.setZ(vals[2]);
        return this;
    }
}

