/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.geometry;

import com.sqlapp.data.converter.Converters;
import com.sqlapp.data.geometry.AbstractMultiPoint;
import com.sqlapp.data.geometry.Path;
import com.sqlapp.data.geometry.Point;
import com.sqlapp.data.geometry.Point3D;
import com.sqlapp.data.geometry.Polygon3D;
import com.sqlapp.data.geometry.ToUpperDimensionType;
import com.sqlapp.util.CommonUtils;

public class Polygon
extends AbstractMultiPoint<Point>
implements ToUpperDimensionType<Polygon3D> {
    private static final long serialVersionUID = 3280634501061893212L;

    public Polygon(Point ... points) {
        this.setPoints(points);
    }

    public Polygon(double ... args) {
        super(args);
    }

    public Polygon() {
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        return obj instanceof Polygon;
    }

    @Override
    public Polygon clone() {
        return (Polygon)super.clone();
    }

    protected Point[] newArray(int size) {
        return new Point[size];
    }

    @Override
    protected Point newPoint(double ... a) {
        return new Point(a[0], a[1]);
    }

    @Override
    public int getDimension() {
        return 2;
    }

    @Override
    public Polygon3D toUpperDimension() {
        Point3D[] points = new Point3D[((Point[])this.points).length];
        for (int i = 0; i < points.length; ++i) {
            points[i] = ((Point[])this.points)[i].toUpperDimension();
        }
        return new Polygon3D(points);
    }

    @Override
    public Polygon setValue(String text) {
        text = text.replace("(", "").replace(")", "");
        String[] values = CommonUtils.split(text, "\\s*,\\s*");
        double[] vals = Converters.getDefault().convertObject(values, double[].class);
        this.setPoint(vals);
        return this;
    }

    public Path toPath() {
        Path ret = new Path();
        ret.setPoints((Point[])this.getPoints());
        return ret;
    }
}

