/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.interval;

import com.sqlapp.data.interval.Interval;
import com.sqlapp.util.CommonUtils;
import java.text.DecimalFormat;

public class IntervalSecond
extends Interval {
    private static final long serialVersionUID = -5794364986820692508L;

    public IntervalSecond() {
    }

    public IntervalSecond(int seconds) {
        super(0, 0, 0, 0, 0, seconds, 0L);
    }

    public IntervalSecond(int seconds, int nanos) {
        super(0, 0, 0, 0, 0, seconds, nanos);
    }

    public IntervalSecond(double seconds) {
        super(0, 0, 0, 0, 0, seconds);
    }

    public static IntervalSecond toSecondType(Interval interval) {
        if (interval == null) {
            return null;
        }
        IntervalSecond result = new IntervalSecond(interval.getSecondsFull(), interval.getNanos());
        if (!interval.isPositive()) {
            result.scale(-1);
        }
        return result;
    }

    public static IntervalSecond parse(String val) {
        if (CommonUtils.isEmpty(val)) {
            return null;
        }
        Interval interval = Interval.parseDetail(val);
        if (interval == null) {
            interval = Interval.parse(val, "SECOND", "SECOND");
        }
        return IntervalSecond.toSecondType(interval);
    }

    @Override
    public int getSeconds() {
        return super.getSecondsFull();
    }

    @Override
    public IntervalSecond clone() {
        return (IntervalSecond)super.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder("");
        if (!this.isPositive()) {
            builder.append("-");
        }
        if (this.getNanos() > 0) {
            DecimalFormat decimalFormat = secondsFormat;
            synchronized (decimalFormat) {
                double val = (double)this.getNanos() / 1.0E9 + (double)this.getSecondsFull();
                builder.append(secondsFormat.format(val));
            }
        } else {
            builder.append(this.getSecondsFull());
        }
        builder.append("");
        return builder.toString();
    }
}

