/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.interval;

import com.sqlapp.data.interval.Interval;
import com.sqlapp.util.CommonUtils;

public final class IntervalYear
extends Interval {
    private static final long serialVersionUID = -7959888976357432942L;

    public IntervalYear() {
    }

    public IntervalYear(int years) {
        super(years, 0, 0, 0, 0, 0, 0L);
    }

    public static IntervalYear toYearType(Interval interval) {
        if (interval == null) {
            return null;
        }
        IntervalYear result = new IntervalYear(interval.getYears());
        if (!interval.isPositive()) {
            result.scale(-1);
        }
        return result;
    }

    public static IntervalYear parse(String val) {
        if (CommonUtils.isEmpty(val)) {
            return null;
        }
        Interval interval = Interval.parseDetail(val);
        if (interval == null) {
            interval = Interval.parse(val, "YEAR", "YEAR");
        }
        return IntervalYear.toYearType(interval);
    }

    @Override
    public IntervalYear clone() {
        return (IntervalYear)super.clone();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder("");
        if (!this.isPositive()) {
            builder.append("-");
        }
        builder.append(this.getYears());
        builder.append("");
        return builder.toString();
    }
}

