/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.interval;

import com.sqlapp.data.interval.Interval;
import com.sqlapp.util.CommonUtils;
import java.time.YearMonth;

public class IntervalYearToMonth
extends Interval {
    private static final long serialVersionUID = 4409821325136133414L;

    public IntervalYearToMonth() {
    }

    public IntervalYearToMonth(int years, int months) {
        super(years, months, 0, 0, 0, 0);
    }

    private IntervalYearToMonth(int years, int months, int days, int hours, int minutes, int seconds, long nanos) {
        super(years, months, days, hours, minutes, seconds, nanos);
    }

    private IntervalYearToMonth(int years, int months, int days, int hours, int minutes, double seconds) {
        super(years, months, days, hours, minutes, seconds);
    }

    private IntervalYearToMonth(int years, int months, int days, int hours, int minutes, int seconds) {
        super(years, months, days, hours, minutes, seconds, 0L);
    }

    public static IntervalYearToMonth toYearToMonthType(Interval interval) {
        if (interval == null) {
            return null;
        }
        IntervalYearToMonth result = new IntervalYearToMonth(interval.getYears(), interval.getMonths());
        if (!interval.isPositive()) {
            result.scale(-1);
        }
        return result;
    }

    public static IntervalYearToMonth parse(String val) {
        if (CommonUtils.isEmpty(val)) {
            return null;
        }
        Interval interval = Interval.parseDetail(val);
        if (interval == null) {
            interval = Interval.parse(val, "YEAR", "MONTH");
        }
        return IntervalYearToMonth.toYearToMonthType(interval);
    }

    @Override
    public void setDays(int days) {
    }

    @Override
    public void setDays(double days) {
    }

    @Override
    public void setHours(int hours) {
    }

    @Override
    public void setHours(double hours) {
    }

    @Override
    public void setMinutes(int minutes) {
    }

    @Override
    public void setMinutes(double minutes) {
    }

    @Override
    public void setSeconds(int seconds) {
    }

    @Override
    public void setSeconds(double seconds) {
    }

    @Override
    public void setNanos(int nanos) {
    }

    @Override
    public void setNanos(long nanos) {
    }

    @Override
    public IntervalYearToMonth clone() {
        return (IntervalYearToMonth)super.clone();
    }

    public YearMonth toYearMonth() {
        return YearMonth.of(this.getYears(), this.getMonths());
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder("");
        if (!this.isPositive()) {
            builder.append("-");
        }
        builder.append(this.getYears());
        builder.append("-");
        builder.append(this.getMonths());
        return builder.toString();
    }
}

