/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.schemas.AbstractBaseDbObjectXmlReaderHandler;
import com.sqlapp.data.schemas.AbstractDbObjectCollection;
import com.sqlapp.data.schemas.AbstractObjectXmlReaderHandler;
import com.sqlapp.data.schemas.DbCommonObject;
import com.sqlapp.data.schemas.DbInfo;
import com.sqlapp.data.schemas.DbObject;
import com.sqlapp.data.schemas.DbObjectCollection;
import com.sqlapp.data.schemas.DbObjectDifference;
import com.sqlapp.data.schemas.EqualsHandler;
import com.sqlapp.data.schemas.GetAllDbObjectEqualsHandler;
import com.sqlapp.data.schemas.GetPropertyMapEqualsHandler;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.SchemaUtils;
import com.sqlapp.data.schemas.TableSpace;
import com.sqlapp.data.schemas.XmlReaderOptions;
import com.sqlapp.data.schemas.properties.CreatedAtProperty;
import com.sqlapp.data.schemas.properties.ISchemaProperty;
import com.sqlapp.data.schemas.properties.IdProperty;
import com.sqlapp.data.schemas.properties.LastAlteredAtProperty;
import com.sqlapp.data.schemas.properties.OrdinalProperty;
import com.sqlapp.data.schemas.properties.SpecificsProperty;
import com.sqlapp.data.schemas.properties.StatisticsProperty;
import com.sqlapp.data.schemas.properties.complex.DialectGetter;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.EqualsUtils;
import com.sqlapp.util.FileUtils;
import com.sqlapp.util.HashCodeBuilder;
import com.sqlapp.util.StaxReader;
import com.sqlapp.util.StaxWriter;
import com.sqlapp.util.StringUtils;
import com.sqlapp.util.ToStringBuilder;
import com.sqlapp.util.xml.ResultHandler;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.xml.stream.XMLStreamException;

abstract class AbstractBaseDbObject<T extends AbstractBaseDbObject<T>>
implements DbObject<T>,
IdProperty<T>,
Comparable<T>,
OrdinalProperty<T>,
CreatedAtProperty<T>,
LastAlteredAtProperty<T>,
SpecificsProperty<T>,
StatisticsProperty<T>,
DialectGetter {
    private static final long serialVersionUID = 210101856540540272L;
    private String id = null;
    private Timestamp createdAt = null;
    private Timestamp lastAlteredAt = null;
    private DbInfo specifics = new DbInfo();
    private DbInfo statistics = new DbInfo();
    private int ordinal = 0;
    private Dialect dialect = null;
    private DbCommonObject<?> parent = null;
    private final String SIMPLE_NAME = AbstractBaseDbObject.getSimpleName(this.getClass());
    private static final Map<Class<?>, String> SIMPLE_NAME_MAP = new HashMap();

    protected DbCommonObject<?> getParent() {
        return this.parent;
    }

    protected T setParent(DbCommonObject<?> parent) {
        this.parent = (DbCommonObject)CommonUtils.cast(parent);
        return this.instance();
    }

    @Override
    public int getOrdinal() {
        return this.ordinal;
    }

    protected T setOrdinal(int ordinal) {
        this.ordinal = ordinal;
        return this.instance();
    }

    protected AbstractBaseDbObject() {
    }

    @Override
    public Timestamp getCreatedAt() {
        return this.createdAt;
    }

    @Override
    public T setCreatedAt(Timestamp created) {
        this.createdAt = created;
        return this.instance();
    }

    @Override
    public Timestamp getLastAlteredAt() {
        return this.lastAlteredAt;
    }

    @Override
    public T setLastAlteredAt(Timestamp lastAltered) {
        this.lastAlteredAt = lastAltered;
        return this.instance();
    }

    @Override
    public DbInfo getSpecifics() {
        return this.specifics;
    }

    @Override
    public T setSpecifics(DbInfo specifics) {
        this.specifics = specifics;
        return this.instance();
    }

    @Override
    public DbInfo getStatistics() {
        return this.statistics;
    }

    @Override
    public T setStatistics(DbInfo statistics) {
        this.statistics = statistics;
        return this.instance();
    }

    @Override
    public Dialect getDialect() {
        if (this.getParent() == null) {
            return this.dialect;
        }
        DbCommonObject<?> dbCommonObject = this.getParent();
        if (dbCommonObject instanceof AbstractBaseDbObject) {
            return ((AbstractBaseDbObject)dbCommonObject).getDialect();
        }
        if (dbCommonObject instanceof AbstractDbObjectCollection) {
            return this.getDialect((AbstractDbObjectCollection)dbCommonObject);
        }
        return this.dialect;
    }

    protected Dialect getDialect(AbstractBaseDbObject<?> abstractDbObject) {
        return abstractDbObject.getDialect();
    }

    protected Dialect getDialect(AbstractDbObjectCollection<?> abstractDbObjectCollection) {
        DbCommonObject<?> dbCommonObject = abstractDbObjectCollection.getParent();
        if (dbCommonObject instanceof AbstractBaseDbObject) {
            return ((AbstractBaseDbObject)dbCommonObject).getDialect();
        }
        if (dbCommonObject instanceof AbstractDbObjectCollection) {
            return this.getDialect((AbstractDbObjectCollection)dbCommonObject);
        }
        return null;
    }

    protected T instance() {
        return (T)this;
    }

    public T setDialect(Dialect dialect) {
        this.dialect = dialect;
        return this.instance();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public T setId(String id) {
        this.id = id;
        return this.instance();
    }

    @Override
    public Map<String, Object> toMap() {
        GetPropertyMapEqualsHandler equalsHandler = new GetPropertyMapEqualsHandler(this);
        this.equals(this, equalsHandler);
        return equalsHandler.getResult();
    }

    public boolean equals(Object obj) {
        return this.equals(obj, EqualsHandler.getInstance());
    }

    @Override
    public boolean equals(Object obj, EqualsHandler equalsHandler) {
        if (equalsHandler.referenceEquals(this, obj)) {
            return true;
        }
        if (!(obj instanceof AbstractBaseDbObject)) {
            return false;
        }
        AbstractBaseDbObject val = (AbstractBaseDbObject)obj;
        if (!this.equals(SchemaProperties.ID, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.CREATED_AT, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.LAST_ALTERED_AT, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.SPECIFICS, val, equalsHandler)) {
            return false;
        }
        return this.equals(SchemaProperties.STATISTICS, val, equalsHandler);
    }

    @Override
    public boolean like(Object obj) {
        return this.equals(obj);
    }

    @Override
    public boolean like(Object obj, EqualsHandler equalsHandler) {
        return this.equals(obj, equalsHandler);
    }

    @Override
    public DbObjectDifference diff(T obj) {
        DbObjectDifference diff = new DbObjectDifference(this, (DbObject<?>)obj);
        return diff;
    }

    @Override
    public DbObjectDifference diff(T obj, EqualsHandler equalsHandler) {
        DbObjectDifference diff = new DbObjectDifference(this, (DbObject<?>)obj, equalsHandler);
        return diff;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder(this.getSimpleName());
        this.toString(builder);
        return builder.toString();
    }

    @Override
    public String toStringSimple() {
        return this.toString();
    }

    protected void toString(ToStringBuilder builder) {
        builder.add((ISchemaProperty)SchemaProperties.ID, this.getId());
        builder.add((ISchemaProperty)SchemaProperties.SPECIFICS, (Object)this.getSpecifics());
        builder.add((ISchemaProperty)SchemaProperties.STATISTICS, (Object)this.getStatistics());
        builder.add((ISchemaProperty)SchemaProperties.CREATED_AT, (Object)this.getCreatedAt());
        builder.add((ISchemaProperty)SchemaProperties.LAST_ALTERED_AT, (Object)this.getLastAlteredAt());
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append(this.getId());
        builder.append(this.getCreatedAt());
        builder.append(this.getLastAlteredAt());
        builder.append(this.getDialect());
        return builder.hashCode();
    }

    protected String getSimpleName() {
        return this.SIMPLE_NAME;
    }

    protected static String getSimpleName(Class<?> clazz) {
        String name = SIMPLE_NAME_MAP.get(clazz);
        if (name != null) {
            return name;
        }
        name = StringUtils.uncapitalize(clazz.getSimpleName());
        SIMPLE_NAME_MAP.put(clazz, name);
        return name;
    }

    @Override
    public void writeXml(StaxWriter stax) throws XMLStreamException {
        this.writeXml(this.getSimpleName(), stax);
    }

    protected void writeXml(String name, StaxWriter stax) throws XMLStreamException {
        stax.newLine();
        stax.indent();
        stax.writeElement(name, () -> {
            this.writeName(stax);
            this.writeXmlOptionalAttributes(stax);
            this.writeCommonAttribute(stax);
            long beforeCount = stax.getWriteCount();
            stax.indent(() -> {
                this.writeXmlOptionalValues(stax);
                this.writeCommonValue(stax);
            });
            long endCount = stax.getWriteCount();
            if (beforeCount != endCount) {
                stax.newLine();
                stax.indent();
            }
        });
    }

    protected void writeName(StaxWriter stax) throws XMLStreamException {
    }

    @Override
    public void loadXml(Reader reader, XmlReaderOptions options) throws XMLStreamException {
        StaxReader staxReader = new StaxReader(reader);
        AbstractBaseDbObjectXmlReaderHandler<T> handler = this.getDbObjectXmlReaderHandler();
        handler.setReaderOptions(options);
        AbstractObjectXmlReaderHandler.ChildObjectHolder holder = new AbstractObjectXmlReaderHandler.ChildObjectHolder(this);
        ResultHandler resultHandler = new ResultHandler();
        resultHandler.registerChild(handler);
        resultHandler.handle(staxReader, holder);
    }

    @Override
    public void loadXml(InputStream stream, XmlReaderOptions options) throws XMLStreamException {
        StaxReader staxReader = new StaxReader(stream);
        AbstractBaseDbObjectXmlReaderHandler<T> handler = this.getDbObjectXmlReaderHandler();
        handler.setReaderOptions(options);
        AbstractObjectXmlReaderHandler.ChildObjectHolder holder = new AbstractObjectXmlReaderHandler.ChildObjectHolder(this);
        ResultHandler resultHandler = new ResultHandler();
        resultHandler.registerChild(handler);
        resultHandler.handle(staxReader, holder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadXml(String path, XmlReaderOptions options) throws XMLStreamException, FileNotFoundException {
        InputStream stream = null;
        BufferedInputStream bis = null;
        try {
            stream = FileUtils.getInputStream(path);
            if (stream == null) {
                throw new FileNotFoundException(path);
            }
            bis = new BufferedInputStream(stream);
            this.loadXml(bis, options);
        }
        finally {
            FileUtils.close(stream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadXml(File file, XmlReaderOptions options) throws XMLStreamException, FileNotFoundException {
        FileInputStream stream = null;
        BufferedInputStream bis = null;
        try {
            stream = new FileInputStream(file);
            bis = new BufferedInputStream(stream);
            this.loadXml(bis, options);
        }
        catch (Throwable throwable) {
            FileUtils.close(stream);
            throw throwable;
        }
        FileUtils.close(stream);
    }

    protected AbstractBaseDbObjectXmlReaderHandler<T> getDbObjectXmlReaderHandler() {
        return new AbstractBaseDbObjectXmlReaderHandler<T>(this.newInstance()){};
    }

    @Override
    public void writeXml(OutputStream stream) throws XMLStreamException {
        StaxWriter stax = new StaxWriter(stream){

            @Override
            protected boolean isWriteStartDocument() {
                return true;
            }
        };
        this.writeXml(stax);
    }

    @Override
    public void writeXml(Writer writer) throws XMLStreamException {
        StaxWriter stax = new StaxWriter(writer){

            @Override
            protected boolean isWriteStartDocument() {
                return true;
            }
        };
        this.writeXml(stax);
    }

    @Override
    public void writeXml(String path) throws XMLStreamException, IOException {
        this.writeXml(new File(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeXml(File file) throws XMLStreamException, IOException {
        FileOutputStream fos = null;
        BufferedOutputStream bos = null;
        try {
            fos = new FileOutputStream(file);
            bos = new BufferedOutputStream(fos);
            StaxWriter stax = new StaxWriter(bos);
            this.writeXml(stax);
            bos.flush();
        }
        catch (Throwable throwable) {
            FileUtils.close(fos);
            throw throwable;
        }
        FileUtils.close(fos);
    }

    protected void writeCommonAttribute(StaxWriter stax) throws XMLStreamException {
        this.writeCommonNameAttribute(stax);
        stax.writeAttribute(SchemaProperties.ID.getLabel(), this.getId());
        stax.writeAttribute(SchemaProperties.CREATED_AT.getLabel(), (Object)this.getCreatedAt());
        stax.writeAttribute(SchemaProperties.LAST_ALTERED_AT.getLabel(), (Object)this.getLastAlteredAt());
    }

    protected void writeCommonNameAttribute(StaxWriter stax) throws XMLStreamException {
    }

    protected void writeCommonValue(StaxWriter stax) throws XMLStreamException {
        if (!this.getSpecifics().isEmpty()) {
            stax.newLine();
            stax.indent();
            stax.writeElement(SchemaProperties.SPECIFICS.getLabel(), this.getSpecifics());
        }
        if (!this.getStatistics().isEmpty()) {
            stax.newLine();
            stax.indent();
            stax.writeElement(SchemaProperties.STATISTICS.getLabel(), this.getStatistics());
        }
    }

    protected void writeXmlOptionalAttributes(StaxWriter stax) throws XMLStreamException {
    }

    protected void writeXmlOptionalValues(StaxWriter stax) throws XMLStreamException {
    }

    public T clone() {
        AbstractBaseDbObject clone = (AbstractBaseDbObject)this.newInstance().get();
        this.cloneProperties(clone);
        clone.validate();
        return (T)clone;
    }

    protected void cloneProperties(T clone) {
        if (((AbstractBaseDbObject)clone).getDialect() == null) {
            ((AbstractBaseDbObject)clone).setDialect(this.getDialect());
        }
        Set<ISchemaProperty> properties = SchemaUtils.getAllSchemaProperties(this.getClass());
        for (ISchemaProperty prop : properties) {
            Object value = prop.getCloneValue(this);
            prop.setValue(clone, value);
        }
    }

    protected boolean equals(String propertyName, T target, Object value, Object targetValue, EqualsHandler equalsHandler) {
        return equalsHandler.valueEquals(propertyName, this, target, value, targetValue, EqualsUtils.getEqualsSupplier(value, targetValue));
    }

    protected boolean equals(ISchemaProperty props, T target, EqualsHandler equalsHandler) {
        return this.equals(props.getLabel(), target, props.getValue(this), props.getValue(target), equalsHandler);
    }

    protected boolean equals(String propertyName, T target, Object value, Object targetValue, EqualsHandler equalsHandler, BooleanSupplier booleanSupplier) {
        return equalsHandler.valueEquals(propertyName, this, target, value, targetValue, booleanSupplier);
    }

    protected boolean equals(ISchemaProperty props, T target, EqualsHandler equalsHandler, BooleanSupplier booleanSupplier) {
        return this.equals(props.getLabel(), target, props.getValue(this), props.getValue(target), equalsHandler, booleanSupplier);
    }

    protected boolean equals(String propertyName, T target, DbObjectCollection<?> value, DbObjectCollection<?> targetValue, EqualsHandler equalsHandler) {
        return equalsHandler.valueEquals(propertyName, this, target, value, targetValue, AbstractBaseDbObject.getEqualsSupplier(value, targetValue, equalsHandler));
    }

    protected static BooleanSupplier getEqualsSupplier(DbCommonObject<?> o1, DbCommonObject<?> o2, EqualsHandler equalsHandler) {
        return () -> {
            if (o1 != null) {
                return o1.equals(o2, equalsHandler);
            }
            return o2 == null;
        };
    }

    protected void validate() {
    }

    protected String listToString(List<String> list) {
        if (list == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            builder.append(list.get(i));
            builder.append('\n');
        }
        return builder.toString();
    }

    protected boolean needsEscape(String value) {
        if (value == null) {
            return false;
        }
        return value.contains("\n");
    }

    @Override
    public T applyAll(Consumer<DbObject<?>> consumer) {
        this.equals(this, new GetAllDbObjectEqualsHandler(consumer));
        return this.instance();
    }

    protected TableSpace getTableSpaceFromParent(TableSpace tableSpace) {
        return SchemaUtils.getTableSpaceFromParent(tableSpace, this);
    }

    protected abstract Supplier<T> newInstance();
}

