/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.converter.Converters;
import com.sqlapp.data.db.datatype.DataType;
import com.sqlapp.data.db.datatype.DbDataType;
import com.sqlapp.data.schemas.AbstractSchemaObject;
import com.sqlapp.data.schemas.CharacterSemantics;
import com.sqlapp.data.schemas.EqualsHandler;
import com.sqlapp.data.schemas.IdentityGenerationType;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.SchemaUtils;
import com.sqlapp.data.schemas.Sequence;
import com.sqlapp.data.schemas.properties.DataTypeSetProperties;
import com.sqlapp.data.schemas.properties.DefaultValueProperty;
import com.sqlapp.data.schemas.properties.FormulaPersistedProperty;
import com.sqlapp.data.schemas.properties.FormulaProperty;
import com.sqlapp.data.schemas.properties.ISchemaProperty;
import com.sqlapp.data.schemas.properties.IdentityCacheProperty;
import com.sqlapp.data.schemas.properties.IdentityCacheSizeProperty;
import com.sqlapp.data.schemas.properties.IdentityCycleProperty;
import com.sqlapp.data.schemas.properties.IdentityGenerationTypeProperty;
import com.sqlapp.data.schemas.properties.IdentityLastValueProperty;
import com.sqlapp.data.schemas.properties.IdentityMaxValueProperty;
import com.sqlapp.data.schemas.properties.IdentityMinValueProperty;
import com.sqlapp.data.schemas.properties.IdentityOrderProperty;
import com.sqlapp.data.schemas.properties.IdentityProperty;
import com.sqlapp.data.schemas.properties.IdentityStartValueProperty;
import com.sqlapp.data.schemas.properties.IdentityStepProperty;
import com.sqlapp.data.schemas.properties.NotNullProperty;
import com.sqlapp.data.schemas.properties.StringUnitsProperty;
import com.sqlapp.data.schemas.properties.ValuesProperty;
import com.sqlapp.data.schemas.properties.complex.SequenceProperty;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.EqualsUtils;
import com.sqlapp.util.StaxWriter;
import com.sqlapp.util.ToStringBuilder;
import java.util.Set;
import javax.xml.stream.XMLStreamException;

public abstract class AbstractColumn<T extends AbstractColumn<T>>
extends AbstractSchemaObject<T>
implements DataTypeSetProperties<T>,
NotNullProperty<T>,
ValuesProperty<T>,
DefaultValueProperty<T>,
IdentityProperty<T>,
SequenceProperty<T>,
IdentityStartValueProperty<T>,
IdentityMaxValueProperty<T>,
IdentityMinValueProperty<T>,
IdentityStepProperty<T>,
IdentityLastValueProperty<T>,
IdentityCacheProperty<T>,
IdentityCacheSizeProperty<T>,
IdentityCycleProperty<T>,
IdentityOrderProperty<T>,
IdentityGenerationTypeProperty<T>,
StringUnitsProperty<T>,
FormulaProperty<T>,
FormulaPersistedProperty<T> {
    private static final long serialVersionUID = 8775419796577781694L;
    private static final Sequence DEFAULT_VALUE_SEQUENCE = new Sequence();
    private boolean notNull = (Boolean)SchemaProperties.NOT_NULL.getDefaultValue();
    private Long length = null;
    private Long octetLength = null;
    private CharacterSemantics characterSemantics = (CharacterSemantics)SchemaProperties.CHARACTER_SEMANTICS.getDefaultValue();
    private String characterSet = (String)SchemaProperties.CHARACTER_SET.getDefaultValue();
    private String collation = (String)SchemaProperties.COLLATION.getDefaultValue();
    private boolean identity = (Boolean)SchemaProperties.IDENTITY.getDefaultValue();
    private IdentityGenerationType identityGenerationType = (IdentityGenerationType)SchemaProperties.IDENTITY_GENERATION_TYPE.getDefaultValue();
    private Sequence sequence = null;
    private DataType dataType = (DataType)((Object)SchemaProperties.DATA_TYPE.getDefaultValue());
    protected String dataTypeName = (String)SchemaProperties.DATA_TYPE_NAME.getDefaultValue();
    private Integer scale = null;
    private String defaultValue = null;
    private String formula = null;
    private boolean formulaPersisted = (Boolean)SchemaProperties.FORMULA_PERSISTED.getDefaultValue();
    private int arrayDimension = (Integer)SchemaProperties.ARRAY_DIMENSION.getDefaultValue();
    private int arrayDimensionLowerBound = (Integer)SchemaProperties.ARRAY_DIMENSION_LOWER_BOUND.getDefaultValue();
    private int arrayDimensionUpperBound = (Integer)SchemaProperties.ARRAY_DIMENSION_UPPER_BOUND.getDefaultValue();
    private Set<String> values = CommonUtils.linkedSet();
    private String stringUnits = null;

    protected AbstractColumn() {
    }

    protected AbstractColumn(String columnName) {
        super(columnName);
    }

    @Override
    public T setCharacterSet(String characterSet) {
        this.characterSet = CommonUtils.eq(this.getCharacterSet(), characterSet) ? null : characterSet;
        return (T)this;
    }

    @Override
    public T setCollation(String value) {
        this.collation = CommonUtils.eq(this.getCollation(), value) ? null : value;
        return (T)((AbstractColumn)this.instance());
    }

    @Override
    public String getStringUnits() {
        return this.stringUnits;
    }

    @Override
    public T setStringUnits(String stringUnits) {
        this.stringUnits = stringUnits;
        return (T)((AbstractColumn)this.instance());
    }

    @Override
    public boolean equals(Object obj, EqualsHandler equalsHandler) {
        if (!(obj instanceof AbstractColumn)) {
            return false;
        }
        if (!super.equals(obj, equalsHandler)) {
            return false;
        }
        AbstractColumn val = (AbstractColumn)obj;
        if (!this.equals(SchemaProperties.DATA_TYPE, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.DATA_TYPE_NAME, val, equalsHandler, EqualsUtils.getEqualsIgnoreCaseSupplier(this.getDataTypeName(), val.getDataTypeName()))) {
            return false;
        }
        if (this.getDataType() == null || this.getDataType().isFixedSize()) {
            if (!this.equals(SchemaProperties.LENGTH, val, equalsHandler)) {
                return false;
            }
            if (!this.equals(SchemaProperties.OCTET_LENGTH, val, equalsHandler)) {
                return false;
            }
        }
        if (!(this.getDataType() != null && this.getDataType().isFixedScale() || this.equals(SchemaProperties.SCALE, val, equalsHandler))) {
            return false;
        }
        if (!this.equals(SchemaProperties.CHARACTER_SEMANTICS, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.CHARACTER_SET, val, equalsHandler, EqualsUtils.getEqualsIgnoreCaseSupplier(this.getCharacterSet(), val.getCharacterSet()))) {
            return false;
        }
        if (!this.equals(SchemaProperties.COLLATION, val, equalsHandler, EqualsUtils.getEqualsIgnoreCaseSupplier(this.getCollation(), val.getCollation()))) {
            return false;
        }
        if (!this.equals(SchemaProperties.NOT_NULL, val, equalsHandler)) {
            return false;
        }
        boolean auto = this.equals(SchemaProperties.IDENTITY, val, equalsHandler);
        if (!auto) {
            return false;
        }
        if (auto) {
            if (!this.equals(SchemaProperties.IDENTITY_GENERATION_TYPE, val, equalsHandler)) {
                return false;
            }
            if (!this.equals(SchemaProperties.IDENTITY_START_VALUE, val, equalsHandler)) {
                return false;
            }
            if (!this.equals(SchemaProperties.IDENTITY_MAX_VALUE, val, equalsHandler)) {
                return false;
            }
            if (!this.equals(SchemaProperties.IDENTITY_MIN_VALUE, val, equalsHandler)) {
                return false;
            }
            if (!this.equals(SchemaProperties.IDENTITY_STEP, val, equalsHandler)) {
                return false;
            }
            if (!this.equals(SchemaProperties.IDENTITY_LAST_VALUE, val, equalsHandler)) {
                return false;
            }
            if (!this.equals(SchemaProperties.IDENTITY_CACHE, val, equalsHandler)) {
                return false;
            }
            if (!this.equals(SchemaProperties.IDENTITY_CACHE_SIZE, val, equalsHandler)) {
                return false;
            }
            if (!this.equals(SchemaProperties.IDENTITY_CYCLE, val, equalsHandler)) {
                return false;
            }
            if (!this.equals(SchemaProperties.IDENTITY_ORDER, val, equalsHandler)) {
                return false;
            }
        }
        if (!(CommonUtils.eq(this.getSequenceSchemaName(), this.getSchemaName()) && CommonUtils.eq(val.getSequenceSchemaName(), val.getSchemaName()) || this.equals(SchemaProperties.SEQUENCE_SCHEMA_NAME, val, equalsHandler))) {
            return false;
        }
        if (!this.equals(SchemaProperties.SEQUENCE_NAME, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.DEFAULT_VALUE, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.FORMULA, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.FORMULA_PERSISTED, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.ARRAY_DIMENSION, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.ARRAY_DIMENSION_LOWER_BOUND, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.ARRAY_DIMENSION_UPPER_BOUND, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.VALUES, val, equalsHandler)) {
            return false;
        }
        return this.equals(SchemaProperties.STRING_UNITS, val, equalsHandler, EqualsUtils.getEqualsIgnoreCaseSupplier(this.getStringUnits(), val.getStringUnits()));
    }

    @Override
    public boolean isNotNull() {
        return this.notNull;
    }

    @Override
    public T setNotNull(boolean notNull) {
        this.notNull = notNull;
        return (T)((AbstractColumn)this.instance());
    }

    @Override
    public Long getLength() {
        return this.length;
    }

    @Override
    public T setLength(long maxLength) {
        this.length = maxLength;
        return (T)((AbstractColumn)this.instance());
    }

    @Override
    public T setLength(Number maxLength) {
        this.length = Converters.getDefault().convertObject(maxLength, Long.class);
        return (T)((AbstractColumn)this.instance());
    }

    @Override
    public Long getOctetLength() {
        return this.octetLength;
    }

    @Override
    public T setOctetLength(long octetLength) {
        this.octetLength = octetLength;
        return (T)((AbstractColumn)this.instance());
    }

    @Override
    public T setOctetLength(Number octetLength) {
        this.octetLength = Converters.getDefault().convertObject(octetLength, Long.class);
        return (T)((AbstractColumn)this.instance());
    }

    @Override
    public boolean isIdentity() {
        return this.identity;
    }

    @Override
    public T setIdentity(boolean value) {
        this.identity = value;
        return (T)((AbstractColumn)this.instance());
    }

    @Override
    public IdentityGenerationType getIdentityGenerationType() {
        return this.identityGenerationType;
    }

    @Override
    public T setIdentityGenerationType(IdentityGenerationType identityGenerationType) {
        this.identityGenerationType = identityGenerationType;
        return (T)((AbstractColumn)this.instance());
    }

    @Override
    public Long getIdentityStep() {
        if (this.getSequence() != null && this.getSequence().getIncrementBy() != null) {
            return this.getSequence().getIncrementBy().longValue();
        }
        return null;
    }

    @Override
    public T setIdentityStep(Number value) {
        if (this.getSequence() == null) {
            this.setSequence(new Sequence());
        }
        this.getSequence().setIncrementBy(value);
        return (T)((AbstractColumn)this.instance());
    }

    @Override
    public T setIdentityStep(long value) {
        if (this.getSequence() == null) {
            this.setSequence(new Sequence());
        }
        this.getSequence().setIncrementBy(value);
        return (T)((AbstractColumn)this.instance());
    }

    @Override
    public Long getIdentityLastValue() {
        if (this.getSequence() != null && this.getSequence().getLastValue() != null) {
            return this.getSequence().getLastValue().longValue();
        }
        return null;
    }

    @Override
    public T setIdentityLastValue(Number value) {
        if (this.getSequence() == null) {
            this.setSequence(new Sequence());
        }
        this.getSequence().setLastValue(value);
        return (T)((AbstractColumn)this.instance());
    }

    @Override
    public T setIdentityLastValue(long value) {
        if (this.getSequence() == null) {
            this.setSequence(new Sequence());
        }
        this.getSequence().setLastValue(value);
        return (T)((AbstractColumn)this.instance());
    }

    @Override
    public Long getIdentityStartValue() {
        if (this.getSequence() != null && this.getSequence().getStartValue() != null) {
            return this.getSequence().getStartValue().longValue();
        }
        return null;
    }

    @Override
    public T setIdentityStartValue(Number value) {
        if (this.getSequence() == null) {
            this.setSequence(new Sequence());
        }
        this.getSequence().setStartValue(value);
        return (T)((AbstractColumn)this.instance());
    }

    @Override
    public T setIdentityStartValue(long value) {
        if (this.getSequence() == null) {
            this.setSequence(new Sequence());
        }
        this.getSequence().setStartValue(value);
        return (T)((AbstractColumn)this.instance());
    }

    @Override
    public Long getIdentityMaxValue() {
        if (this.getSequence() != null && this.getSequence().getMaxValue() != null) {
            return this.getSequence().getMaxValue().longValue();
        }
        return null;
    }

    @Override
    public T setIdentityMaxValue(Number value) {
        if (this.getSequence() == null) {
            this.setSequence(new Sequence());
        }
        this.getSequence().setMaxValue(value);
        return (T)((AbstractColumn)this.instance());
    }

    @Override
    public T setIdentityMaxValue(long value) {
        if (this.getSequence() == null) {
            this.setSequence(new Sequence());
        }
        this.getSequence().setMaxValue(value);
        return (T)((AbstractColumn)this.instance());
    }

    @Override
    public Long getIdentityMinValue() {
        if (this.getSequence() != null && this.getSequence().getMinValue() != null) {
            return this.getSequence().getMinValue().longValue();
        }
        return null;
    }

    @Override
    public T setIdentityMinValue(Number value) {
        if (this.getSequence() == null) {
            this.setSequence(new Sequence());
        }
        this.getSequence().setMinValue(value);
        return (T)((AbstractColumn)this.instance());
    }

    @Override
    public T setIdentityMinValue(long value) {
        if (this.getSequence() == null) {
            this.setSequence(new Sequence());
        }
        this.getSequence().setMinValue(value);
        return (T)((AbstractColumn)this.instance());
    }

    @Override
    public boolean isIdentityCache() {
        if (this.getSequence() != null) {
            return this.getSequence().isCache();
        }
        return DEFAULT_VALUE_SEQUENCE.isCache();
    }

    @Override
    public T setIdentityCache(boolean value) {
        if (this.isIdentity()) {
            this.getSequence().setCache(value);
        }
        return (T)((AbstractColumn)this.instance());
    }

    @Override
    public Integer getIdentityCacheSize() {
        if (this.getSequence() != null && this.getSequence().getCacheSize() != null) {
            return (int)this.getSequence().getCacheSize();
        }
        return null;
    }

    @Override
    public T setIdentityCacheSize(Number value) {
        if (this.getSequence() == null) {
            this.setSequence(new Sequence());
        }
        this.getSequence().setCacheSize(value);
        return (T)((AbstractColumn)this.instance());
    }

    @Override
    public T setIdentityCacheSize(int value) {
        if (this.getSequence() == null) {
            this.setSequence(new Sequence());
        }
        this.getSequence().setStartValue(value);
        return (T)((AbstractColumn)this.instance());
    }

    @Override
    public boolean isIdentityCycle() {
        if (this.getSequence() != null) {
            return this.getSequence().isCycle();
        }
        return DEFAULT_VALUE_SEQUENCE.isCycle();
    }

    @Override
    public T setIdentityCycle(boolean value) {
        if (this.isIdentity()) {
            this.getSequence().setCycle(value);
        }
        return (T)((AbstractColumn)this.instance());
    }

    @Override
    public boolean isIdentityOrder() {
        if (this.getSequence() != null) {
            return this.getSequence().isOrder();
        }
        return DEFAULT_VALUE_SEQUENCE.isOrder();
    }

    @Override
    public T setIdentityOrder(boolean value) {
        if (this.isIdentity()) {
            this.getSequence().setOrder(value);
        }
        return (T)((AbstractColumn)this.instance());
    }

    @Override
    public String getSequenceSchemaName() {
        return this.getSequence() == null ? null : this.getSequence().getSchemaName();
    }

    @Override
    public String getSequenceName() {
        return this.getSequence() == null ? null : this.getSequence().getName();
    }

    @Override
    public String getDataTypeName() {
        return this.dataTypeName;
    }

    @Override
    protected void validate() {
        DbDataType<?> dbDataType;
        this.setDataTypeName(this.getDataTypeName());
        if (this.getDataType() != null && this.getDialect() != null && (dbDataType = this.getDialect().getDbDataType(this)) != null && !dbDataType.isFixedScale()) {
            this.setScale(null);
        }
    }

    @Override
    public Integer getScale() {
        return this.scale;
    }

    @Override
    public T setScale(Number scale) {
        this.scale = Converters.getDefault().convertObject(scale, Integer.class);
        return (T)((AbstractColumn)this.instance());
    }

    @Override
    public T setScale(int scale) {
        this.scale = scale;
        return (T)((AbstractColumn)this.instance());
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public T setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue != null ? CommonUtils.trim(defaultValue).intern() : null;
        return (T)((AbstractColumn)this.instance());
    }

    @Override
    protected void toStringDetail(ToStringBuilder builder) {
        builder.add((ISchemaProperty)SchemaProperties.DATA_TYPE, (Object)this.dataType);
        builder.add((ISchemaProperty)SchemaProperties.DATA_TYPE_NAME, this.dataTypeName);
        builder.add((ISchemaProperty)SchemaProperties.NOT_NULL, (Object)this.isNotNull());
        if (this.getDataType() == null || this.getDataType().isFixedSize()) {
            builder.add((ISchemaProperty)SchemaProperties.LENGTH, (Object)this.getLength());
            builder.add((ISchemaProperty)SchemaProperties.OCTET_LENGTH, (Object)this.getOctetLength());
        }
        if (this.getDataType() == null || !this.getDataType().isFixedScale()) {
            builder.add((ISchemaProperty)SchemaProperties.SCALE, (Object)this.getScale());
        }
        if (this.isIdentity()) {
            builder.add((ISchemaProperty)SchemaProperties.IDENTITY, (Object)this.isIdentity());
        } else {
            builder.add((ISchemaProperty)SchemaProperties.SEQUENCE_NAME, this.getSequenceName());
        }
        builder.add((ISchemaProperty)SchemaProperties.DEFAULT_VALUE, this.getDefaultValue());
        builder.add((ISchemaProperty)SchemaProperties.IDENTITY_GENERATION_TYPE, (Object)this.getIdentityGenerationType());
        builder.add((ISchemaProperty)SchemaProperties.CHARACTER_SEMANTICS, (Object)this.getCharacterSemantics());
        builder.add((ISchemaProperty)SchemaProperties.CHARACTER_SET, this.getCharacterSet());
        builder.add((ISchemaProperty)SchemaProperties.COLLATION, this.getCollation());
        if (this.arrayDimension > 0) {
            builder.add((ISchemaProperty)SchemaProperties.ARRAY_DIMENSION, (Object)this.arrayDimension);
            builder.add((ISchemaProperty)SchemaProperties.ARRAY_DIMENSION_LOWER_BOUND, (Object)this.arrayDimensionLowerBound);
            builder.add((ISchemaProperty)SchemaProperties.ARRAY_DIMENSION_UPPER_BOUND, (Object)this.arrayDimensionUpperBound);
        }
        builder.add((ISchemaProperty)SchemaProperties.VALUES, this.getValues());
        builder.add((ISchemaProperty)SchemaProperties.FORMULA, this.formula);
        if (!CommonUtils.isEmpty(this.formula)) {
            builder.add((ISchemaProperty)SchemaProperties.FORMULA_PERSISTED, (Object)this.formulaPersisted);
        }
        builder.add((ISchemaProperty)SchemaProperties.STRING_UNITS, this.getStringUnits());
    }

    @Override
    protected void writeXmlOptionalAttributes(StaxWriter stax) throws XMLStreamException {
        super.writeXmlOptionalAttributes(stax);
        stax.writeAttribute(SchemaProperties.DATA_TYPE.getLabel(), (Object)this.getDataType());
        stax.writeAttribute(SchemaProperties.DATA_TYPE_NAME.getLabel(), this.getDataTypeName());
        if (this.getDataType() == null || this.getDataType().isFixedSize()) {
            stax.writeAttribute(SchemaProperties.LENGTH.getLabel(), (Object)this.getLength());
            if (!CommonUtils.eq(this.getLength(), this.getOctetLength())) {
                stax.writeAttribute(SchemaProperties.OCTET_LENGTH.getLabel(), (Object)this.getOctetLength());
            }
        }
        if (this.getDataType() == null || !this.getDataType().isFixedScale()) {
            stax.writeAttribute(SchemaProperties.SCALE.getLabel(), (Object)this.getScale());
        }
        if (this.isNotNull()) {
            stax.writeAttribute(SchemaProperties.NOT_NULL.getLabel(), (Object)this.isNotNull());
        }
        if (this.isIdentity()) {
            stax.writeAttribute(SchemaProperties.IDENTITY.getLabel(), (Object)this.isIdentity());
            stax.writeAttribute(SchemaProperties.IDENTITY_START_VALUE.getLabel(), (Object)this.getIdentityStartValue());
            stax.writeAttribute(SchemaProperties.IDENTITY_MAX_VALUE.getLabel(), (Object)this.getIdentityMaxValue());
            stax.writeAttribute(SchemaProperties.IDENTITY_MIN_VALUE.getLabel(), (Object)this.getIdentityMinValue());
            stax.writeAttribute(SchemaProperties.IDENTITY_STEP.getLabel(), (Object)this.getIdentityStep());
            stax.writeAttribute(SchemaProperties.IDENTITY_LAST_VALUE.getLabel(), (Object)this.getIdentityLastValue());
            stax.writeAttribute(SchemaProperties.IDENTITY_GENERATION_TYPE.getLabel(), (Object)this.getIdentityGenerationType());
            if (this.isIdentityCache() != DEFAULT_VALUE_SEQUENCE.isCache()) {
                stax.writeAttribute(SchemaProperties.IDENTITY_CACHE.getLabel(), (Object)this.isIdentityCache());
            }
            stax.writeAttribute(SchemaProperties.IDENTITY_CACHE_SIZE.getLabel(), (Object)this.getIdentityCacheSize());
            if (this.isIdentityCycle() != DEFAULT_VALUE_SEQUENCE.isCycle()) {
                stax.writeAttribute(SchemaProperties.IDENTITY_CYCLE.getLabel(), (Object)this.isIdentityCycle());
            }
            if (this.isIdentityOrder() != DEFAULT_VALUE_SEQUENCE.isOrder()) {
                stax.writeAttribute(SchemaProperties.IDENTITY_ORDER.getLabel(), (Object)this.isIdentityOrder());
            }
        } else if (this.getSequenceName() != null) {
            if (!CommonUtils.eq(this.getSchemaName(), this.getSequenceSchemaName())) {
                stax.writeAttribute(SchemaProperties.SEQUENCE_SCHEMA_NAME.getLabel(), this.getSequenceSchemaName());
            }
            stax.writeAttribute(SchemaProperties.SEQUENCE_NAME.getLabel(), this.getSequenceName());
        }
        this.writeCharacterSemantics(stax);
        this.writeCharacterSet(stax);
        this.writeCollation(stax);
        this.writeStringUnits(stax);
        stax.writeAttribute(SchemaProperties.DEFAULT_VALUE.getLabel(), this.getDefaultValue());
        if (this.getArrayDimension() > 0) {
            stax.writeAttribute(SchemaProperties.ARRAY_DIMENSION.getLabel(), (Object)this.getArrayDimension());
            if (this.getArrayDimensionLowerBound() > 0) {
                stax.writeAttribute(SchemaProperties.ARRAY_DIMENSION_LOWER_BOUND.getLabel(), (Object)this.getArrayDimensionLowerBound());
            }
            if (this.getArrayDimensionUpperBound() > 0) {
                stax.writeAttribute(SchemaProperties.ARRAY_DIMENSION_UPPER_BOUND.getLabel(), (Object)this.getArrayDimensionUpperBound());
            }
        }
        stax.writeAttribute(SchemaProperties.FORMULA.getLabel(), this.getFormula());
        if (!CommonUtils.isEmpty(this.getFormula()) && this.isFormulaPersisted()) {
            stax.writeAttribute(SchemaProperties.FORMULA_PERSISTED.getLabel(), (Object)this.isFormulaPersisted());
        }
    }

    protected void writeCharacterSet(StaxWriter stax) throws XMLStreamException {
        String value = SchemaUtils.getParentCharacterSet(this);
        if (!CommonUtils.eqIgnoreCase(value, this.getCharacterSet())) {
            stax.writeAttribute(SchemaProperties.CHARACTER_SET.getLabel(), this.getCharacterSet());
        }
    }

    protected void writeCollation(StaxWriter stax) throws XMLStreamException {
        String value = SchemaUtils.getParentCollation(this);
        if (!CommonUtils.eqIgnoreCase(value, this.getCollation())) {
            stax.writeAttribute(SchemaProperties.COLLATION.getLabel(), this.getCollation());
        }
    }

    protected void writeCharacterSemantics(StaxWriter stax) throws XMLStreamException {
        CharacterSemantics value = SchemaUtils.getParentCharacterSemantics(this);
        if (!CommonUtils.eq(value, this.getCharacterSemantics())) {
            stax.writeAttribute(SchemaProperties.CHARACTER_SEMANTICS.getLabel(), (Object)this.getCharacterSemantics());
        }
    }

    protected void writeStringUnits(StaxWriter stax) throws XMLStreamException {
        stax.writeAttribute(SchemaProperties.STRING_UNITS.getLabel(), this.getStringUnits());
    }

    @Override
    protected void writeXmlOptionalValues(StaxWriter stax) throws XMLStreamException {
        super.writeXmlOptionalValues(stax);
        if (!CommonUtils.isEmpty(this.getValues())) {
            stax.newLine();
            stax.indent();
            stax.writeElementValues(SchemaProperties.VALUES.getLabel(), this.getValues());
        }
    }

    @Override
    public String getFormula() {
        return this.formula;
    }

    @Override
    public T setFormula(String formula) {
        this.formula = formula;
        return (T)((AbstractColumn)this.instance());
    }

    @Override
    public boolean isFormulaPersisted() {
        return this.formulaPersisted;
    }

    @Override
    public T setFormulaPersisted(boolean formulaPersisted) {
        this.formulaPersisted = formulaPersisted;
        return (T)((AbstractColumn)this.instance());
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    @Override
    public T setDataType(DataType dbType) {
        this.dataType = dbType;
        return (T)((AbstractColumn)this.instance());
    }

    @Override
    public int getArrayDimensionLowerBound() {
        return this.arrayDimensionLowerBound;
    }

    @Override
    public T setArrayDimensionLowerBound(int arrayDimensionLowerBound) {
        this.arrayDimensionLowerBound = arrayDimensionLowerBound;
        return (T)((AbstractColumn)this.instance());
    }

    @Override
    public int getArrayDimensionUpperBound() {
        return this.arrayDimensionUpperBound;
    }

    @Override
    public T setArrayDimensionUpperBound(int arrayDimensionUpperBound) {
        this.arrayDimensionUpperBound = arrayDimensionUpperBound;
        return (T)((AbstractColumn)this.instance());
    }

    @Override
    public int getArrayDimension() {
        return this.arrayDimension;
    }

    @Override
    public T setArrayDimension(int arrayDimension) {
        this.arrayDimension = arrayDimension;
        return (T)((AbstractColumn)this.instance());
    }

    @Override
    public Set<String> getValues() {
        return this.values;
    }

    @Override
    public T setValues(Set<String> values) {
        this.values = values;
        return (T)((AbstractColumn)this.instance());
    }

    @Override
    public T setCharacterSemantics(CharacterSemantics value) {
        this.characterSemantics = CommonUtils.eq(this.getCharacterSemantics(), value) ? null : value;
        return (T)((AbstractColumn)this.instance());
    }
}

