/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.AbstractBaseDbObjectXmlReaderHandler;
import com.sqlapp.data.schemas.AbstractNamedObject;
import com.sqlapp.data.schemas.AbstractNamedObjectCollection;
import com.sqlapp.data.schemas.AbstractObjectXmlReaderHandler;
import com.sqlapp.data.schemas.DbCommonObject;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.StaxReader;
import java.util.Map;
import java.util.function.Supplier;
import javax.xml.stream.XMLStreamException;

abstract class AbstractNamedObjectXmlReaderHandler<T extends AbstractNamedObject<?>>
extends AbstractBaseDbObjectXmlReaderHandler<T> {
    protected AbstractNamedObjectXmlReaderHandler(Supplier<T> supplier) {
        super(supplier);
    }

    @Override
    protected void initializeSetValue() {
        super.initializeSetValue();
    }

    @Override
    protected void doHandle(StaxReader reader, Object parentObject) throws XMLStreamException {
        AbstractNamedObject obj = null;
        obj = parentObject instanceof AbstractObjectXmlReaderHandler.ChildObjectHolder ? (AbstractNamedObject)((AbstractObjectXmlReaderHandler.ChildObjectHolder)parentObject).getValue() : (AbstractNamedObject)this.createNewInstance(parentObject);
        while (reader.hasNext()) {
            if (reader.isStartElement()) {
                Map<String, String> map = this.getAttributeMap(reader);
                String name = map.get(SchemaProperties.NAME.getLabel());
                String specificName = map.get(SchemaProperties.SPECIFIC_NAME.getLabel());
                String schemaName = map.get(SchemaProperties.SCHEMA_NAME.getLabel());
                if (!CommonUtils.isEmpty(name)) {
                    obj = this.getInstance(parentObject, name, specificName, schemaName, obj);
                }
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    this.setValue(obj, entry.getKey(), entry.getValue());
                }
                reader.next();
            }
            if (this.match(reader)) {
                reader.next();
                break;
            }
            this.callChilds(reader, obj);
        }
        this.finishDoHandle(reader, parentObject, obj);
        this.callParent(reader, this.getLocalName(), parentObject, obj);
    }

    protected T getInstance(Object parentObject, String name, String specificName, String schemaName, T obj) {
        AbstractNamedObjectCollection parent;
        DbCommonObject<?> parentObj = this.toParent(parentObject);
        if (parentObj instanceof AbstractNamedObjectCollection && (parent = (AbstractNamedObjectCollection)parentObj) != null) {
            Object a = parent.get(specificName);
            if (a != null) {
                return a;
            }
            if (specificName != null) {
                return obj;
            }
            Object b = parent.get(name);
            if (b != null) {
                return b;
            }
        }
        return obj;
    }
}

