/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.AbstractNamedObject;
import com.sqlapp.data.schemas.AbstractSchemaObjectCollection;
import com.sqlapp.data.schemas.DbCommonObject;
import com.sqlapp.data.schemas.EqualsHandler;
import com.sqlapp.data.schemas.Schema;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.properties.SchemaNameGetter;
import com.sqlapp.data.schemas.properties.SchemaNameProperty;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.StaxWriter;
import com.sqlapp.util.ToStringBuilder;
import java.io.Serializable;
import javax.xml.stream.XMLStreamException;

public abstract class AbstractSchemaObject<T extends AbstractSchemaObject<T>>
extends AbstractNamedObject<T>
implements Serializable,
Cloneable,
SchemaNameProperty<T> {
    private static final long serialVersionUID = 210101856540540272L;
    protected String schemaName = null;

    protected AbstractSchemaObject() {
    }

    protected AbstractSchemaObject(String name) {
        super(name);
    }

    protected AbstractSchemaObject(String name, String specificName) {
        super(name, specificName);
    }

    @Override
    public T setName(String name) {
        super.setName(name);
        return (T)this;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ CommonUtils.xor(this.getSchemaName(), this.getName());
    }

    @Override
    public boolean equals(Object obj, EqualsHandler equalsHandler) {
        if (!super.equals(obj, equalsHandler)) {
            return false;
        }
        if (!(obj instanceof AbstractSchemaObject)) {
            return false;
        }
        AbstractSchemaObject val = (AbstractSchemaObject)CommonUtils.cast(obj);
        return this.getParent() != null || val.getParent() != null || this.equals(SchemaProperties.SCHEMA_NAME, val, equalsHandler);
    }

    @Override
    public String toString() {
        ToStringBuilder builder = new ToStringBuilder(this.getSimpleName());
        if (this.getParent() == null) {
            builder.add(SchemaProperties.CATALOG_NAME.getLabel(), this.getCatalogName());
            builder.add(SchemaProperties.SCHEMA_NAME.getLabel(), this.getSchemaName());
        }
        builder.add(SchemaProperties.NAME.getLabel(), this.getName());
        if (!CommonUtils.eq(this.getName(), this.getSpecificName())) {
            builder.add(SchemaProperties.SPECIFIC_NAME.getLabel(), this.getSpecificName());
        }
        this.toString(builder);
        return builder.toString();
    }

    @Override
    public String toStringSimple() {
        ToStringBuilder builder = new ToStringBuilder(this.getSimpleName());
        if (this.getParent() == null) {
            builder.add(SchemaProperties.CATALOG_NAME.getLabel(), this.getCatalogName());
            builder.add(SchemaProperties.SCHEMA_NAME.getLabel(), this.getSchemaName());
        }
        builder.add(SchemaProperties.NAME.getLabel(), this.getName());
        if (!CommonUtils.eq(this.getName(), this.getSpecificName()) && this.getSpecificName() != null) {
            builder.add(SchemaProperties.SPECIFIC_NAME.getLabel(), this.getSpecificName());
        }
        return builder.toString();
    }

    @Override
    protected T setParent(AbstractSchemaObjectCollection<?> parent) {
        super.setParent(parent);
        return (T)((AbstractSchemaObject)this.instance());
    }

    @Override
    public String getSchemaName() {
        if (this.getParent() != null) {
            SchemaNameGetter schemaNameGetter = (SchemaNameGetter)this.getAncestor((DbCommonObject<?> p) -> p instanceof SchemaNameGetter);
            String name = null;
            if (schemaNameGetter != null) {
                name = schemaNameGetter.getSchemaName();
                return name;
            }
            Schema schema = (Schema)this.getAncestor((DbCommonObject<?> p) -> p instanceof Schema);
            if (schema != null) {
                name = schema.getName();
            }
            return name;
        }
        return this.schemaName;
    }

    @Override
    public T setSchemaName(String schemaName) {
        this.schemaName = CommonUtils.trim(schemaName);
        return (T)((AbstractSchemaObject)this.instance());
    }

    public Schema getSchema() {
        return this.getAncestor(Schema.class);
    }

    @Override
    protected void writeName(StaxWriter stax) throws XMLStreamException {
        stax.writeAttribute(SchemaProperties.NAME.getLabel(), this.getName());
        if (!CommonUtils.eq(this.getName(), this.getSpecificName())) {
            stax.writeAttribute(SchemaProperties.SPECIFIC_NAME.getLabel(), this.getSpecificName());
        }
    }

    @Override
    protected void writeCommonNameAttribute(StaxWriter stax) throws XMLStreamException {
        if (this.getParent() == null) {
            stax.writeAttribute(SchemaProperties.CATALOG_NAME.getLabel(), this.getCatalogName());
            stax.writeAttribute(SchemaProperties.SCHEMA_NAME.getLabel(), this.getSchemaName());
        }
    }

    protected void writeSimpleXml(StaxWriter stax, boolean writeCommon) throws XMLStreamException {
        stax.newLine();
        stax.indent();
        stax.writeElement(this.getSimpleName(), () -> {
            this.writeName(stax);
            stax.indent(() -> {
                if (writeCommon) {
                    this.writeCommonAttribute(stax);
                }
            });
        });
    }

    protected void writeSimpleXmlWithSchema(StaxWriter stax) throws XMLStreamException {
        stax.newLine();
        stax.indent();
        stax.writeElement(this.getSimpleName(), () -> {
            stax.writeAttribute(SchemaProperties.SCHEMA_NAME.getLabel(), this.getSchemaName());
            this.writeName(stax);
            stax.newLine();
            stax.indent();
        });
    }
}

