/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.AbstractNamedObjectCollection;
import com.sqlapp.data.schemas.AbstractSchemaObject;
import com.sqlapp.data.schemas.DbCommonObject;
import com.sqlapp.data.schemas.EqualsHandler;
import com.sqlapp.data.schemas.Schema;
import com.sqlapp.util.CommonUtils;

public abstract class AbstractSchemaObjectCollection<T extends AbstractSchemaObject<? super T>>
extends AbstractNamedObjectCollection<T> {
    private static final long serialVersionUID = 4540018510759477211L;
    private Schema schema = null;

    protected AbstractSchemaObjectCollection() {
    }

    protected AbstractSchemaObjectCollection(DbCommonObject<?> parent) {
        this.setParent(parent);
        this.setSchema(this.getAncestor(Schema.class));
    }

    protected AbstractSchemaObjectCollection(Schema schema) {
        this.setParent(schema);
        this.setSchema(schema);
    }

    @Override
    public AbstractSchemaObjectCollection<T> clone() {
        return (AbstractSchemaObjectCollection)CommonUtils.cast(super.clone());
    }

    @Override
    public boolean equals(Object obj, EqualsHandler equalsHandler) {
        if (!(obj instanceof AbstractSchemaObjectCollection)) {
            return false;
        }
        return super.equals(obj, equalsHandler);
    }

    public Schema getSchema() {
        return this.schema;
    }

    protected void setSchema(Schema schema) {
        this.schema = schema;
    }

    protected String getSchemaName() {
        if (this.getSchema() != null) {
            return this.getSchema().getName();
        }
        return null;
    }

    @Override
    protected void initializeSchemaInfo(T e) {
        super.initializeSchemaInfo(e);
        if (this.equalsIgnoreCase(((AbstractSchemaObject)e).schemaName, this.getSchemaName())) {
            ((AbstractSchemaObject)e).setSchemaName(null);
        } else {
            ((AbstractSchemaObject)e).setSchemaName(this.getSchemaName());
        }
    }
}

