/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.converter.Converter;
import com.sqlapp.data.converter.Converters;
import com.sqlapp.data.converter.DefaultConverter;
import com.sqlapp.data.db.datatype.DataType;
import com.sqlapp.data.schemas.AbstractColumn;
import com.sqlapp.data.schemas.AbstractNamedObjectXmlReaderHandler;
import com.sqlapp.data.schemas.CheckConstraint;
import com.sqlapp.data.schemas.ColumnCollection;
import com.sqlapp.data.schemas.DefaultRowIteratorHandler;
import com.sqlapp.data.schemas.EqualsHandler;
import com.sqlapp.data.schemas.ExcludeFilterEqualsHandler;
import com.sqlapp.data.schemas.ForeignKeyConstraint;
import com.sqlapp.data.schemas.HasParent;
import com.sqlapp.data.schemas.IncludeFilterEqualsHandler;
import com.sqlapp.data.schemas.ReferenceColumn;
import com.sqlapp.data.schemas.ReferenceColumnCollection;
import com.sqlapp.data.schemas.Row;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.data.schemas.UniqueConstraint;
import com.sqlapp.data.schemas.properties.CheckProperty;
import com.sqlapp.data.schemas.properties.HiddenProperty;
import com.sqlapp.data.schemas.properties.ISchemaProperty;
import com.sqlapp.data.schemas.properties.MaskingFunctionProperty;
import com.sqlapp.data.schemas.properties.OnUpdateProperty;
import com.sqlapp.data.schemas.properties.PrimaryKeyGetter;
import com.sqlapp.data.schemas.properties.TableNameProperty;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.StaxWriter;
import com.sqlapp.util.ToStringBuilder;
import com.sqlapp.util.xml.AbstractSetValue;
import com.sqlapp.util.xml.EmptyTextSkipHandler;
import com.sqlapp.util.xml.MapHandler;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;

public final class Column
extends AbstractColumn<Column>
implements HasParent<ColumnCollection>,
TableNameProperty<Column>,
HiddenProperty<Column>,
OnUpdateProperty<Column>,
PrimaryKeyGetter,
CheckProperty<Column>,
MaskingFunctionProperty<Column> {
    private static final long serialVersionUID = 7183150115593442021L;
    private String tableName = null;
    private String onUpdate = null;
    private CheckConstraint checkConstraint = null;
    private Converter<?> converter = null;
    public static final String CONVERTER = "converter";
    private Map<String, Object> extendedProperties = null;
    protected static final String EXTENDED_PROPERTIES = "extendedProperties";
    private boolean hidden = false;
    private String maskingFunction = null;

    public Column() {
    }

    public Column(String columnName) {
        super(columnName);
    }

    @Override
    protected Supplier<Column> newInstance() {
        return () -> new Column();
    }

    @Override
    public boolean equals(Object obj, EqualsHandler equalsHandler) {
        if (!super.equals(obj, equalsHandler)) {
            return false;
        }
        if (!(obj instanceof Column)) {
            return false;
        }
        Column val = (Column)obj;
        if (!this.equals(SchemaProperties.CHECK, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.MASKING_FUNCTION, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.HIDDEN, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.ON_UPDATE, val, equalsHandler)) {
            return false;
        }
        return equalsHandler.equalsResult(this, obj);
    }

    @Override
    public String getCheck() {
        if (this.getCheckConstraint() == null) {
            return null;
        }
        return this.getCheckConstraint().getExpression();
    }

    @Override
    protected void cloneProperties(Column clone) {
        super.cloneProperties(clone);
        clone.setConverter(this.getConverter());
        clone.setExtendedProperties(CommonUtils.cloneMap(this.getExtendedProperties()));
        clone.setCheckConstraint(this.getCheckConstraint());
    }

    public Converter getConverter() {
        if (this.converter == null) {
            if (this.getDataType() != null) {
                this.converter = Converters.getDefault().getConverter(this.getDataType().getDefaultClass());
            }
            if (this.converter == null) {
                this.converter = new DefaultConverter();
            }
        }
        return this.converter;
    }

    public Column setConverter(Converter<?> converter) {
        this.converter = converter;
        return this;
    }

    public Map<String, Object> getExtendedProperties() {
        if (this.extendedProperties == null) {
            this.extendedProperties = new HashMap<String, Object>();
        }
        return this.extendedProperties;
    }

    public Column setExtendedProperties(Map<String, Object> extendedProperties) {
        this.extendedProperties = extendedProperties;
        return this;
    }

    @Override
    public ColumnCollection getParent() {
        return (ColumnCollection)CommonUtils.cast(super.getParent());
    }

    protected Column setColumns(ColumnCollection columns) {
        this.setParent(columns);
        return this;
    }

    @Override
    public Column setDataType(DataType type) {
        DataType oldType = this.getDataType();
        if (oldType != type) {
            super.setDataType(type);
            this.converter = null;
            Table table = this.getTable();
            if (table != null && oldType != type && table.getRows().getRowIteratorHandler() instanceof DefaultRowIteratorHandler) {
                for (Row row : table.getRows()) {
                    Object obj = row.get(this);
                    row.put(this, obj);
                }
            }
        }
        return (Column)this.instance();
    }

    public Table getTable() {
        return this.getAncestor(Table.class);
    }

    @Override
    protected void toStringDetail(ToStringBuilder builder) {
        super.toStringDetail(builder);
        if (!CommonUtils.isEmpty(this.getCheckConstraint())) {
            builder.add((ISchemaProperty)SchemaProperties.CHECK, this.getCheck());
        }
    }

    @Override
    public String toStringSimple() {
        ToStringBuilder builder = new ToStringBuilder(this.getSimpleName());
        if (this.getParent() == null) {
            builder.add((ISchemaProperty)SchemaProperties.CATALOG_NAME, this.getCatalogName());
            builder.add((ISchemaProperty)SchemaProperties.SCHEMA_NAME, this.getSchemaName());
            builder.add((ISchemaProperty)SchemaProperties.TABLE_NAME, this.getTableName());
        }
        builder.add(SchemaProperties.NAME.getLabel(), this.getName());
        return builder.toString();
    }

    public CheckConstraint getCheckConstraint() {
        return this.checkConstraint;
    }

    public Column setCheckConstraint(CheckConstraint checkConstraint) {
        this.checkConstraint = checkConstraint;
        return this;
    }

    @Override
    public Column setCheck(String check) {
        if (check != null) {
            CheckConstraint c = new CheckConstraint();
            this.setCheckConstraint(c);
        }
        if (this.getCheckConstraint() != null) {
            this.getCheckConstraint().setExpression(check);
        }
        return this;
    }

    @Override
    public String getCatalogName() {
        Table table = this.getTable();
        if (table != null) {
            return table.getCatalogName();
        }
        return super.getCatalogName();
    }

    @Override
    public String getSchemaName() {
        Table table = this.getTable();
        if (table != null) {
            return table.getSchemaName();
        }
        return super.getSchemaName();
    }

    @Override
    public String getTableName() {
        Table table = this.getTable();
        if (table != null) {
            return table.getName();
        }
        return this.tableName;
    }

    @Override
    public Column setTableName(String tableName) {
        this.tableName = tableName;
        return (Column)this.instance();
    }

    @Override
    public String getOnUpdate() {
        return this.onUpdate;
    }

    @Override
    public Column setOnUpdate(String onUpdate) {
        this.onUpdate = onUpdate;
        return (Column)this.instance();
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public String getMaskingFunction() {
        return this.maskingFunction;
    }

    @Override
    public Column setMaskingFunction(String maskingFunction) {
        this.maskingFunction = maskingFunction;
        return (Column)this.instance();
    }

    @Override
    public Column setHidden(boolean hidden) {
        this.hidden = hidden;
        return (Column)this.instance();
    }

    @Override
    protected void writeXmlOptionalAttributes(StaxWriter stax) throws XMLStreamException {
        super.writeXmlOptionalAttributes(stax);
        stax.writeAttribute(SchemaProperties.CHECK, (Object)this);
        stax.writeAttribute(SchemaProperties.MASKING_FUNCTION, (Object)this);
        stax.writeAttribute(SchemaProperties.ON_UPDATE, (Object)this);
        if (this.isHidden()) {
            stax.writeAttribute(SchemaProperties.HIDDEN, (Object)this);
        }
    }

    @Override
    protected void writeXmlOptionalValues(StaxWriter stax) throws XMLStreamException {
        super.writeXmlOptionalValues(stax);
        if (!CommonUtils.isEmpty(this.getExtendedProperties())) {
            stax.newLine();
            stax.indent();
            stax.writeElement(EXTENDED_PROPERTIES, this.getExtendedProperties());
        }
    }

    @Override
    protected AbstractNamedObjectXmlReaderHandler<Column> getDbObjectXmlReaderHandler() {
        return new AbstractNamedObjectXmlReaderHandler<Column>(this.newInstance()){

            @Override
            protected void initializeSetValue() {
                super.initializeSetValue();
                String keyName = Column.EXTENDED_PROPERTIES;
                this.register(Column.EXTENDED_PROPERTIES, new AbstractSetValue<Column, Map<String, Object>>(){

                    @Override
                    public void setValue(Column target, String name, Map<String, Object> setValue) throws XMLStreamException {
                        target.setExtendedProperties(setValue);
                    }
                });
                this.registerTransparent(Column.EXTENDED_PROPERTIES, new MapHandler(), new EmptyTextSkipHandler());
            }

            protected ColumnCollection toParent(Object parentObject) {
                ColumnCollection parent = null;
                if (parentObject instanceof ColumnCollection) {
                    parent = (ColumnCollection)parentObject;
                }
                return parent;
            }
        };
    }

    @Override
    public boolean isPrimaryKey() {
        if (this.getTable() == null) {
            return false;
        }
        UniqueConstraint uc = this.getTable().getConstraints().getPrimaryKeyConstraint();
        if (uc == null) {
            return false;
        }
        for (ReferenceColumn column : uc.getColumns()) {
            if (!(column.getColumn() != null ? CommonUtils.eq(this.getName(), column.getColumn().getName()) : CommonUtils.eq(this.getName(), column.getName()))) continue;
            return true;
        }
        return false;
    }

    public boolean isForeignKey() {
        if (this.getTable() == null) {
            return false;
        }
        for (ForeignKeyConstraint fk : this.getTable().getConstraints().getForeignKeyConstraints()) {
            for (Column column : fk.getColumns()) {
                if (!CommonUtils.eq(this.getName(), column.getName())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean like(Object obj) {
        if (this.equals(obj, IncludeFilterEqualsHandler.EQUALS_NAME_HANDLER)) {
            return true;
        }
        if (!this.equals(obj, ExcludeFilterEqualsHandler.EQUALS_WITHOUT_NAME_HANDLER)) {
            return false;
        }
        Column column = (Column)obj;
        if (this.getOrdinal() != column.getOrdinal()) {
            return false;
        }
        if (this.getParent() == null || column.getParent() == null) {
            return true;
        }
        Column eqName = (Column)column.getParent().get(this.getName());
        if (eqName != null) {
            return false;
        }
        eqName = (Column)this.getParent().get(column.getName());
        return eqName == null;
    }

    @Override
    public Column setName(String name) {
        String origianlName = this.getName();
        if (CommonUtils.eq(name, origianlName)) {
            return (Column)this.instance();
        }
        Table table = this.getTable();
        if (table != null) {
            List<ReferenceColumnCollection> childColumnsList = table.getChildRelations().stream().filter(fk -> fk.getRelatedColumns() != null).filter(obj -> {
                for (ReferenceColumn refColumn : obj.getRelatedColumns()) {
                    if (!CommonUtils.eq(refColumn.getName(), origianlName)) continue;
                    return true;
                }
                return false;
            }).map(fk -> fk.getRelatedColumns()).collect(Collectors.toList());
            this.changeReferenceColumnName(origianlName, name, childColumnsList);
            List<Column[]> parentColumnsList = table.getConstraints().getForeignKeyConstraints().stream().filter(fk -> fk.getColumns() != null).filter(obj -> {
                for (Column column : obj.getColumns()) {
                    if (!CommonUtils.eq(column.getName(), origianlName)) continue;
                    return true;
                }
                return false;
            }).map(fk -> fk.getColumns()).collect(Collectors.toList());
            this.changeColumnName(origianlName, name, parentColumnsList);
            List<ReferenceColumnCollection> indexColumnsList = table.getIndexes().stream().filter(obj -> {
                for (ReferenceColumn refColumn : obj.getColumns()) {
                    if (!CommonUtils.eq(refColumn.getName(), origianlName)) continue;
                    return true;
                }
                return false;
            }).map(obj -> obj.getColumns()).collect(Collectors.toList());
            this.changeReferenceColumnName(origianlName, name, indexColumnsList);
            List<ReferenceColumnCollection> indexIncludesColumnsList = table.getIndexes().stream().filter(obj -> {
                for (ReferenceColumn refColumn : obj.getIncludes()) {
                    if (!CommonUtils.eq(refColumn.getName(), origianlName)) continue;
                    return true;
                }
                return false;
            }).map(obj -> obj.getColumns()).collect(Collectors.toList());
            this.changeReferenceColumnName(origianlName, name, indexIncludesColumnsList);
            List<ReferenceColumnCollection> ucColumnsList = table.getConstraints().getUniqueConstraints().stream().filter(obj -> {
                for (ReferenceColumn refColumn : obj.getColumns()) {
                    if (!CommonUtils.eq(refColumn.getName(), origianlName)) continue;
                    return true;
                }
                return false;
            }).map(obj -> obj.getColumns()).collect(Collectors.toList());
            this.changeReferenceColumnName(origianlName, name, ucColumnsList);
            List<ReferenceColumnCollection> ecColumnsList = table.getConstraints().getExcludeConstraints().stream().filter(obj -> {
                for (ReferenceColumn refColumn : obj.getColumns()) {
                    if (!CommonUtils.eq(refColumn.getName(), origianlName)) continue;
                    return true;
                }
                return false;
            }).map(obj -> obj.getColumns()).collect(Collectors.toList());
            this.changeReferenceColumnName(origianlName, name, ecColumnsList);
            this.changeReferenceColumnName(origianlName, name, ecColumnsList);
            if (table.getPartitioning() != null) {
                this.changeReferenceColumnName(origianlName, name, table.getPartitioning().getPartitioningColumns());
                this.changeReferenceColumnName(origianlName, name, table.getPartitioning().getSubPartitioningColumns());
            }
            table.getIndexes().stream().filter(obj -> obj.getPartitioning() != null).map(obj -> obj.getPartitioning()).forEach(p -> {
                this.changeReferenceColumnName(origianlName, name, p.getPartitioningColumns());
                this.changeReferenceColumnName(origianlName, name, p.getSubPartitioningColumns());
            });
        }
        super.setName(name);
        return (Column)this.instance();
    }

    private void changeReferenceColumnName(String originalName, String name, List<ReferenceColumnCollection> columnsList) {
        if (CommonUtils.isEmpty(columnsList)) {
            return;
        }
        columnsList.forEach(cc -> cc.forEach(c -> {
            if (CommonUtils.eq(c.getName(), originalName)) {
                c.setName(name);
            }
        }));
        columnsList.forEach(cc -> cc.renew());
    }

    private void changeReferenceColumnName(String originalName, String name, ReferenceColumnCollection columns) {
        if (CommonUtils.isEmpty(columns)) {
            return;
        }
        columns.forEach(c -> {
            if (CommonUtils.eq(c.getName(), originalName)) {
                c.setName(name);
            }
        });
        columns.renew();
    }

    private void changeColumnName(String originalName, String name, List<Column[]> columnsList) {
        if (columnsList == null) {
            return;
        }
        columnsList.forEach(cc -> {
            for (Column column : cc) {
                if (!CommonUtils.eq(column.getName(), originalName)) continue;
                column.setName(name);
            }
        });
    }
}

