/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.AbstractSchemaObject;
import com.sqlapp.data.schemas.CheckConstraint;
import com.sqlapp.data.schemas.ConstraintCollection;
import com.sqlapp.data.schemas.Deferrability;
import com.sqlapp.data.schemas.EqualsHandler;
import com.sqlapp.data.schemas.ExcludeConstraint;
import com.sqlapp.data.schemas.ExcludeFilterEqualsHandler;
import com.sqlapp.data.schemas.ForeignKeyConstraint;
import com.sqlapp.data.schemas.HasParent;
import com.sqlapp.data.schemas.IncludeFilterEqualsHandler;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.data.schemas.UniqueConstraint;
import com.sqlapp.data.schemas.properties.DeferrabilityProperty;
import com.sqlapp.data.schemas.properties.EnableProperty;
import com.sqlapp.data.schemas.properties.ISchemaProperty;
import com.sqlapp.data.schemas.properties.TableNameProperty;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.StaxWriter;
import com.sqlapp.util.ToStringBuilder;
import javax.xml.stream.XMLStreamException;

public abstract class Constraint
extends AbstractSchemaObject<Constraint>
implements Comparable<Constraint>,
TableNameProperty<Constraint>,
EnableProperty<Constraint>,
DeferrabilityProperty<Constraint>,
HasParent<ConstraintCollection> {
    private static final long serialVersionUID = -5534603682647428950L;
    private String tableName = null;
    private boolean enable = (Boolean)SchemaProperties.ENABLE.getDefaultValue();
    private Deferrability deferrability = null;

    @Override
    public Deferrability getDeferrability() {
        return this.deferrability;
    }

    @Override
    public Constraint setDeferrability(Deferrability deferrability) {
        this.deferrability = deferrability;
        return this;
    }

    @Override
    public boolean isEnable() {
        return this.enable;
    }

    @Override
    public Constraint setEnable(boolean enable) {
        this.enable = enable;
        return this;
    }

    @Override
    public String getTableName() {
        Table table = this.getAncestor(Table.class);
        if (table != null) {
            return CommonUtils.coalesce(table.getName(), this.tableName);
        }
        return this.tableName;
    }

    @Override
    public Constraint setTableName(String tableName) {
        this.tableName = tableName;
        return (Constraint)this.instance();
    }

    protected void setTableNameInternal(String tableName) {
        this.tableName = tableName;
    }

    protected Constraint() {
    }

    protected Constraint(String constraintName) {
        super(constraintName);
    }

    @Override
    public ConstraintCollection getParent() {
        return (ConstraintCollection)super.getParent();
    }

    protected void setConstraints(ConstraintCollection constraints) {
        this.setParent(constraints);
    }

    @Override
    public boolean equals(Object obj, EqualsHandler equalsHandler) {
        if (!super.equals(obj, equalsHandler)) {
            return false;
        }
        if (!(obj instanceof Constraint)) {
            return false;
        }
        Constraint val = (Constraint)obj;
        if (!this.equals(SchemaProperties.ENABLE, val, equalsHandler)) {
            return false;
        }
        return this.equals(SchemaProperties.DEFERRABILITY, val, equalsHandler);
    }

    @Override
    public boolean like(Object obj) {
        if (this.equals(obj, IncludeFilterEqualsHandler.EQUALS_NAME_HANDLER)) {
            return true;
        }
        return this.equals(obj, ExcludeFilterEqualsHandler.EQUALS_WITHOUT_NAME_HANDLER);
    }

    @Override
    public String getCatalogName() {
        Table table = this.getAncestor(Table.class);
        if (table != null) {
            return CommonUtils.coalesce(table.getCatalogName(), super.getCatalogName());
        }
        return super.getCatalogName();
    }

    @Override
    public String getSchemaName() {
        Table table = this.getAncestor(Table.class);
        if (table != null) {
            return CommonUtils.coalesce(table.getSchemaName(), super.getSchemaName());
        }
        return super.getSchemaName();
    }

    @Override
    public int compareTo(Constraint o) {
        if (o == null) {
            return -1;
        }
        if (this instanceof UniqueConstraint) {
            if (o instanceof UniqueConstraint) {
                return this.compareTo((UniqueConstraint)this, (UniqueConstraint)o);
            }
            return -1;
        }
        if (this instanceof ExcludeConstraint) {
            if (o instanceof UniqueConstraint) {
                return 1;
            }
            if (o instanceof ExcludeConstraint) {
                return this.compareTo(this, o);
            }
            return -1;
        }
        if (this instanceof CheckConstraint) {
            if (o instanceof UniqueConstraint) {
                return 1;
            }
            if (o instanceof ExcludeConstraint) {
                return 1;
            }
            if (o instanceof CheckConstraint) {
                return this.compareTo(this, o);
            }
            return -1;
        }
        if (this instanceof ForeignKeyConstraint) {
            if (o instanceof ForeignKeyConstraint) {
                return this.compareTo(this, o);
            }
            return 1;
        }
        return 0;
    }

    protected int compareTo(UniqueConstraint o1, UniqueConstraint o2) {
        if (o1 == null) {
            if (o2 == null) {
                return 0;
            }
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (o1.isPrimaryKey()) {
            return -1;
        }
        if (o2.isPrimaryKey()) {
            return 1;
        }
        return CommonUtils.compare((Comparable)((Object)o1.getName()), (Object)o2.getName());
    }

    protected int compareTo(Constraint o1, Constraint o2) {
        if (o1 == null) {
            if (o2 == null) {
                return 0;
            }
            return CommonUtils.compare(null, (Object)o2.getName());
        }
        if (o2 == null) {
            return CommonUtils.compare((Comparable)((Object)o1.getName()), null);
        }
        return CommonUtils.compare((Comparable)((Object)o1.getName()), (Object)o2.getName());
    }

    @Override
    protected void toStringDetail(ToStringBuilder builder) {
        builder.add((ISchemaProperty)SchemaProperties.ENABLE, (Object)this.isEnable());
        builder.add((ISchemaProperty)SchemaProperties.DEFERRABILITY, (Object)this.getDeferrability());
    }

    @Override
    protected void writeXmlOptionalAttributes(StaxWriter stax) throws XMLStreamException {
        super.writeXmlOptionalAttributes(stax);
        if (!this.isEnable()) {
            stax.writeAttribute(SchemaProperties.ENABLE.getLabel(), (Object)this.isEnable());
        }
        stax.writeAttribute(SchemaProperties.DEFERRABILITY.getLabel(), (Object)this.getDeferrability());
    }

    @Override
    protected void writeXmlOptionalValues(StaxWriter stax) throws XMLStreamException {
    }
}

