/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.AbstractDifference;
import com.sqlapp.data.schemas.AssemblyFile;
import com.sqlapp.data.schemas.DbCommonObject;
import com.sqlapp.data.schemas.DbInfo;
import com.sqlapp.data.schemas.DbObjectDifference;
import com.sqlapp.data.schemas.DbObjectDifferenceCollection;
import com.sqlapp.data.schemas.Difference;
import com.sqlapp.data.schemas.EqualsHandler;
import com.sqlapp.data.schemas.Row;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.State;
import com.sqlapp.util.AbstractIterator;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.DeltaUtils;
import com.sqlapp.util.SeparatedStringBuilder;
import com.sqlapp.util.ToStringBuilder;
import difflib.Delta;
import difflib.DiffUtils;
import difflib.Patch;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.BooleanSupplier;

public class DbObjectPropertyDifference
extends AbstractDifference<Object> {
    private static final long serialVersionUID = 6634332562149007807L;

    protected DbObjectPropertyDifference(String propertyName, DbCommonObject<?> original, DbCommonObject<?> target) {
        this(propertyName, original, target, new EqualsHandler());
    }

    protected DbObjectPropertyDifference(DbCommonObject<?> original, DbCommonObject<?> target) {
        this(original, target, new EqualsHandler());
    }

    protected DbObjectPropertyDifference(String propertyName, DbCommonObject<?> original, DbCommonObject<?> target, EqualsHandler equalsHandler) {
        this(propertyName, original, target, equalsHandler, false);
    }

    protected DbObjectPropertyDifference(String propertyName, DbCommonObject<?> original, DbCommonObject<?> target, EqualsHandler equalsHandler, boolean skipDiff) {
        super(propertyName, original, target, equalsHandler);
        if (!skipDiff) {
            this.diff();
        }
    }

    protected DbObjectPropertyDifference(DbCommonObject<?> original, DbCommonObject<?> target, EqualsHandler equalsHandler) {
        this(null, original, target, equalsHandler, false);
    }

    protected DbObjectPropertyDifference(DbCommonObject<?> originalParent, Object original, DbCommonObject<?> targetParent, Object target, EqualsHandler equalsHandler, boolean skipDiff) {
        super(null, originalParent, original, targetParent, target, equalsHandler);
        if (!skipDiff) {
            this.diff();
        }
    }

    protected DbObjectPropertyDifference(String propertyName, DbCommonObject<?> originalParent, Object original, DbCommonObject<?> targetParent, Object target, boolean skipDiff) {
        super(propertyName, originalParent, original, targetParent, target, new EqualsHandler());
        if (!skipDiff) {
            this.diff();
        }
    }

    protected DbObjectPropertyDifference(String propertyName, DbCommonObject<?> originalParent, Object original, DbCommonObject<?> targetParent, Object target, EqualsHandler equalsHandler, boolean skipDiff) {
        super(propertyName, originalParent, original, targetParent, target, equalsHandler);
        if (!skipDiff) {
            this.diff();
        }
    }

    protected DbObjectPropertyDifference(DbCommonObject<?> originalParent, Object original, DbCommonObject<?> targetParent, Object target, EqualsHandler equalsHandler) {
        this(null, originalParent, original, targetParent, target, equalsHandler, true);
    }

    public DbObjectPropertyDifference reverse() {
        DbObjectPropertyDifference reverse = new DbObjectPropertyDifference(this.getPropertyName(), this.getTargetParent(), this.getTarget(), this.getOriginalParent(), this.getOriginal(), this.getEqualsHandler(), false);
        return reverse;
    }

    @Override
    protected void diff() {
    }

    @Override
    protected void toString(ToStringBuilder builder) {
        if (this.getState() != State.Modified) {
            return;
        }
        if (this.getOriginal() instanceof List) {
            this.buildDiff(builder, (List)this.getOriginal(), (List)this.getTarget());
        } else if (this.getOriginal() instanceof DbInfo && this.getTarget() instanceof DbInfo) {
            this.buildDiff(builder, (DbInfo)this.getOriginal(), (DbInfo)this.getTarget());
        } else if (this.getOriginal() instanceof byte[] && this.getTarget() instanceof byte[]) {
            this.buildDiff(builder, (byte[])this.getOriginal(), (byte[])this.getTarget());
        } else if (this.getOriginalParent() instanceof Row && this.getTargetParent() instanceof Row && "values".equals(this.getPropertyName())) {
            this.buildDiffRowValue(builder, (Row)this.getOriginalParent(), (Row)this.getTargetParent());
        } else {
            this.buildDiff(builder, this.getOriginal(), this.getTarget());
        }
    }

    protected List<DbObjectPropertyDifference> toList() {
        List<DbObjectPropertyDifference> list = CommonUtils.list();
        if (this.getOriginal() instanceof DbInfo || this.getTarget() instanceof DbInfo) {
            DbInfo original = (DbInfo)this.getOriginal();
            DbInfo target = (DbInfo)this.getTarget();
            Map<String, DbInfo.DiffValue> diffValueMap = null;
            boolean reverse = false;
            if (original == null) {
                if (target == null) {
                    list.add(this);
                    return list;
                }
                diffValueMap = target.getDiffDbInfo(original);
                reverse = true;
            } else {
                diffValueMap = original.getDiffDbInfo(target);
            }
            for (Map.Entry<String, DbInfo.DiffValue> entry : diffValueMap.entrySet()) {
                DbInfo.DiffValue diffValue = entry.getValue();
                DbObjectPropertyDifference diff = new DbObjectPropertyDifference(entry.getKey(), this.getOriginalParent(), diffValue.getOriginal(), this.getTargetParent(), diffValue.getTarget(), true);
                if (reverse) {
                    diff.setState(diffValue.getState().reverse());
                } else {
                    diff.setState(diffValue.getState());
                }
                list.add(diff);
            }
        } else {
            list.add(this);
        }
        return list;
    }

    private void buildDiffRowValue(ToStringBuilder builder, Row val1, Row val2) {
        Row oRow1 = val1;
        Row oRow2 = val2;
        this.buildDiffForKeyMap(builder, oRow1.getValuesAsMapWithKey(), oRow2.getValuesAsMapWithKey());
    }

    private void buildDiff(ToStringBuilder builder, List val1, List val2) {
        String space = CommonUtils.getString("\t", this.getLevel());
        StringBuilder bld = new StringBuilder("(");
        Patch patch = DiffUtils.diff((List)val1, (List)val2);
        List list1 = val1;
        List list2 = val2;
        int size1 = list1.size();
        int size2 = list2.size();
        boolean isString = false;
        if (!CommonUtils.isEmpty(list1)) {
            for (Object obj : list1) {
                if (!(obj instanceof String)) continue;
                isString = true;
                break;
            }
        } else if (!CommonUtils.isEmpty(list2)) {
            for (Object obj : list2) {
                if (!(obj instanceof String)) continue;
                isString = true;
                break;
            }
        }
        int max = Math.max(size1, size2);
        for (Delta delta : patch.getDeltas()) {
            bld.append("\n");
            bld.append(space);
            if (isString) {
                bld.append(this.toTabString(DeltaUtils.toStringLineNumber(delta, max), space));
                continue;
            }
            bld.append(this.toTabString(DeltaUtils.toStringLine(delta), space));
        }
        bld.append("\n");
        bld.append(space);
        bld.append(")");
        builder.add(this.getPropertyName(), (Object)bld);
    }

    private void buildDiff(ToStringBuilder builder, String val1, String val2) {
        if (val1 != null && val2 != null) {
            List<String[]> txt1 = CommonUtils.list(val1.split("\n"));
            List<String[]> txt2 = CommonUtils.list(val2.split("\n"));
            this.buildDiff(builder, txt1, txt2);
        } else {
            this.buildDiff(builder, this.getOriginal(), this.getTarget());
        }
    }

    private void buildDiff(ToStringBuilder builder, Object val1, Object val2) {
        if (val1 != null && val2 != null && val1.getClass().isArray() && val2.getClass().isArray()) {
            this.buildDiffArray(builder, this.getOriginal(), this.getTarget());
        } else {
            builder.add(this.getPropertyName(), "(" + this.getOriginal() + " -> " + this.getTarget() + ")");
        }
    }

    private void buildDiff(ToStringBuilder builder, byte[] val1, byte[] val2) {
        if (this.getOriginalParent() instanceof AssemblyFile && this.getTargetParent() instanceof AssemblyFile) {
            AssemblyFile org = (AssemblyFile)this.getOriginalParent();
            AssemblyFile tgt = (AssemblyFile)this.getTargetParent();
            if (org.isSourceFile() && tgt.isSourceFile() && SchemaProperties.CONTENT.getLabel().equals(this.getPropertyName())) {
                try {
                    this.buildDiff(builder, org.getContentAsSource(), tgt.getContentAsSource());
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
                return;
            }
        }
        builder.add(this.getPropertyName() + ".length", "(" + this.length((byte[])this.getOriginal()) + " -> " + this.length((byte[])this.getTarget()) + ")");
    }

    private void buildDiffArray(ToStringBuilder builder, Object val1, Object val2) {
        final List list1 = CommonUtils.list();
        final List list2 = CommonUtils.list();
        AbstractIterator<Object> itr1 = new AbstractIterator<Object>(){

            @Override
            protected void handle(Object obj, int index) throws Exception {
                list1.add(obj);
            }
        };
        AbstractIterator<Object> itr2 = new AbstractIterator<Object>(){

            @Override
            protected void handle(Object obj, int index) throws Exception {
                list2.add(obj);
            }
        };
        try {
            itr1.execute(val1);
            itr2.execute(val2);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.buildDiff(builder, list1, list2);
    }

    private int length(byte[] bytes) {
        return bytes == null ? 0 : bytes.length;
    }

    private void buildDiff(ToStringBuilder builder, DbInfo map1, DbInfo map2) {
        StringBuilder bld = new StringBuilder("{");
        SeparatedStringBuilder sepChildBuilder = new SeparatedStringBuilder(", ");
        Set<String> props = CommonUtils.linkedSet();
        if (map1 != null) {
            props.addAll(map1.keySet());
        }
        if (map2 != null) {
            props.addAll(map2.keySet());
        }
        for (String prop : props) {
            String value1 = null;
            if (map1 != null) {
                value1 = map1.get(prop);
            }
            String value2 = null;
            if (map2 != null) {
                value2 = map2.get(prop);
            }
            if (CommonUtils.eq(value1, value2)) continue;
            sepChildBuilder.add((Object)(prop + "=(" + value1 + " -> " + value2 + ")"));
        }
        bld.append(sepChildBuilder.toString());
        if (bld.length() > 1) {
            bld.append("}");
            builder.add(this.getPropertyName(), (Object)bld);
        }
    }

    private void buildDiffForKeyMap(ToStringBuilder builder, Map<String, Object> map1, Map<String, Object> map2) {
        StringBuilder bld = new StringBuilder();
        if (!CommonUtils.eq(map1, map2)) {
            SeparatedStringBuilder sepChildBuilder = new SeparatedStringBuilder(", ");
            sepChildBuilder.setStart("[");
            sepChildBuilder.setEnd("]");
            Set<String> props = CommonUtils.linkedSet();
            props.addAll(map1.keySet());
            props.addAll(map2.keySet());
            for (String prop : props) {
                Object value2;
                Object value1 = map1.get(prop);
                if (!CommonUtils.eq(value1, value2 = map2.get(prop))) {
                    sepChildBuilder.add((Object)(prop + "=(" + value1 + " -> " + value2 + ")"));
                    continue;
                }
                if (!prop.endsWith("(PK)") && !prop.endsWith("(UK)")) continue;
                sepChildBuilder.add((Object)(prop + "=" + value1));
            }
            bld.append(sepChildBuilder.toString());
        }
        if (bld.length() > 1) {
            builder.add("C:" + this.getPropertyName(), (Object)bld);
        }
    }

    private String toTabString(String text, String space) {
        StringBuilder builder = new StringBuilder();
        String[] values = text.split("\n");
        for (int i = 0; i < values.length; ++i) {
            if (i > 0) {
                builder.append("\n");
                builder.append(space);
            }
            builder.append(values[i]);
        }
        return builder.toString();
    }

    @Override
    public int compareTo(Difference<?> o) {
        if (o instanceof DbObjectDifference) {
            return -1;
        }
        if (o instanceof DbObjectDifferenceCollection) {
            return -1;
        }
        DbObjectPropertyDifference dop = (DbObjectPropertyDifference)o;
        if (this.getOriginal() instanceof List || this.getTarget() instanceof List) {
            if (dop.getOriginal() instanceof List || dop.getTarget() instanceof List) {
                return 0;
            }
            return 1;
        }
        if (dop.getOriginal() instanceof List || dop.getTarget() instanceof List) {
            return -1;
        }
        return 0;
    }

    @Override
    public void removeRecursive(BiPredicate<String, Difference<?>> predicate) {
    }

    protected static class DifferenceEqualsHandler
    extends EqualsHandler {
        private DbObjectPropertyDifference dbObjectDifference = null;
        private final EqualsHandler equalsHandler;

        protected DifferenceEqualsHandler(DbObjectPropertyDifference dbObjectDifference, EqualsHandler equalsHandler) {
            this.dbObjectDifference = dbObjectDifference;
            this.equalsHandler = equalsHandler;
        }

        @Override
        protected boolean referenceEquals(Object object1, Object object2) {
            return this.equalsHandler.referenceEquals(object1, object2);
        }

        @Override
        protected boolean valueEquals(String propertyName, Object object1, Object object2, Object value1, Object value2, BooleanSupplier p) {
            boolean result = this.equalsHandler.valueEquals(propertyName, object1, object2, value1, value2, p);
            return this.equalsInternal(propertyName, result, object1, object2, value1, value2);
        }

        protected boolean equalsInternal(String propertyName, boolean result, Object object1, Object object2, Object value1, Object value2) {
            DbObjectPropertyDifference diff = new DbObjectPropertyDifference(propertyName, (DbCommonObject)object1, value1, (DbCommonObject)object2, value2, this.equalsHandler, result);
            diff.setParentDifference(this.dbObjectDifference);
            if (result) {
                diff.setState(State.Unchanged);
            } else {
                diff.setState(State.Modified);
            }
            return true;
        }

        @Override
        protected boolean equalsResult(Object object1, Object object2) {
            return this.equalsHandler.equalsResult(object1, object2);
        }

        @Override
        public DifferenceEqualsHandler clone() {
            return (DifferenceEqualsHandler)super.clone();
        }
    }
}

