/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.EnumProperties;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum Deferrability implements EnumProperties
{
    NotDeferrable(7, "NOT[\\s]*DEFERRABLE", "NOT DEFERRABLE"){

        @Override
        public String getAbbrName() {
            return "NOT DEF";
        }
    }
    ,
    InitiallyDeferred(5, "INITIALLY[\\s]*DEFERR.*", "INITIALLY DEFERRED"){

        @Override
        public String getAbbrName() {
            return "INIT DEF";
        }
    }
    ,
    InitiallyImmediate(6, "INITIALLY[\\s]*IMMEDIATE", "INITIALLY IMMEDIATE"){

        @Override
        public String getAbbrName() {
            return "INIT IMMED";
        }
    };

    private final int value;
    private final String text;
    private final Pattern textPattern;

    private Deferrability(int value, String pattern, String text) {
        this.value = value;
        this.text = text;
        this.textPattern = Pattern.compile(pattern, 2);
    }

    public static Deferrability parse(int value) {
        for (Deferrability enm : Deferrability.values()) {
            if (enm.value != value) continue;
            return enm;
        }
        return null;
    }

    public static Deferrability parse(String text) {
        if (text == null) {
            return null;
        }
        for (Deferrability enm : Deferrability.values()) {
            Matcher matcher = enm.textPattern.matcher(text);
            if (!matcher.matches()) continue;
            return enm;
        }
        return null;
    }

    public static Deferrability getDeferrability(boolean isDeferrable, boolean initiallyDeferred) {
        if (isDeferrable) {
            if (initiallyDeferred) {
                return InitiallyDeferred;
            }
            return InitiallyImmediate;
        }
        return NotDeferrable;
    }

    @Override
    public String getDisplayName() {
        return this.text;
    }

    public String getAbbrName() {
        return this.getDisplayName();
    }

    @Override
    public String getDisplayName(Locale locale) {
        return this.text;
    }

    @Override
    public String getSqlValue() {
        return this.text;
    }
}

