/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.AbstractSchemaObject;
import com.sqlapp.data.schemas.DimensionAttributeCollection;
import com.sqlapp.data.schemas.DimensionCollection;
import com.sqlapp.data.schemas.DimensionHierarchyCollection;
import com.sqlapp.data.schemas.DimensionLevel;
import com.sqlapp.data.schemas.DimensionLevelCollection;
import com.sqlapp.data.schemas.EqualsHandler;
import com.sqlapp.data.schemas.HasParent;
import com.sqlapp.data.schemas.SchemaObjectProperties;
import com.sqlapp.data.schemas.properties.ISchemaProperty;
import com.sqlapp.data.schemas.properties.object.DimensionAttributesProperty;
import com.sqlapp.data.schemas.properties.object.DimensionHierarchiesProperty;
import com.sqlapp.data.schemas.properties.object.DimensionLevelsProperty;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.StaxWriter;
import com.sqlapp.util.ToStringBuilder;
import java.util.function.Supplier;
import javax.xml.stream.XMLStreamException;

public final class Dimension
extends AbstractSchemaObject<Dimension>
implements HasParent<DimensionCollection>,
DimensionLevelsProperty<Dimension>,
DimensionHierarchiesProperty<Dimension>,
DimensionAttributesProperty<Dimension> {
    private static final long serialVersionUID = 1L;
    private DimensionLevelCollection levels = new DimensionLevelCollection(this);
    private DimensionHierarchyCollection hierarchies = new DimensionHierarchyCollection(this);
    private DimensionAttributeCollection attributes = new DimensionAttributeCollection(this);

    protected Dimension() {
    }

    public Dimension(String name) {
        super(name);
    }

    @Override
    protected Supplier<Dimension> newInstance() {
        return () -> new Dimension();
    }

    public DimensionLevel newLevel(String name) {
        DimensionLevel level = new DimensionLevel(name);
        level.setParent(this.levels);
        return level;
    }

    @Override
    public boolean equals(Object obj, EqualsHandler equalsHandler) {
        if (!(obj instanceof Dimension)) {
            return false;
        }
        if (!super.equals(obj, equalsHandler)) {
            return false;
        }
        Dimension val = (Dimension)obj;
        if (!this.equals(SchemaObjectProperties.DIMENSION_LEVELS, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaObjectProperties.DIMENSION_HIERARCHIES, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaObjectProperties.DIMENSION_ATTRIBUTES, val, equalsHandler)) {
            return false;
        }
        return equalsHandler.equalsResult(this, obj);
    }

    @Override
    public DimensionCollection getParent() {
        return (DimensionCollection)super.getParent();
    }

    @Override
    protected void toStringDetail(ToStringBuilder builder) {
        if (!CommonUtils.isEmpty(this.getLevels())) {
            builder.add((ISchemaProperty)SchemaObjectProperties.DIMENSION_LEVELS, (Object)this.getLevels());
        }
        if (!CommonUtils.isEmpty(this.getHierarchies())) {
            builder.add((ISchemaProperty)SchemaObjectProperties.DIMENSION_HIERARCHIES, (Object)this.getHierarchies());
        }
        if (!CommonUtils.isEmpty(this.getAttributes())) {
            builder.add((ISchemaProperty)SchemaObjectProperties.DIMENSION_ATTRIBUTES, (Object)this.getAttributes());
        }
    }

    @Override
    public DimensionLevelCollection getLevels() {
        return this.levels;
    }

    @Override
    public DimensionHierarchyCollection getHierarchies() {
        return this.hierarchies;
    }

    @Override
    public DimensionAttributeCollection getAttributes() {
        return this.attributes;
    }

    @Override
    protected void writeXmlOptionalAttributes(StaxWriter stax) throws XMLStreamException {
        super.writeXmlOptionalAttributes(stax);
    }

    @Override
    protected void writeXmlOptionalValues(StaxWriter stax) throws XMLStreamException {
        if (!CommonUtils.isEmpty(this.getLevels())) {
            this.getLevels().writeXml(stax);
        }
        if (!CommonUtils.isEmpty(this.getHierarchies())) {
            this.getHierarchies().writeXml(stax);
        }
        if (!CommonUtils.isEmpty(this.getAttributes())) {
            this.getAttributes().writeXml(stax);
        }
        super.writeXmlOptionalValues(stax);
    }

    protected Dimension setLevels(DimensionLevelCollection levels) {
        this.levels = levels;
        if (levels != null) {
            levels.setParent(this);
        }
        return (Dimension)this.instance();
    }

    protected Dimension setHierarchies(DimensionHierarchyCollection hierarchies) {
        this.hierarchies = hierarchies;
        if (hierarchies != null) {
            hierarchies.setParent(this);
        }
        return (Dimension)this.instance();
    }

    protected Dimension setAttributes(DimensionAttributeCollection attributes) {
        this.attributes = attributes;
        if (attributes != null) {
            attributes.setParent(this);
        }
        return (Dimension)this.instance();
    }

    @Override
    protected void validate() {
        this.levels.validate();
        this.hierarchies.validate();
        this.attributes.validate();
    }
}

