/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.AbstractNamedObject;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.DummyColumnCollection;
import com.sqlapp.data.schemas.DummyColumnXmlReaderHandler;
import com.sqlapp.data.schemas.EqualsHandler;
import com.sqlapp.data.schemas.ExcludeFilterEqualsHandler;
import com.sqlapp.data.schemas.HasParent;
import com.sqlapp.data.schemas.IncludeFilterEqualsHandler;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.SchemaUtils;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.data.schemas.properties.ISchemaProperty;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.StaxWriter;
import com.sqlapp.util.ToStringBuilder;
import java.util.function.Supplier;
import javax.xml.stream.XMLStreamException;

final class DummyColumn
extends AbstractNamedObject<DummyColumn>
implements HasParent<DummyColumnCollection> {
    private static final long serialVersionUID = 7183150115593442021L;

    protected DummyColumn() {
    }

    protected DummyColumn(String columnName) {
        super(columnName);
    }

    @Override
    protected Supplier<DummyColumn> newInstance() {
        return () -> new DummyColumn();
    }

    @Override
    protected String getSimpleName() {
        return "column";
    }

    @Override
    public boolean equals(Object obj, EqualsHandler equalsHandler) {
        if (!super.equals(obj, equalsHandler)) {
            return false;
        }
        if (!(obj instanceof DummyColumn)) {
            return false;
        }
        return equalsHandler.equalsResult(this, obj);
    }

    protected DummyColumn setColumns(DummyColumnCollection columns) {
        this.setParent(columns);
        return this;
    }

    public Table getTable() {
        return this.getAncestor(Table.class);
    }

    @Override
    public DummyColumnCollection getParent() {
        return (DummyColumnCollection)super.getParent();
    }

    @Override
    public String toStringSimple() {
        ToStringBuilder builder = new ToStringBuilder(this.getSimpleName());
        if (this.getParent() == null) {
            builder.add((ISchemaProperty)SchemaProperties.CATALOG_NAME, this.getCatalogName());
        }
        builder.add(SchemaProperties.NAME.getLabel(), this.getName());
        return builder.toString();
    }

    @Override
    public String getCatalogName() {
        Table table = this.getTable();
        if (table != null) {
            return table.getCatalogName();
        }
        return super.getCatalogName();
    }

    @Override
    protected void writeXmlOptionalAttributes(StaxWriter stax) throws XMLStreamException {
        super.writeXmlOptionalAttributes(stax);
    }

    @Override
    protected void writeXmlOptionalValues(StaxWriter stax) throws XMLStreamException {
        super.writeXmlOptionalValues(stax);
    }

    @Override
    protected DummyColumnXmlReaderHandler getDbObjectXmlReaderHandler() {
        return new DummyColumnXmlReaderHandler();
    }

    protected Column toColumn() {
        Column column = new Column();
        SchemaUtils.copySchemaProperties(this, column);
        return column;
    }

    public boolean isForeignKey() {
        if (this.getTable() == null) {
            return false;
        }
        return false;
    }

    @Override
    public boolean like(Object obj) {
        if (this.equals(obj, IncludeFilterEqualsHandler.EQUALS_NAME_HANDLER)) {
            return true;
        }
        if (!this.equals(obj, ExcludeFilterEqualsHandler.EQUALS_WITHOUT_NAME_HANDLER)) {
            return false;
        }
        DummyColumn column = (DummyColumn)obj;
        if (this.getOrdinal() != column.getOrdinal()) {
            return false;
        }
        if (this.getParent() == null || column.getParent() == null) {
            return true;
        }
        DummyColumn eqName = (DummyColumn)column.getParent().get(this.getName());
        if (eqName != null) {
            return false;
        }
        eqName = (DummyColumn)this.getParent().get(column.getName());
        return eqName == null;
    }

    @Override
    public DummyColumn setName(String name) {
        String origianlName = this.getName();
        if (CommonUtils.eq(name, origianlName)) {
            return (DummyColumn)this.instance();
        }
        super.setName(name);
        return (DummyColumn)this.instance();
    }

    @Override
    protected void toStringDetail(ToStringBuilder builder) {
    }
}

