/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.DbCommonObject;
import java.util.function.BiPredicate;
import java.util.function.BooleanSupplier;

public class EqualsHandler
implements Cloneable {
    private static final EqualsHandler instance = new EqualsHandler();
    private BiPredicate<Object, Object> referenceEqualsPredicate = (object1, object2) -> {
        if (object1 == object2) {
            return true;
        }
        if (object2 == null) {
            return false;
        }
        return false;
    };
    private EqualsPredicate valueEqualsPredicate = (propertyName, eq, object1, object2, value1, value2) -> eq;
    private BiPredicate<Object, Object> equalsLastPredicate = (object1, object2) -> true;

    public static EqualsHandler getInstance() {
        return instance;
    }

    public BiPredicate<Object, Object> getReferenceEqualsPredicate() {
        return this.referenceEqualsPredicate;
    }

    public void setReferenceEqualsPredicate(BiPredicate<Object, Object> referenceEqualsPredicate) {
        this.referenceEqualsPredicate = referenceEqualsPredicate;
    }

    public EqualsPredicate getValueEqualsPredicate() {
        return this.valueEqualsPredicate;
    }

    public void setValueEqualsPredicate(EqualsPredicate valueEqualsPredicate) {
        this.valueEqualsPredicate = valueEqualsPredicate;
    }

    public BiPredicate<Object, Object> getEqualsLastPredicate() {
        return this.equalsLastPredicate;
    }

    public void setEqualsLastPredicate(BiPredicate<Object, Object> equalsLastPredicate) {
        this.equalsLastPredicate = equalsLastPredicate;
    }

    protected boolean referenceEquals(Object object1, Object object2) {
        return this.getReferenceEqualsPredicate().test(object1, object2);
    }

    protected boolean valueEquals(String propertyName, Object object1, Object object2, Object value1, Object value2, BooleanSupplier p) {
        if (value1 instanceof DbCommonObject) {
            return ((DbCommonObject)value1).equals(value2, this);
        }
        return this.getValueEqualsPredicate().contextEquals(propertyName, p.getAsBoolean(), object1, object2, value1, value2);
    }

    protected boolean equalsResult(Object object1, Object object2) {
        return this.getEqualsLastPredicate().test(object1, object2);
    }

    public EqualsHandler clone() {
        try {
            EqualsHandler clone = (EqualsHandler)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @FunctionalInterface
    public static interface EqualsPredicate {
        public boolean contextEquals(String var1, boolean var2, Object var3, Object var4, Object var5, Object var6);
    }
}

