/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.Constraint;
import com.sqlapp.data.schemas.ConstraintCollection;
import com.sqlapp.data.schemas.Deferrability;
import com.sqlapp.data.schemas.EqualsHandler;
import com.sqlapp.data.schemas.Index;
import com.sqlapp.data.schemas.IndexType;
import com.sqlapp.data.schemas.ReferenceColumn;
import com.sqlapp.data.schemas.ReferenceColumnCollection;
import com.sqlapp.data.schemas.SchemaObjectProperties;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.data.schemas.properties.ISchemaProperty;
import com.sqlapp.data.schemas.properties.IndexTypeProperty;
import com.sqlapp.data.schemas.properties.complex.IndexProperty;
import com.sqlapp.data.schemas.properties.object.ReferenceColumnsProperty;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.StaxWriter;
import com.sqlapp.util.ToStringBuilder;
import java.util.function.Supplier;
import javax.xml.stream.XMLStreamException;

public final class ExcludeConstraint
extends Constraint
implements IndexTypeProperty<ExcludeConstraint>,
IndexProperty<ExcludeConstraint>,
ReferenceColumnsProperty<ExcludeConstraint> {
    private static final long serialVersionUID = 1L;
    private Index index = new Index();

    public ExcludeConstraint() {
    }

    public ExcludeConstraint(String name) {
        super(name);
    }

    @Override
    protected Supplier<Constraint> newInstance() {
        return () -> new ExcludeConstraint();
    }

    public ExcludeConstraint(String constraintName, Column column) {
        super(constraintName);
        this.getColumns().add(new ReferenceColumn(column));
    }

    public ExcludeConstraint(String constraintName, Column ... columns) {
        super(constraintName);
        for (Column column : columns) {
            this.getColumns().add(new ReferenceColumn(column));
        }
    }

    public ExcludeConstraint addColumn(String columnName) {
        if (!this.getColumns().contains(columnName)) {
            this.getColumns().add(columnName);
        }
        return this;
    }

    public ExcludeConstraint addColumn(String columnName, String with) {
        if (!this.getColumns().contains(columnName)) {
            this.getColumns().add(columnName);
        }
        this.getColumns().get(columnName).setWith(with);
        return this;
    }

    @Override
    protected void toStringDetail(ToStringBuilder builder) {
        if (this.getColumns().size() > 0) {
            builder.add((ISchemaProperty)SchemaObjectProperties.REFERENCE_COLUMNS, this.getColumns().toStringSimple());
        }
        builder.add((ISchemaProperty)SchemaProperties.INDEX_TYPE, (Object)this.getIndexType());
        super.toStringDetail(builder);
    }

    @Override
    public ReferenceColumnCollection getColumns() {
        return this.index.getColumns();
    }

    protected ExcludeConstraint setColumns(ReferenceColumnCollection columns) {
        if (columns != null && this.getParent() != null) {
            ConstraintCollection cc = this.getParent();
            columns.setTable(cc.getTable());
        }
        this.index.setColumns(columns);
        return this.instance();
    }

    public static boolean eqColumnNames(ReferenceColumnCollection columns, ReferenceColumnCollection targetColumns) {
        if (columns.size() != targetColumns.size()) {
            return false;
        }
        int size = columns.size();
        for (int i = 0; i < size; ++i) {
            if (CommonUtils.eqIgnoreCase(((ReferenceColumn)columns.get(i)).getName(), ((ReferenceColumn)targetColumns.get(i)).getName())) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void writeXmlOptionalAttributes(StaxWriter stax) throws XMLStreamException {
        super.writeXmlOptionalAttributes(stax);
        if (this.getIndexName() != null && !CommonUtils.eqIgnoreCase(this.getName(), this.getIndexName())) {
            stax.writeAttribute(SchemaProperties.INDEX_NAME.getLabel(), this.getIndexName());
        }
        stax.writeAttribute(SchemaProperties.INDEX_TYPE.getLabel(), (Object)this.getIndexType());
    }

    @Override
    protected void writeXmlOptionalValues(StaxWriter stax) throws XMLStreamException {
        super.writeXmlOptionalValues(stax);
        if (!CommonUtils.isEmpty(this.getColumns())) {
            this.getColumns().writeXml(stax);
        }
    }

    @Override
    public boolean equals(Object obj, EqualsHandler equalsHandler) {
        if (!(obj instanceof ExcludeConstraint)) {
            return false;
        }
        if (!super.equals(obj, equalsHandler)) {
            return false;
        }
        ExcludeConstraint val = (ExcludeConstraint)obj;
        if (!this.equals(SchemaObjectProperties.REFERENCE_COLUMNS, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.INDEX_TYPE, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.INDEX_NAME, val, equalsHandler)) {
            return false;
        }
        return equalsHandler.equalsResult(this, obj);
    }

    @Override
    public ExcludeConstraint clone() {
        ExcludeConstraint clone = new ExcludeConstraint(this.getName());
        this.cloneProperties(clone);
        return clone;
    }

    @Override
    protected void cloneProperties(ExcludeConstraint clone) {
        super.cloneProperties(clone);
    }

    public Table getTable() {
        if (this.getParent() != null) {
            return this.getParent().getTable();
        }
        return null;
    }

    @Override
    public String getTableName() {
        ConstraintCollection constraintc;
        if (this.getParent() != null && (constraintc = (ConstraintCollection)CommonUtils.cast(this.getParent())).getTable() != null) {
            return constraintc.getTable().getName();
        }
        return super.getTableName();
    }

    @Override
    public IndexType getIndexType() {
        if (this.getIndex() != null) {
            return this.getIndex().getIndexType();
        }
        return null;
    }

    @Override
    public ExcludeConstraint setIndexType(IndexType indexType) {
        this.getIndex().setIndexType(indexType);
        return this;
    }

    @Override
    public boolean like(Object obj) {
        if (!(obj instanceof ExcludeConstraint)) {
            return false;
        }
        ExcludeConstraint con = (ExcludeConstraint)obj;
        if (!CommonUtils.eq(this.getName(), con.getName()) && this.getParent() != null && con.getParent() != null && (this.getParent().contains(con.getName()) || con.getParent().contains(this.getName()))) {
            return false;
        }
        return CommonUtils.eq(this.getColumns(), con.getColumns());
    }

    @Override
    public String toStringSimple() {
        ToStringBuilder builder = new ToStringBuilder(this.getSimpleName());
        if (this.getParent() == null) {
            builder.add(SchemaProperties.CATALOG_NAME.getLabel(), this.getCatalogName());
            builder.add(SchemaProperties.SCHEMA_NAME.getLabel(), this.getSchemaName());
        }
        builder.add(SchemaProperties.NAME.getLabel(), this.getName());
        builder.add(SchemaObjectProperties.REFERENCE_COLUMNS.getLabel(), this.getColumns().toStringSimple());
        return builder.toString();
    }

    @Override
    protected ExcludeConstraint instance() {
        return this;
    }

    @Override
    public ExcludeConstraint setEnable(boolean bool) {
        super.setEnable(bool);
        return this.instance();
    }

    @Override
    public ExcludeConstraint setDeferrability(Deferrability deferrability) {
        super.setDeferrability(deferrability);
        return this.instance();
    }

    @Override
    public ExcludeConstraint setDeferrability(String deferrability) {
        super.setDeferrability(deferrability);
        return this.instance();
    }
}

