/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.AbstractDbObject;
import com.sqlapp.data.schemas.EqualsHandler;
import com.sqlapp.data.schemas.Function;
import com.sqlapp.data.schemas.FunctionFamilyCollection;
import com.sqlapp.data.schemas.HasParent;
import com.sqlapp.data.schemas.IncludeFilterEqualsHandler;
import com.sqlapp.data.schemas.OperatorClass;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.properties.ISchemaProperty;
import com.sqlapp.data.schemas.properties.OperatorClassNameProperty;
import com.sqlapp.data.schemas.properties.SchemaNameProperty;
import com.sqlapp.data.schemas.properties.SupportNumberProperty;
import com.sqlapp.data.schemas.properties.complex.FunctionProperty;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.StaxWriter;
import com.sqlapp.util.ToStringBuilder;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;

public class FunctionFamily
extends AbstractDbObject<FunctionFamily>
implements HasParent<FunctionFamilyCollection>,
FunctionProperty<FunctionFamily>,
SchemaNameProperty<FunctionFamily>,
OperatorClassNameProperty<FunctionFamily>,
SupportNumberProperty<FunctionFamily> {
    private static final long serialVersionUID = -5692492571670996675L;
    private String schemaName = null;
    private String operatorClassName = null;
    private int supportNumber = 0;
    private Function function = null;
    private static final Pattern FUNCTION_NAME_PATTERN = Pattern.compile("([^(]+)(\\(.*\\)){0,1}");
    private static final EqualsHandler LIKE_EQUALS_HANDLER = new IncludeFilterEqualsHandler(SchemaProperties.FUNCTION_NAME.getLabel());

    @Override
    protected Supplier<FunctionFamily> newInstance() {
        return () -> new FunctionFamily();
    }

    @Override
    public FunctionFamily setOperatorClassName(String operatorClassName) {
        this.operatorClassName = operatorClassName;
        return this;
    }

    @Override
    public FunctionFamily setFunctionName(String functionName) {
        if (CommonUtils.isEmpty(functionName)) {
            this.function = null;
            return this;
        }
        Matcher mathcer = FUNCTION_NAME_PATTERN.matcher(functionName);
        if (mathcer.matches()) {
            this.setFunction(new Function(mathcer.group(1)));
            this.getFunction().setSpecificName(functionName);
        }
        return this;
    }

    @Override
    protected void writeXmlOptionalAttributes(StaxWriter stax) throws XMLStreamException {
        super.writeXmlOptionalAttributes(stax);
        stax.writeAttribute(SchemaProperties.SUPPORT_NUMBER.getLabel(), (Object)this.getSupportNumber());
        if (this.getFunction() != null && !CommonUtils.eq(this.getSchemaName(), this.getFunction().getSchemaName())) {
            stax.writeAttribute(SchemaProperties.FUNCTION_SCHEMA_NAME.getLabel(), this.getFunctionSchemaName());
        }
        stax.writeAttribute(SchemaProperties.FUNCTION_NAME.getLabel(), this.getFunctionName());
    }

    @Override
    protected void toString(ToStringBuilder builder) {
        super.toString(builder);
        builder.add((ISchemaProperty)SchemaProperties.SUPPORT_NUMBER, (Object)this.getSupportNumber());
        if (!CommonUtils.isEmpty(this.getFunctionName())) {
            builder.add((ISchemaProperty)SchemaProperties.FUNCTION_NAME, this.getFunctionName());
        }
    }

    @Override
    public boolean equals(Object obj, EqualsHandler equalsHandler) {
        if (!super.equals(obj, equalsHandler)) {
            return false;
        }
        if (!(obj instanceof FunctionFamily)) {
            return false;
        }
        FunctionFamily val = (FunctionFamily)obj;
        if (!this.equals(SchemaProperties.SUPPORT_NUMBER, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.FUNCTION_SCHEMA_NAME, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.FUNCTION_NAME, val, equalsHandler)) {
            return false;
        }
        return equalsHandler.equalsResult(this, obj);
    }

    @Override
    public FunctionFamilyCollection getParent() {
        return (FunctionFamilyCollection)super.getParent();
    }

    @Override
    public String getFunctionName() {
        if (this.getFunction() != null) {
            return this.getFunction().getSpecificName();
        }
        return null;
    }

    @Override
    public String getSchemaName() {
        OperatorClass parent = this.getAncestor(OperatorClass.class);
        if (parent != null) {
            return parent.getSchemaName();
        }
        return this.schemaName;
    }

    @Override
    public FunctionFamily setSchemaName(String schemaName) {
        this.schemaName = schemaName;
        return (FunctionFamily)this.instance();
    }

    @Override
    public String getOperatorClassName() {
        OperatorClass parent = this.getAncestor(OperatorClass.class);
        if (parent != null) {
            return parent.getName();
        }
        return this.operatorClassName;
    }

    @Override
    public int getSupportNumber() {
        return this.supportNumber;
    }

    @Override
    public FunctionFamily setSupportNumber(int supportNumber) {
        this.supportNumber = supportNumber;
        return (FunctionFamily)this.instance();
    }

    @Override
    public int compareTo(FunctionFamily o) {
        if (this.getSupportNumber() > o.getSupportNumber()) {
            return 1;
        }
        if (this.getSupportNumber() < o.getSupportNumber()) {
            return -1;
        }
        return 0;
    }

    @Override
    public boolean like(Object obj) {
        if (!super.like(obj)) {
            return false;
        }
        return this.equals(obj, LIKE_EQUALS_HANDLER);
    }
}

