/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.AbstractSchemaObject;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.EqualsHandler;
import com.sqlapp.data.schemas.HasParent;
import com.sqlapp.data.schemas.IndexCollection;
import com.sqlapp.data.schemas.IndexType;
import com.sqlapp.data.schemas.Partitioning;
import com.sqlapp.data.schemas.ReferenceColumnCollection;
import com.sqlapp.data.schemas.SchemaObjectProperties;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.data.schemas.TableSpace;
import com.sqlapp.data.schemas.properties.CompressionProperty;
import com.sqlapp.data.schemas.properties.CompressionTypeProperty;
import com.sqlapp.data.schemas.properties.EnableProperty;
import com.sqlapp.data.schemas.properties.ISchemaProperty;
import com.sqlapp.data.schemas.properties.IncludeColumnsProperty;
import com.sqlapp.data.schemas.properties.IndexTypeProperty;
import com.sqlapp.data.schemas.properties.PartitioningProperty;
import com.sqlapp.data.schemas.properties.TableNameProperty;
import com.sqlapp.data.schemas.properties.UniqueProperty;
import com.sqlapp.data.schemas.properties.WhereProperty;
import com.sqlapp.data.schemas.properties.complex.TableSpaceProperty;
import com.sqlapp.data.schemas.properties.object.ReferenceColumnsProperty;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.StaxWriter;
import com.sqlapp.util.ToStringBuilder;
import java.util.function.Supplier;
import javax.xml.stream.XMLStreamException;

public final class Index
extends AbstractSchemaObject<Index>
implements HasParent<IndexCollection>,
TableNameProperty<Index>,
UniqueProperty<Index>,
EnableProperty<Index>,
ReferenceColumnsProperty<Index>,
IncludeColumnsProperty<Index>,
CompressionProperty<Index>,
CompressionTypeProperty<Index>,
IndexTypeProperty<Index>,
PartitioningProperty<Index>,
WhereProperty<Index>,
TableSpaceProperty<Index> {
    private static final long serialVersionUID = 259457460807208400L;
    private boolean unique = (Boolean)SchemaProperties.UNIQUE.getDefaultValue();
    private IndexType indexType = null;
    private boolean compression = (Boolean)SchemaProperties.COMPRESSION.getDefaultValue();
    private String compressionType = null;
    private ReferenceColumnCollection columns = new ReferenceColumnCollection(this);
    private ReferenceColumnCollection includes = new ReferenceColumnCollection(this);
    private Partitioning partitioning = null;
    private String where = null;
    private String tableName = null;
    private final TableSpace tableSpace = null;
    private boolean enable = (Boolean)SchemaProperties.ENABLE.getDefaultValue();

    protected Index() {
    }

    @Override
    protected Supplier<Index> newInstance() {
        return () -> new Index();
    }

    public Index(String indexName) {
        super(indexName);
    }

    public Index(String indexName, Column ... columns) {
        super(indexName);
        this.columns.addAll(columns);
    }

    @Override
    public boolean isEnable() {
        return this.enable;
    }

    @Override
    public Index setEnable(boolean enable) {
        this.enable = enable;
        return (Index)this.instance();
    }

    @Override
    public boolean isUnique() {
        return this.unique;
    }

    @Override
    public Index setUnique(boolean unique) {
        this.unique = unique;
        return this;
    }

    @Override
    public IndexType getIndexType() {
        return this.indexType;
    }

    @Override
    public Index setIndexType(IndexType indexType) {
        this.indexType = indexType;
        return this;
    }

    public final Table getTable() {
        if (this.getParent() == null) {
            return null;
        }
        return this.getParent().getParent();
    }

    @Override
    public boolean equals(Object obj, EqualsHandler equalsHandler) {
        if (!(obj instanceof Index)) {
            return false;
        }
        if (!super.equals(obj, equalsHandler)) {
            return false;
        }
        Index val = (Index)obj;
        if (!this.equals(SchemaProperties.UNIQUE, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.INDEX_TYPE, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaObjectProperties.REFERENCE_COLUMNS, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaObjectProperties.INCLUDED_COLUMNS, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.WHERE, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.ENABLE, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.COMPRESSION, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.COMPRESSION_TYPE, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaObjectProperties.PARTITIONING, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.TABLE_SPACE_NAME, val, equalsHandler)) {
            return false;
        }
        return equalsHandler.equalsResult(this, obj);
    }

    @Override
    public String toStringSimple() {
        ToStringBuilder builder = new ToStringBuilder(this.getSimpleName());
        if (this.getParent() == null) {
            builder.add(SchemaProperties.CATALOG_NAME.getLabel(), this.getCatalogName());
            builder.add(SchemaProperties.SCHEMA_NAME.getLabel(), this.getSchemaName());
            builder.add((ISchemaProperty)SchemaProperties.TABLE_NAME, this.getTableName());
        }
        builder.add((ISchemaProperty)SchemaProperties.NAME, this.getName());
        builder.add((ISchemaProperty)SchemaObjectProperties.REFERENCE_COLUMNS, this.getColumns().toStringSimple());
        return builder.toString();
    }

    @Override
    protected void toStringDetail(ToStringBuilder builder) {
        builder.add((ISchemaProperty)SchemaProperties.UNIQUE, (Object)this.isUnique());
        builder.add((ISchemaProperty)SchemaProperties.INDEX_TYPE, (Object)this.getIndexType());
        if (!CommonUtils.isEmpty(this.getColumns())) {
            builder.add((ISchemaProperty)SchemaObjectProperties.REFERENCE_COLUMNS, this.getColumns().toStringSimple());
        }
        if (!CommonUtils.isEmpty(this.getIncludes())) {
            builder.add((ISchemaProperty)SchemaObjectProperties.INCLUDED_COLUMNS, this.getIncludes().toStringSimple());
        }
        builder.add((ISchemaProperty)SchemaProperties.WHERE, this.getWhere());
        builder.add((ISchemaProperty)SchemaProperties.ENABLE, (Object)this.isEnable());
        builder.add((ISchemaProperty)SchemaProperties.COMPRESSION, (Object)this.isCompression());
        builder.add((ISchemaProperty)SchemaProperties.COMPRESSION_TYPE, this.getCompressionType());
        builder.add((ISchemaProperty)SchemaProperties.TABLE_SPACE_NAME, this.getTableSpaceName());
        builder.add((ISchemaProperty)SchemaObjectProperties.PARTITIONING, (Object)this.getPartitioning());
    }

    @Override
    public ReferenceColumnCollection getColumns() {
        return this.columns;
    }

    protected Index setColumns(ReferenceColumnCollection columns) {
        if (columns != null) {
            columns.setParent(this);
        }
        this.columns = columns;
        return (Index)this.instance();
    }

    @Override
    public ReferenceColumnCollection getIncludes() {
        return this.includes;
    }

    protected Index setIncludes(ReferenceColumnCollection includes) {
        if (includes != null) {
            includes.setParent(this);
        }
        this.includes = includes;
        return (Index)this.instance();
    }

    @Override
    public String getCatalogName() {
        IndexCollection indexes;
        if (this.getParent() != null && (indexes = (IndexCollection)CommonUtils.cast(this.getParent())).getParent() != null) {
            return CommonUtils.coalesce(indexes.getParent().getCatalogName(), super.getCatalogName());
        }
        return super.getCatalogName();
    }

    @Override
    public String getSchemaName() {
        IndexCollection indexes;
        if (this.getParent() != null && (indexes = (IndexCollection)CommonUtils.cast(this.getParent())).getParent() != null) {
            return CommonUtils.coalesce(indexes.getParent().getSchemaName(), this.schemaName);
        }
        return this.schemaName;
    }

    @Override
    public String getWhere() {
        return this.where;
    }

    @Override
    public Index setWhere(String where) {
        this.where = where;
        return (Index)this.instance();
    }

    @Override
    public boolean isCompression() {
        return this.compression;
    }

    @Override
    public Index setCompression(boolean compression) {
        this.compression = compression;
        return (Index)this.instance();
    }

    @Override
    public Index setCompressionType(String compressionType) {
        this.compressionType = compressionType;
        return (Index)this.instance();
    }

    @Override
    public String getCompressionType() {
        return this.compressionType;
    }

    @Override
    public Partitioning getPartitioning() {
        return this.partitioning;
    }

    @Override
    public Index setPartitioning(Partitioning partitioning) {
        if (this.partitioning != null) {
            this.partitioning.setIndex(null);
        }
        if (partitioning != null) {
            partitioning.setIndex(this);
        }
        this.partitioning = partitioning;
        return this;
    }

    @Override
    public IndexCollection getParent() {
        return (IndexCollection)super.getParent();
    }

    @Override
    protected void writeXmlOptionalAttributes(StaxWriter stax) throws XMLStreamException {
        super.writeXmlOptionalAttributes(stax);
        stax.writeAttribute(SchemaProperties.UNIQUE.getLabel(), (Object)this.isUnique());
        stax.writeAttribute(SchemaProperties.INDEX_TYPE.getLabel(), (Object)this.getIndexType());
        if (this.isCompression()) {
            stax.writeAttribute(SchemaProperties.COMPRESSION.getLabel(), (Object)this.isCompression());
            stax.writeAttribute(SchemaProperties.COMPRESSION_TYPE.getLabel(), this.getCompressionType());
        }
        stax.writeAttribute(SchemaProperties.WHERE.getLabel(), this.getWhere());
        stax.writeAttribute(SchemaProperties.TABLE_SPACE_NAME.getLabel(), this.getTableSpaceName());
        if (!this.isEnable()) {
            stax.writeAttribute(SchemaProperties.ENABLE.getLabel(), (Object)this.isEnable());
        }
    }

    @Override
    protected void writeXmlOptionalValues(StaxWriter stax) throws XMLStreamException {
        super.writeXmlOptionalValues(stax);
        if (!CommonUtils.isEmpty(this.columns)) {
            this.columns.writeXml(stax);
        }
        if (!CommonUtils.isEmpty(this.includes)) {
            this.includes.writeXml(SchemaObjectProperties.INCLUDED_COLUMNS.getLabel(), stax);
        }
        if (this.partitioning != null) {
            this.partitioning.writeXml(stax);
        }
    }

    @Override
    public String getTableName() {
        IndexCollection indexes;
        if (this.getParent() != null && (indexes = (IndexCollection)CommonUtils.cast(this.getParent())).getParent() != null) {
            return indexes.getParent().getName();
        }
        return this.tableName;
    }

    @Override
    public Index setTableName(String tableName) {
        this.tableName = tableName;
        return (Index)this.instance();
    }

    @Override
    public boolean like(Object obj) {
        if (!(obj instanceof Index)) {
            return false;
        }
        Index con = (Index)obj;
        if (!CommonUtils.eq(this.getName(), con.getName()) && this.getParent() != null && con.getParent() != null && (this.getParent().contains(con.getName()) || con.getParent().contains(this.getName()))) {
            return false;
        }
        if (!CommonUtils.eq(this.getTableName(), con.getTableName())) {
            return false;
        }
        return CommonUtils.eq(this.getColumns(), con.getColumns());
    }

    @Override
    protected void validate() {
        super.validate();
        this.setTableSpace(this.getTableSpaceFromParent(this.tableSpace));
    }
}

