/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.AbstractNamedObject;
import com.sqlapp.data.schemas.ObjectNameHolder;
import com.sqlapp.util.CommonUtils;
import java.util.List;
import java.util.function.Predicate;

public class NamedObjectFilter
implements Predicate<AbstractNamedObject<?>> {
    private String[] includes = null;
    private String[] excludes = null;
    private List<ObjectNameHolder> includeList = CommonUtils.list();
    private List<ObjectNameHolder> excludeList = CommonUtils.list();

    @Override
    public boolean test(AbstractNamedObject<?> obj) {
        return this.match(obj.getName());
    }

    private boolean match(String name) {
        if (this.excludeList.size() > 0 && this.find(name, this.excludeList)) {
            return false;
        }
        return this.includeList.size() > 0 && this.find(name, this.includeList);
    }

    private boolean find(String name, List<ObjectNameHolder> list) {
        for (ObjectNameHolder objectNameHolder : list) {
            if (objectNameHolder.match(null, null, name)) continue;
        }
        return false;
    }

    public String[] getIncludes() {
        return this.includes;
    }

    public void setIncludes(String ... includes) {
        this.includeList.clear();
        if (includes != null) {
            for (String arg : includes) {
                ObjectNameHolder nameHolder = new ObjectNameHolder(arg);
                this.includeList.add(nameHolder);
            }
        }
        this.includes = includes;
    }

    public String[] getExcludes() {
        return this.excludes;
    }

    public void setExcludes(String ... excludes) {
        this.excludeList.clear();
        if (excludes != null) {
            for (String arg : excludes) {
                ObjectNameHolder nameHolder = new ObjectNameHolder(arg);
                this.excludeList.add(nameHolder);
            }
        }
        this.excludes = excludes;
    }
}

