/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.ToStringBuilder;
import java.util.regex.Pattern;

public class ObjectNameHolder {
    private String objectName = null;
    private Pattern objectNamePattern = null;

    public ObjectNameHolder() {
    }

    public ObjectNameHolder(String name) {
        String[] splits = name.split("\\.");
        this.objectName = CommonUtils.last(splits);
    }

    public boolean match(String catalogName, String schemaName, String name) {
        return this.matchObjectName(name);
    }

    private boolean matchObjectName(String name) {
        if (this.objectNamePattern != null) {
            return this.objectNamePattern.matcher(name).matches();
        }
        return CommonUtils.eq(this.getObjectName(), name);
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setObjectName(String objectName) {
        this.objectNamePattern = objectName != null ? (objectName.contains("*") ? Pattern.compile(objectName.replace("*", ".*")) : null) : null;
        this.objectName = objectName;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder(this.getClass());
        builder.add("objectName", this.objectName);
        return builder.toString();
    }
}

