/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.db.datatype.DataType;
import com.sqlapp.data.schemas.AbstractDbObject;
import com.sqlapp.data.schemas.EqualsHandler;
import com.sqlapp.data.schemas.HasParent;
import com.sqlapp.data.schemas.Operator;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.properties.DataTypeProperties;
import com.sqlapp.data.schemas.properties.ISchemaProperty;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.StaxWriter;
import com.sqlapp.util.ToStringBuilder;
import java.util.function.Supplier;
import javax.xml.stream.XMLStreamException;

public class OperatorArgument
extends AbstractDbObject<OperatorArgument>
implements HasParent<Operator>,
DataTypeProperties<OperatorArgument> {
    private static final long serialVersionUID = 8186027542736225676L;
    private DataType dataType = null;
    private String dataTypeName = null;

    public OperatorArgument() {
    }

    public OperatorArgument(String dataTypeName) {
        this.setDataTypeName(dataTypeName);
    }

    @Override
    protected Supplier<OperatorArgument> newInstance() {
        return () -> new OperatorArgument();
    }

    @Override
    protected void writeXmlOptionalAttributes(StaxWriter stax) throws XMLStreamException {
        super.writeXmlOptionalAttributes(stax);
        stax.writeAttribute(SchemaProperties.DATA_TYPE.getLabel(), (Object)this.getDataType());
        stax.writeAttribute(SchemaProperties.DATA_TYPE_NAME.getLabel(), this.getDataTypeName());
    }

    @Override
    protected void toString(ToStringBuilder builder) {
        builder.add((ISchemaProperty)SchemaProperties.DATA_TYPE, (Object)this.getDataType());
        builder.add((ISchemaProperty)SchemaProperties.DATA_TYPE_NAME, this.getDataTypeName());
        super.toString(builder);
    }

    @Override
    public boolean equals(Object obj, EqualsHandler equalsHandler) {
        if (!super.equals(obj, equalsHandler)) {
            return false;
        }
        if (!(obj instanceof OperatorArgument)) {
            return false;
        }
        OperatorArgument val = (OperatorArgument)obj;
        if (!this.equals(SchemaProperties.DATA_TYPE_NAME, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.DATA_TYPE, val, equalsHandler)) {
            return false;
        }
        return equalsHandler.equalsResult(this, obj);
    }

    @Override
    public Operator getParent() {
        return (Operator)super.getParent();
    }

    @Override
    protected String getSimpleName() {
        if (this.getParent() != null) {
            if (this.getParent().getLeftArgument() == this) {
                return "leftArgument";
            }
            if (this.getParent().getRightArgument() == this) {
                return "rightArgument";
            }
        }
        return "argument";
    }

    @Override
    public int compareTo(OperatorArgument o) {
        return 0;
    }

    @Override
    public boolean like(Object obj) {
        if (!(obj instanceof OperatorArgument)) {
            return false;
        }
        OperatorArgument cst = (OperatorArgument)obj;
        return CommonUtils.eq(this.getOrdinal(), cst.getOrdinal());
    }

    @Override
    protected void validate() {
        this.setDataTypeName(this.getDataTypeName());
    }
}

