/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.converter.Converters;
import com.sqlapp.data.db.datatype.DataType;
import com.sqlapp.data.schemas.AbstractNamedObject;
import com.sqlapp.data.schemas.EqualsHandler;
import com.sqlapp.data.schemas.HasParent;
import com.sqlapp.data.schemas.PartitionFunctionCollection;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.properties.BoundaryValueOnRightProperty;
import com.sqlapp.data.schemas.properties.DataTypeLengthProperties;
import com.sqlapp.data.schemas.properties.ISchemaProperty;
import com.sqlapp.data.schemas.properties.PartitionFunctionValuesProperty;
import com.sqlapp.data.schemas.properties.PrecisionProperty;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.HashCodeBuilder;
import com.sqlapp.util.StaxWriter;
import com.sqlapp.util.ToStringBuilder;
import com.sqlapp.util.UniqueList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import java.util.function.Supplier;
import javax.xml.stream.XMLStreamException;

public final class PartitionFunction
extends AbstractNamedObject<PartitionFunction>
implements HasParent<PartitionFunctionCollection>,
DataTypeLengthProperties<PartitionFunction>,
PrecisionProperty<PartitionFunction>,
BoundaryValueOnRightProperty<PartitionFunction>,
PartitionFunctionValuesProperty<PartitionFunction> {
    private static final long serialVersionUID = 1L;
    private final DataType dataType = null;
    private final String dataTypeName;
    private boolean boundaryValueOnRight = (Boolean)SchemaProperties.BOUNDARY_VALUE_ON_RIGHT.getDefaultValue();
    private Long maxLength = (Long)SchemaProperties.LENGTH.getDefaultValue();
    private Long octetLength = (Long)SchemaProperties.OCTET_LENGTH.getDefaultValue();
    private Integer precision = (Integer)SchemaProperties.PRECISION.getDefaultValue();
    private Integer scale = (Integer)SchemaProperties.SCALE.getDefaultValue();
    private PatitionFunctionValues values = new PatitionFunctionValues(this);

    public PartitionFunction() {
        this.dataTypeName = null;
    }

    public PartitionFunction(String functrionName) {
        super(functrionName);
        this.dataTypeName = null;
    }

    @Override
    protected Supplier<PartitionFunction> newInstance() {
        return () -> new PartitionFunction();
    }

    @Override
    public boolean equals(Object obj, EqualsHandler equalsHandler) {
        if (!(obj instanceof PartitionFunction)) {
            return false;
        }
        if (!super.equals(obj, equalsHandler)) {
            return false;
        }
        PartitionFunction val = (PartitionFunction)obj;
        if (!this.equals(SchemaProperties.DATA_TYPE, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.DATA_TYPE_NAME, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.LENGTH, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.OCTET_LENGTH, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.PRECISION, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.SCALE, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.BOUNDARY_VALUE_ON_RIGHT, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.PARTITION_FUNCTION_VALUES, val, equalsHandler)) {
            return false;
        }
        return equalsHandler.equalsResult(this, obj);
    }

    @Override
    protected void toStringDetail(ToStringBuilder builder) {
        builder.add((ISchemaProperty)SchemaProperties.DATA_TYPE, (Object)this.getDataType());
        builder.add((ISchemaProperty)SchemaProperties.DATA_TYPE_NAME, this.getDataTypeName());
        builder.add((ISchemaProperty)SchemaProperties.LENGTH, (Object)this.getLength());
        builder.add((ISchemaProperty)SchemaProperties.OCTET_LENGTH, (Object)this.getOctetLength());
        builder.add((ISchemaProperty)SchemaProperties.PRECISION, (Object)this.getPrecision());
        builder.add((ISchemaProperty)SchemaProperties.SCALE, (Object)this.getScale());
        builder.add((ISchemaProperty)SchemaProperties.BOUNDARY_VALUE_ON_RIGHT, (Object)this.isBoundaryValueOnRight());
        builder.add((ISchemaProperty)SchemaProperties.VALUES, (Object)this.getValues());
    }

    @Override
    protected void writeXmlOptionalAttributes(StaxWriter stax) throws XMLStreamException {
        super.writeXmlOptionalAttributes(stax);
        stax.writeAttribute(SchemaProperties.DATA_TYPE.getLabel(), (Object)this.getDataType());
        stax.writeAttribute(SchemaProperties.DATA_TYPE_NAME.getLabel(), this.getDataTypeName());
        stax.writeAttribute(SchemaProperties.LENGTH.getLabel(), (Object)this.getLength());
        if (this.getOctetLength() != null && this.getOctetLength() > 0L) {
            stax.writeAttribute(SchemaProperties.OCTET_LENGTH.getLabel(), (Object)this.getOctetLength());
        }
        if (this.getPrecision() != null && this.getPrecision() > 0) {
            stax.writeAttribute(SchemaProperties.PRECISION.getLabel(), (Object)this.getPrecision());
        }
        if (this.getScale() != null && this.getScale() != 0) {
            stax.writeAttribute(SchemaProperties.SCALE.getLabel(), (Object)this.getScale());
        }
        stax.writeAttribute(SchemaProperties.BOUNDARY_VALUE_ON_RIGHT.getLabel(), (Object)this.isBoundaryValueOnRight());
    }

    @Override
    protected void writeXmlOptionalValues(StaxWriter stax) throws XMLStreamException {
        super.writeXmlOptionalValues(stax);
        this.getValues().writeXml(stax);
    }

    @Override
    public boolean isBoundaryValueOnRight() {
        return this.boundaryValueOnRight;
    }

    @Override
    public PartitionFunction setBoundaryValueOnRight(boolean boundaryValueOnRight) {
        this.boundaryValueOnRight = boundaryValueOnRight;
        return (PartitionFunction)this.instance();
    }

    @Override
    public Long getLength() {
        return this.maxLength;
    }

    @Override
    public PartitionFunction setLength(long maxLength) {
        this.maxLength = maxLength;
        return (PartitionFunction)this.instance();
    }

    @Override
    public PartitionFunction setLength(Number maxLength) {
        this.maxLength = Converters.getDefault().convertObject(maxLength, Long.class);
        return (PartitionFunction)this.instance();
    }

    @Override
    public Long getOctetLength() {
        return this.octetLength;
    }

    @Override
    public PartitionFunction setOctetLength(long octetLength) {
        this.octetLength = octetLength;
        return (PartitionFunction)this.instance();
    }

    @Override
    public PartitionFunction setOctetLength(Number octetLength) {
        this.octetLength = Converters.getDefault().convertObject(octetLength, Long.class);
        return (PartitionFunction)this.instance();
    }

    @Override
    public Integer getPrecision() {
        return this.precision;
    }

    @Override
    public PartitionFunction setPrecision(int precision) {
        this.precision = precision;
        return (PartitionFunction)this.instance();
    }

    @Override
    public PartitionFunction setPrecision(Number precision) {
        this.precision = precision == null ? null : Integer.valueOf(precision.intValue());
        return (PartitionFunction)this.instance();
    }

    @Override
    public PartitionFunction setScale(int scale) {
        this.scale = scale;
        return (PartitionFunction)this.instance();
    }

    @Override
    public Integer getScale() {
        return this.scale;
    }

    @Override
    public PartitionFunction setScale(Number scale) {
        this.scale = Converters.getDefault().convertObject(scale, Integer.class);
        return (PartitionFunction)this.instance();
    }

    public int getFanout() {
        return this.values.size();
    }

    public PartitionFunction addValues(String val) {
        this.values.add(val);
        return (PartitionFunction)this.instance();
    }

    @Override
    public PatitionFunctionValues getValues() {
        return this.values;
    }

    @Override
    public PartitionFunction setValues(PatitionFunctionValues values) {
        this.values = values;
        if (values != null) {
            values.setPartitionFunction(this);
        }
        return (PartitionFunction)this.instance();
    }

    @Override
    public PartitionFunction addValue(String val) {
        if (this.getValues() == null) {
            this.setValues(new PatitionFunctionValues());
        }
        return (PartitionFunction)this.instance();
    }

    protected void addStringValues(Set<String> values) {
        this.values.addAll(values);
    }

    @Override
    public PartitionFunctionCollection getParent() {
        return (PartitionFunctionCollection)super.getParent();
    }

    public static class PatitionFunctionValues
    extends UniqueList<String> {
        private static final long serialVersionUID = 1L;
        private PartitionFunction partitionFunction;

        public PatitionFunctionValues() {
        }

        private PatitionFunctionValues(PartitionFunction partitionFunction) {
            this.partitionFunction = partitionFunction;
        }

        private void setPartitionFunction(PartitionFunction partitionFunction) {
            this.partitionFunction = partitionFunction;
        }

        public void addAll(String ... args) {
            this.addAll(CommonUtils.list(args));
        }

        protected void writeXml(StaxWriter stax) throws XMLStreamException {
            if (this.size() > 0) {
                stax.newLine();
                stax.indent();
                Set<String> set = CommonUtils.linkedSet(this);
                stax.writeElementValues(SchemaProperties.VALUES.getLabel(), set);
            }
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            return this instanceof PatitionFunctionValues;
        }

        @Override
        protected void validate() {
            super.validate();
            Collections.sort(this.inner, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    if (partitionFunction != null && partitionFunction.getDataType() != null) {
                        Class<?> clazz = partitionFunction.getDataType().getDefaultClass();
                        Object conv1 = Converters.getDefault().convertObject(o1, clazz);
                        Object conv2 = Converters.getDefault().convertObject(o2, clazz);
                        return CommonUtils.compare(conv1, conv2);
                    }
                    return CommonUtils.compare((Comparable)((Object)o1), (Object)o2);
                }
            });
        }

        @Override
        public int hashCode() {
            HashCodeBuilder builder = new HashCodeBuilder(super.hashCode());
            builder.append(this.partitionFunction.hashCode());
            return builder.hashCode();
        }

        @Override
        public PatitionFunctionValues clone() {
            PatitionFunctionValues clone = (PatitionFunctionValues)super.clone();
            return clone;
        }
    }
}

