/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.AbstractDbObject;
import com.sqlapp.data.schemas.EqualsHandler;
import com.sqlapp.data.schemas.HasParent;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.data.schemas.properties.HighValueProperty;
import com.sqlapp.data.schemas.properties.ISchemaProperty;
import com.sqlapp.data.schemas.properties.LowValueProperty;
import com.sqlapp.data.schemas.properties.SchemaNameProperty;
import com.sqlapp.data.schemas.properties.TableNameProperty;
import com.sqlapp.data.schemas.properties.complex.TableProperty;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.StaxWriter;
import com.sqlapp.util.ToStringBuilder;
import java.util.function.Supplier;
import javax.xml.stream.XMLStreamException;

public final class PartitionParent
extends AbstractDbObject<PartitionParent>
implements SchemaNameProperty<PartitionParent>,
TableNameProperty<PartitionParent>,
TableProperty<PartitionParent>,
LowValueProperty<PartitionParent>,
HighValueProperty<PartitionParent>,
HasParent<Table> {
    private static final long serialVersionUID = 1L;
    private Table table = new Table();
    private String lowValue = null;
    private String highValue = null;

    public PartitionParent() {
    }

    protected PartitionParent(Table parent) {
        this.setParent(parent);
    }

    @Override
    protected Supplier<PartitionParent> newInstance() {
        return () -> new PartitionParent();
    }

    @Override
    public boolean equals(Object obj, EqualsHandler equalsHandler) {
        if (!super.equals(obj, equalsHandler)) {
            return false;
        }
        if (!(obj instanceof PartitionParent)) {
            return false;
        }
        PartitionParent val = (PartitionParent)obj;
        if (!this.equals(SchemaProperties.SCHEMA_NAME, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.TABLE_NAME, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.LOW_VALUE, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.HIGH_VALUE, val, equalsHandler)) {
            return false;
        }
        return equalsHandler.equalsResult(this, obj);
    }

    @Override
    public Table getParent() {
        return (Table)super.getParent();
    }

    @Override
    public String getSchemaName() {
        if (this.table == null) {
            return null;
        }
        if (this.table.getSchemaName() != null) {
            return this.table.getSchemaName();
        }
        if (this.table != null) {
            return this.table.getSchemaName();
        }
        return null;
    }

    @Override
    public String getTableName() {
        return this.table.getName();
    }

    @Override
    public int compareTo(PartitionParent o) {
        return 0;
    }

    @Override
    public String getHighValue() {
        return this.highValue;
    }

    @Override
    public PartitionParent setHighValue(String highValue) {
        this.highValue = highValue;
        return (PartitionParent)this.instance();
    }

    @Override
    public String getLowValue() {
        return this.lowValue;
    }

    @Override
    public PartitionParent setLowValue(String lowValue) {
        this.lowValue = lowValue;
        return (PartitionParent)this.instance();
    }

    @Override
    public PartitionParent setTableName(String tableName) {
        if (!CommonUtils.eq(this.table.getName(), tableName)) {
            String schemaName = this.getSchemaName();
            this.table = new Table(tableName);
            this.table.setSchemaName(schemaName);
        }
        return (PartitionParent)this.instance();
    }

    @Override
    public PartitionParent setSchemaName(String name) {
        if (!CommonUtils.eq(this.table.getSchemaName(), name)) {
            String tableName = this.getTableName();
            this.table = new Table(tableName);
            this.table.setSchemaName(name);
        }
        return (PartitionParent)this.instance();
    }

    @Override
    protected void writeXmlOptionalAttributes(StaxWriter stax) throws XMLStreamException {
        super.writeXmlOptionalAttributes(stax);
        if (this.getParent() == null || !CommonUtils.eq(this.getParent().getSchemaName(), this.getSchemaName())) {
            stax.writeAttribute(SchemaProperties.SCHEMA_NAME, (Object)this);
        }
        stax.writeAttribute(SchemaProperties.TABLE_NAME, (Object)this);
        stax.writeAttribute(SchemaProperties.LOW_VALUE, (Object)this);
        stax.writeAttribute(SchemaProperties.HIGH_VALUE, (Object)this);
    }

    @Override
    protected void toString(ToStringBuilder builder) {
        builder.add((ISchemaProperty)SchemaProperties.SCHEMA_NAME, this.getSchemaName());
        builder.add((ISchemaProperty)SchemaProperties.TABLE_NAME, this.getTableName());
        builder.add((ISchemaProperty)SchemaProperties.LOW_VALUE, this.getLowValue());
        builder.add((ISchemaProperty)SchemaProperties.HIGH_VALUE, this.getLowValue());
    }
}

