/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.AbstractNamedObject;
import com.sqlapp.data.schemas.Catalog;
import com.sqlapp.data.schemas.EqualsHandler;
import com.sqlapp.data.schemas.HasParent;
import com.sqlapp.data.schemas.PartitionFunction;
import com.sqlapp.data.schemas.PartitionSchemeCollection;
import com.sqlapp.data.schemas.ReferenceTableSpaceCollection;
import com.sqlapp.data.schemas.SchemaObjectProperties;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.TableSpace;
import com.sqlapp.data.schemas.properties.DefaultProperty;
import com.sqlapp.data.schemas.properties.ISchemaProperty;
import com.sqlapp.data.schemas.properties.complex.PartitionFunctionProperty;
import com.sqlapp.data.schemas.properties.object.ReferenceTableSpacesProperty;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.StaxWriter;
import com.sqlapp.util.ToStringBuilder;
import java.util.function.Supplier;
import javax.xml.stream.XMLStreamException;

public final class PartitionScheme
extends AbstractNamedObject<PartitionScheme>
implements HasParent<PartitionSchemeCollection>,
DefaultProperty<PartitionScheme>,
PartitionFunctionProperty<PartitionScheme>,
ReferenceTableSpacesProperty<PartitionScheme> {
    private static final long serialVersionUID = 1L;
    private ReferenceTableSpaceCollection tableSpaces = new ReferenceTableSpaceCollection(this);
    private PartitionFunction partitionFunction = null;
    private boolean _default = (Boolean)SchemaProperties.DEFAULT.getDefaultValue();

    public PartitionScheme() {
    }

    public PartitionScheme(String name) {
        super(name);
    }

    @Override
    protected Supplier<PartitionScheme> newInstance() {
        return () -> new PartitionScheme();
    }

    @Override
    public ReferenceTableSpaceCollection getTableSpaces() {
        return this.tableSpaces;
    }

    public PartitionScheme setTableSpaces(String ... args) {
        this.tableSpaces.clear();
        if (args != null) {
            for (String arg : args) {
                this.tableSpaces.add(new TableSpace(arg));
            }
        }
        return this;
    }

    protected PartitionScheme setTableSpaces(ReferenceTableSpaceCollection tableSpaces) {
        this.tableSpaces = tableSpaces;
        if (tableSpaces != null) {
            tableSpaces.setParent(this);
        }
        return (PartitionScheme)this.instance();
    }

    @Override
    public boolean isDefault() {
        return this._default;
    }

    @Override
    public PartitionScheme setDefault(boolean _default) {
        this._default = _default;
        return this;
    }

    @Override
    public boolean equals(Object obj, EqualsHandler equalsHandler) {
        if (!(obj instanceof PartitionScheme)) {
            return false;
        }
        if (!super.equals(obj, equalsHandler)) {
            return false;
        }
        PartitionScheme val = (PartitionScheme)obj;
        if (!this.equals(SchemaObjectProperties.REFERENCE_TABLE_SPACES, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.PARTITION_FUNCTION_NAME, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.DEFAULT, val, equalsHandler)) {
            return false;
        }
        return equalsHandler.equalsResult(this, obj);
    }

    @Override
    protected void writeXmlOptionalAttributes(StaxWriter stax) throws XMLStreamException {
        super.writeXmlOptionalAttributes(stax);
        stax.writeAttribute(SchemaProperties.PARTITION_FUNCTION_NAME.getLabel(), this.getPartitionFunctionName());
        stax.writeAttribute(SchemaProperties.DEFAULT.getLabel(), (Object)this.isDefault());
    }

    @Override
    protected void writeXmlOptionalValues(StaxWriter stax) throws XMLStreamException {
        super.writeXmlOptionalValues(stax);
        if (!CommonUtils.isEmpty(this.getTableSpaces())) {
            this.getTableSpaces().writeXml(SchemaObjectProperties.REFERENCE_TABLE_SPACES.getLabel(), stax);
        }
    }

    @Override
    protected void toStringDetail(ToStringBuilder builder) {
        builder.add(SchemaObjectProperties.REFERENCE_TABLE_SPACES.getLabel(), this.getTableSpaces());
        builder.add((ISchemaProperty)SchemaProperties.PARTITION_FUNCTION_NAME, this.getPartitionFunctionName());
        builder.add((ISchemaProperty)SchemaProperties.DEFAULT, (Object)this.isDefault());
    }

    @Override
    public PartitionSchemeCollection getParent() {
        return (PartitionSchemeCollection)super.getParent();
    }

    @Override
    protected void validate() {
        super.validate();
        ReferenceTableSpaceCollection list = new ReferenceTableSpaceCollection(this);
        Catalog catalog = this.getAncestor(Catalog.class);
        if (catalog == null) {
            return;
        }
        for (TableSpace tableSpace : this.tableSpaces) {
            TableSpace ts = (TableSpace)catalog.getTableSpaces().get(tableSpace.getName());
            if (ts != null) {
                list.add(ts);
                continue;
            }
            list.add(tableSpace);
        }
        this.tableSpaces = list;
    }
}

