/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.converter.Converters;
import com.sqlapp.data.schemas.AbstractNamedObject;
import com.sqlapp.data.schemas.AbstractObjectXmlReaderHandler;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.ColumnCollection;
import com.sqlapp.data.schemas.DbObject;
import com.sqlapp.data.schemas.DbObjectDifference;
import com.sqlapp.data.schemas.EqualsHandler;
import com.sqlapp.data.schemas.GetAllDbObjectEqualsHandler;
import com.sqlapp.data.schemas.GetPropertyMapEqualsHandler;
import com.sqlapp.data.schemas.HasParent;
import com.sqlapp.data.schemas.ReferenceColumn;
import com.sqlapp.data.schemas.ReferenceColumnCollection;
import com.sqlapp.data.schemas.RowCollection;
import com.sqlapp.data.schemas.RowXmlReaderHandler;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.data.schemas.UniqueConstraint;
import com.sqlapp.data.schemas.XmlReaderOptions;
import com.sqlapp.data.schemas.properties.CreatedAtProperty;
import com.sqlapp.data.schemas.properties.DataSourceDetailInfoProperty;
import com.sqlapp.data.schemas.properties.DataSourceInfoProperty;
import com.sqlapp.data.schemas.properties.DataSourceRowNumberProperty;
import com.sqlapp.data.schemas.properties.HasErrorsProperty;
import com.sqlapp.data.schemas.properties.ISchemaProperty;
import com.sqlapp.data.schemas.properties.LastAlteredAtProperty;
import com.sqlapp.data.schemas.properties.RowIdProperty;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.EqualsUtils;
import com.sqlapp.util.FileUtils;
import com.sqlapp.util.HashCodeBuilder;
import com.sqlapp.util.SeparatedStringBuilder;
import com.sqlapp.util.StaxReader;
import com.sqlapp.util.StaxWriter;
import com.sqlapp.util.xml.ResultHandler;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.xml.stream.XMLStreamException;

public final class Row
implements DbObject<Row>,
Comparable<Row>,
HasParent<RowCollection>,
RowIdProperty<Row>,
DataSourceInfoProperty<Row>,
DataSourceDetailInfoProperty<Row>,
DataSourceRowNumberProperty<Row>,
CreatedAtProperty<Row>,
LastAlteredAtProperty<Row>,
HasErrorsProperty<Row> {
    private static final long serialVersionUID = -765221600151712239L;
    private Object[] values = null;
    protected static final String VALUES = "values";
    private String[] remarks = null;
    protected static final String COMMENT = "comment";
    private String[] options = null;
    protected static final String OPTIONS = "options";
    protected static final String OPTION = "option";
    protected static final String SQL_OPTION = "<SQL>";
    protected static final String NULL_OPTION = "<NULL>";
    private Timestamp createdAt = null;
    private Timestamp lastAlteredAt = null;
    private RowCollection parent = null;
    private Long rowId = null;
    private String dataSourceInfo = null;
    private String dataSourceDetailInfo = null;
    private Long dataSourceRowNumber = null;
    private boolean hasErrors = (Boolean)SchemaProperties.HAS_ERRORS.getDefaultValue();
    private final String SIMPLE_NAME = AbstractNamedObject.getSimpleName(this.getClass());

    protected Supplier<Row> newInstance() {
        return () -> new Row();
    }

    public Row clone() {
        Row clone = this.newInstance().get();
        clone.setDataSourceRowNumber(this.getDataSourceRowNumber());
        clone.setCreatedAt(this.getCreatedAt());
        clone.setLastAlteredAt(this.getLastAlteredAt());
        clone.setDataSourceInfo(this.getDataSourceInfo());
        clone.setDataSourceDetailInfo(this.getDataSourceDetailInfo());
        if (this.values != null) {
            clone.values = new Object[this.values.length];
            if (this.remarks != null) {
                clone.remarks = new String[this.remarks.length];
            }
            if (this.options != null) {
                clone.options = new String[this.options.length];
            }
            Converters converter = Converters.getDefault();
            for (int i = 0; i < this.values.length; ++i) {
                Object val = this.values[i];
                clone.values[i] = converter.copy(val);
                if (this.remarks != null) {
                    clone.remarks[i] = this.remarks[i];
                }
                if (this.options == null) continue;
                clone.options[i] = this.options[i];
            }
        }
        return clone;
    }

    protected Row compactionColumn(Column ... columns) {
        Object[] newValues = new Object[columns.length];
        String[] newComments = null;
        if (this.remarks != null) {
            newComments = new String[columns.length];
        }
        String[] newOptions = null;
        if (this.options != null) {
            newOptions = new String[columns.length];
        }
        for (int i = 0; i < columns.length; ++i) {
            Column column = columns[i];
            newValues[i] = column.getOrdinal() < this.values.length ? this.values[column.getOrdinal()] : null;
            if (this.remarks != null) {
                newComments[i] = column.getOrdinal() < this.remarks.length ? this.remarks[column.getOrdinal()] : null;
            }
            if (this.options == null) continue;
            newOptions[i] = column.getOrdinal() < this.remarks.length ? this.options[column.getOrdinal()] : null;
        }
        this.values = newValues;
        this.remarks = newComments;
        this.options = newOptions;
        return this;
    }

    protected Row addColumn(Column ... columns) {
        Table table = this.getTable();
        int size = 0;
        if (table != null) {
            size = table.getColumns().size();
        }
        Object[] newValues = new Object[size + columns.length];
        if (this.values != null) {
            System.arraycopy(this.values, 0, newValues, 0, this.values.length);
        }
        String[] newComments = null;
        if (this.remarks != null) {
            newComments = new String[size + columns.length];
            System.arraycopy(this.remarks, 0, newComments, 0, this.remarks.length);
        }
        String[] newOptions = null;
        if (this.options != null) {
            newOptions = new String[size + columns.length];
            System.arraycopy(this.options, 0, newOptions, 0, this.options.length);
        }
        this.values = newValues;
        this.remarks = newComments;
        this.options = newOptions;
        return this;
    }

    public <T> T put(Column column, Object value) {
        this.checkSize(column);
        return this.put(column.getOrdinal(), value);
    }

    private void checkSize(Column column) {
        Object[] vals;
        Table table;
        ColumnCollection cc = column.getParent();
        if (cc == null && (table = this.getTable()) != null) {
            cc = table.getColumns();
        }
        if (cc == null) {
            return;
        }
        int size = cc.size();
        if (CommonUtils.size(this.values) < size) {
            vals = new Object[size];
            if (!CommonUtils.isEmpty(this.values)) {
                System.arraycopy(this.values, 0, vals, 0, this.values.length);
            }
            this.values = vals;
        }
        if (CommonUtils.size(this.remarks) < size) {
            vals = new String[size];
            if (!CommonUtils.isEmpty(this.remarks)) {
                System.arraycopy(this.remarks, 0, vals, 0, this.remarks.length);
            }
            this.remarks = vals;
        }
        if (CommonUtils.size(this.options) < size) {
            vals = new String[size];
            if (!CommonUtils.isEmpty(this.options)) {
                System.arraycopy(this.options, 0, vals, 0, this.options.length);
            }
            this.options = vals;
        }
    }

    public <T> T put(int index, Object value) {
        if (CommonUtils.size(this.values) < index + 1) {
            Object[] vals = new Object[index + 1];
            if (!CommonUtils.isEmpty(this.values)) {
                System.arraycopy(this.values, 0, vals, 0, this.values.length);
            }
            this.values = vals;
        }
        Object oldValue = this.values[index];
        Column column = (Column)this.getTable().getColumns().get(index);
        this.values[index] = column.getConverter().convertObject(value);
        return (T)oldValue;
    }

    protected <T> T putDirect(Column column, Object value) {
        if (CommonUtils.size(this.values) < column.getOrdinal() + 1) {
            Object[] vals = new Object[column.getOrdinal() + 1];
            if (!CommonUtils.isEmpty(this.values)) {
                System.arraycopy(this.values, 0, vals, 0, this.values.length);
            }
            this.values = vals;
        }
        Object oldValue = this.values[column.getOrdinal()];
        this.values[column.getOrdinal()] = value;
        return (T)oldValue;
    }

    public String putRemarks(Column column, String remarks) {
        return this.putRemarks(column.getOrdinal(), remarks);
    }

    public String putRemarks(int index, String remarks) {
        if (CommonUtils.size(this.remarks) < index + 1) {
            String[] vals = new String[index + 1];
            if (!CommonUtils.isEmpty(this.remarks)) {
                System.arraycopy(this.remarks, 0, vals, 0, this.remarks.length);
            }
            this.remarks = vals;
        }
        String oldValue = this.getRemarksArray()[index];
        this.getRemarksArray()[index] = remarks;
        return oldValue;
    }

    private String[] getRemarksArray() {
        if (this.remarks == null) {
            this.remarks = new String[this.values.length];
        } else if (this.remarks.length < this.values.length) {
            String[] array = new String[this.values.length];
            System.arraycopy(this.remarks, 0, array, 0, this.remarks.length);
            this.remarks = array;
        }
        return this.remarks;
    }

    public String getRemarks(int index) {
        return this.getRemarksArray()[index];
    }

    public String getRemarks(Column column) {
        this.checkSize(column);
        return this.getRemarks(column.getOrdinal());
    }

    public String getRemarks(String columnName) {
        Column column = (Column)this.getTable().getColumns().get(columnName);
        return this.getRemarks(column);
    }

    public String putOption(Column column, String option) {
        this.checkSize(column);
        return this.putOption(column.getOrdinal(), option);
    }

    public String putOption(int index, String option) {
        if (CommonUtils.size(this.options) < index + 1) {
            String[] vals = new String[index + 1];
            if (!CommonUtils.isEmpty(this.options)) {
                System.arraycopy(this.options, 0, vals, 0, this.options.length);
            }
            this.options = vals;
        }
        String oldValue = this.getOptionArray()[index];
        this.getOptionArray()[index] = option;
        return oldValue;
    }

    private String[] getOptionArray() {
        if (this.options == null) {
            this.options = new String[this.values.length];
        } else if (this.options.length < this.values.length) {
            String[] array = new String[this.values.length];
            System.arraycopy(this.options, 0, array, 0, this.options.length);
            this.options = array;
        }
        return this.options;
    }

    public String getOption(int index) {
        return this.getOptionArray()[index];
    }

    public String getOption(Column column) {
        return this.getOption(column.getOrdinal());
    }

    public String getOption(String columnName) {
        Column column = (Column)this.getTable().getColumns().get(columnName);
        return this.getOption(column);
    }

    public <T> T put(String columnName, Object value) {
        Column column = (Column)this.getTable().getColumns().get(columnName);
        return this.put(column, value);
    }

    public <T> T get(String columnName) {
        Column column = (Column)this.getTable().getColumns().get(columnName);
        return this.get(column);
    }

    public List<Object> getAll(String ... columnNames) {
        return this.getAll(this.parent.getParent().getColumns().getAll(columnNames));
    }

    public Map<String, Object> getValuesAsMap() {
        Map<String, Object> map = CommonUtils.linkedMap();
        if (this.getTable() == null) {
            return map;
        }
        for (Column column : this.getTable().getColumns()) {
            map.put(column.getName(), this.get(column));
        }
        return map;
    }

    public Map<String, Object> getValuesAsMapWithoutNullValue() {
        Map<String, Object> map = CommonUtils.linkedMap();
        if (this.getTable() == null) {
            return map;
        }
        for (Column column : this.getTable().getColumns()) {
            Object value = this.get(column);
            if (value == null) continue;
            map.put(column.getName(), value);
        }
        return map;
    }

    public Map<String, Object> getValuesAsMapWithKey() {
        Map<String, Object> map = CommonUtils.linkedMap();
        if (this.getTable() == null) {
            return map;
        }
        Set pks = CommonUtils.set();
        Set uks = CommonUtils.set();
        if (this.getTable().getPrimaryKeyConstraint() != null) {
            for (ReferenceColumn referenceColumn : this.getTable().getPrimaryKeyConstraint().getColumns()) {
                pks.add(referenceColumn.getName());
            }
        }
        if (pks.isEmpty()) {
            for (Column column : this.getTable().getUniqueColumns()) {
                uks.add(column.getName());
            }
        }
        for (Column column : this.getTable().getColumns()) {
            if (pks.contains(column.getName())) {
                map.put(column.getName() + "(PK)", this.get(column));
                continue;
            }
            if (uks.contains(column.getName())) {
                map.put(column.getName() + "(UK)", this.get(column));
                continue;
            }
            map.put(column.getName(), this.get(column));
        }
        return map;
    }

    public <T> T get(int index) {
        return (T)(this.values != null ? this.values[index] : null);
    }

    public <T> T get(Column column) {
        return this.get(column.getOrdinal());
    }

    public List<Object> getAll(Column ... columns) {
        List<Object> list = CommonUtils.list(columns.length);
        for (Column column : columns) {
            list.add(this.values[column.getOrdinal()]);
        }
        return list;
    }

    public List<Object> getAll(Collection<Column> columns) {
        List<Object> list = CommonUtils.list(columns.size());
        for (Column column : columns) {
            list.add(this.values[column.getOrdinal()]);
        }
        return list;
    }

    public boolean isNull(Column column) {
        return this.get(column) == null;
    }

    @Override
    public RowCollection getParent() {
        return this.parent;
    }

    protected Row setParent(RowCollection parent) {
        this.parent = parent;
        return this.instance();
    }

    private Row instance() {
        return this;
    }

    @Override
    public String getDataSourceInfo() {
        return this.dataSourceInfo;
    }

    @Override
    public Row setDataSourceInfo(String dataSourceInfo) {
        this.dataSourceInfo = dataSourceInfo;
        return this.instance();
    }

    @Override
    public String getDataSourceDetailInfo() {
        return this.dataSourceDetailInfo;
    }

    @Override
    public Row setDataSourceDetailInfo(String dataSourceDetailInfo) {
        this.dataSourceDetailInfo = dataSourceDetailInfo;
        return this.instance();
    }

    public Table getTable() {
        RowCollection rc = this.getParent();
        if (rc == null) {
            return null;
        }
        return rc.getParent();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Row[");
        SeparatedStringBuilder sBuild = new SeparatedStringBuilder(",");
        Table table = this.getTable();
        if (table != null) {
            for (Column column : table.getColumns()) {
                Object value = this.get(column);
                String comment = null;
                if (this.remarks != null) {
                    comment = this.getRemarks(column);
                }
                String option = null;
                if (this.options != null) {
                    option = this.getOption(column);
                }
                StringBuilder valueBuilder = new StringBuilder();
                valueBuilder.append("{");
                valueBuilder.append("value=");
                valueBuilder.append(value);
                if (comment != null) {
                    valueBuilder.append(",comment=");
                    valueBuilder.append(comment);
                }
                if (option != null) {
                    valueBuilder.append(",option=");
                    valueBuilder.append((Object)option);
                }
                valueBuilder.append("}");
                sBuild.add((Object)(column.getName() + "=" + valueBuilder.toString()));
            }
        }
        builder.append(sBuild.toString());
        builder.append("]");
        return builder.toString();
    }

    @Override
    public String toStringSimple() {
        return this.toString();
    }

    public Object[] getValues() {
        if (this.values == null) {
            return null;
        }
        Object[] vals = new Object[this.values.length];
        System.arraycopy(this.values, 0, vals, 0, vals.length);
        return vals;
    }

    protected void writeXml(StaxWriter stax, ColumnCollection columns) throws XMLStreamException {
        stax.newLine();
        stax.indent();
        stax.writeStartElement("row");
        stax.writeAttribute(SchemaProperties.DATA_SOURCE_INFO.getLabel(), this.getDataSourceInfo());
        stax.writeAttribute(SchemaProperties.DATA_SOURCE_DETAIL_INFO.getLabel(), this.getDataSourceDetailInfo());
        if (this.getHasErrors()) {
            stax.writeAttribute(SchemaProperties.HAS_ERRORS.getLabel(), (Object)this.getHasErrors());
        }
        stax.writeAttribute(SchemaProperties.CREATED_AT.getLabel(), (Object)this.getCreatedAt());
        stax.writeAttribute(SchemaProperties.LAST_ALTERED_AT.getLabel(), (Object)this.getLastAlteredAt());
        stax.addIndentLevel(1);
        int size = columns.size();
        for (int i = 0; i < size; ++i) {
            Column column = (Column)columns.get(i);
            int ordinal = column.getOrdinal();
            Object val = this.get(ordinal);
            String comment = this.getRemarks(ordinal);
            String option = this.getOption(ordinal);
            if (val == null && comment == null && option == null) continue;
            stax.newLine();
            stax.indent();
            stax.writeStartElement("value");
            stax.writeAttribute("key", column.getName());
            stax.writeAttribute(COMMENT, comment);
            stax.writeAttribute(OPTION, (Object)option);
            stax.writeCharacters(val);
            stax.writeEndElement();
        }
        stax.addIndentLevel(-1);
        stax.newLine();
        stax.indent();
        stax.writeEndElement();
    }

    @Override
    public void writeXml(StaxWriter stax) throws XMLStreamException {
        this.writeXml(stax, this.getTable().getColumns());
    }

    protected void writeName(StaxWriter stax) throws XMLStreamException {
    }

    @Override
    public void writeXml(String path) throws XMLStreamException, IOException {
        this.writeXml(new File(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeXml(File file) throws XMLStreamException, IOException {
        BufferedOutputStream bos = null;
        try {
            bos = new BufferedOutputStream(new FileOutputStream(file));
            StaxWriter stax = new StaxWriter(bos);
            this.writeXml(stax);
            bos.flush();
        }
        catch (Throwable throwable) {
            FileUtils.close(bos);
            throw throwable;
        }
        FileUtils.close(bos);
    }

    @Override
    public void loadXml(Reader reader, XmlReaderOptions options) throws XMLStreamException {
        StaxReader staxReader = new StaxReader(reader);
        RowXmlReaderHandler handler = this.getDbObjectXmlReaderHandler();
        handler.setReaderOptions(options);
        AbstractObjectXmlReaderHandler.ChildObjectHolder holder = new AbstractObjectXmlReaderHandler.ChildObjectHolder(this);
        ResultHandler resultHandler = new ResultHandler();
        resultHandler.registerChild(handler);
        resultHandler.handle(staxReader, holder);
    }

    @Override
    public void loadXml(InputStream stream, XmlReaderOptions options) throws XMLStreamException {
        StaxReader staxReader = new StaxReader(stream);
        RowXmlReaderHandler handler = this.getDbObjectXmlReaderHandler();
        handler.setReaderOptions(options);
        AbstractObjectXmlReaderHandler.ChildObjectHolder holder = new AbstractObjectXmlReaderHandler.ChildObjectHolder(this);
        ResultHandler resultHandler = new ResultHandler();
        resultHandler.registerChild(handler);
        resultHandler.handle(staxReader, holder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadXml(String path, XmlReaderOptions options) throws XMLStreamException, FileNotFoundException {
        InputStream stream = null;
        BufferedInputStream bis = null;
        try {
            stream = FileUtils.getInputStream(path);
            if (stream == null) {
                throw new FileNotFoundException(path);
            }
            bis = new BufferedInputStream(stream);
            this.loadXml(bis, options);
        }
        finally {
            FileUtils.close(stream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadXml(File file, XmlReaderOptions options) throws XMLStreamException, FileNotFoundException {
        FileInputStream stream = null;
        BufferedInputStream bis = null;
        try {
            stream = new FileInputStream(file);
            bis = new BufferedInputStream(stream);
            this.loadXml(bis, options);
        }
        catch (Throwable throwable) {
            FileUtils.close(stream);
            throw throwable;
        }
        FileUtils.close(stream);
    }

    protected RowXmlReaderHandler getDbObjectXmlReaderHandler() {
        return new RowXmlReaderHandler();
    }

    @Override
    public void writeXml(OutputStream stream) throws XMLStreamException {
        StaxWriter stax = new StaxWriter(stream){

            @Override
            protected boolean isWriteStartDocument() {
                return true;
            }
        };
        this.writeXml(stax);
    }

    @Override
    public void writeXml(Writer writer) throws XMLStreamException {
        StaxWriter stax = new StaxWriter(writer){

            @Override
            protected boolean isWriteStartDocument() {
                return true;
            }
        };
        this.writeXml(stax);
    }

    @Override
    public Map<String, Object> toMap() {
        GetPropertyMapEqualsHandler equalsHandler = new GetPropertyMapEqualsHandler(this);
        this.equals(this, new GetPropertyMapEqualsHandler(this));
        return equalsHandler.getResult();
    }

    public boolean equals(Object obj) {
        return this.equals(obj, EqualsHandler.getInstance());
    }

    @Override
    public boolean equals(Object obj, EqualsHandler equalsHandler) {
        if (!(obj instanceof Row)) {
            return false;
        }
        if (equalsHandler.referenceEquals(this, obj)) {
            return true;
        }
        Row val = (Row)obj;
        if (!this.equals(VALUES, val, (Object)this.getValues(), (Object)val.getValues(), equalsHandler, EqualsUtils.getEqualsSupplier(this.getValues(), val.getValues()))) {
            return false;
        }
        if (!this.equals(SchemaProperties.REMARKS, val, (Object)this.remarks, (Object)val.remarks, equalsHandler, EqualsUtils.getEqualsSupplier(this.remarks, val.remarks))) {
            return false;
        }
        if (!this.equals(OPTIONS, val, (Object)this.options, (Object)val.options, equalsHandler, EqualsUtils.getEqualsSupplier(this.options, val.options))) {
            return false;
        }
        if (!this.equals(SchemaProperties.DATA_SOURCE_ROW_NUMBER, val, (Object)this.getDataSourceRowNumber(), (Object)val.getDataSourceRowNumber(), equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.CREATED_AT, val, (Object)this.getCreatedAt(), (Object)val.getCreatedAt(), equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.LAST_ALTERED_AT, val, (Object)this.getLastAlteredAt(), (Object)val.getLastAlteredAt(), equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.ROW_ID, val, (Object)this.getRowId(), (Object)val.getRowId(), equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.DATA_SOURCE_INFO, val, (Object)this.getDataSourceInfo(), (Object)val.getDataSourceInfo(), equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.DATA_SOURCE_DETAIL_INFO, val, (Object)this.getDataSourceDetailInfo(), (Object)val.getDataSourceDetailInfo(), equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.HAS_ERRORS.getLabel(), val, (Object)this.getHasErrors(), (Object)val.getHasErrors(), equalsHandler)) {
            return false;
        }
        return equalsHandler.equalsResult(this, obj);
    }

    protected boolean equals(String propertyName, Row target, Object value, Object targetValue, EqualsHandler equalsHandler, BooleanSupplier booleanSupplier) {
        return equalsHandler.valueEquals(propertyName, this, target, value, targetValue, booleanSupplier);
    }

    protected boolean equals(ISchemaProperty props, Row target, Object value, Object targetValue, EqualsHandler equalsHandler, BooleanSupplier booleanSupplier) {
        return this.equals(props.getLabel(), target, value, targetValue, equalsHandler, booleanSupplier);
    }

    protected boolean equals(ISchemaProperty props, Row target, Object value, Object targetValue, EqualsHandler equalsHandler) {
        return this.equals(props.getLabel(), target, value, targetValue, equalsHandler);
    }

    protected boolean equals(String propertyName, Row target, Object value1, Object value2, EqualsHandler equalsHandler) {
        return equalsHandler.valueEquals(propertyName, this, target, value1, value2, EqualsUtils.getEqualsSupplier(value1, value2));
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append(this.getValues());
        builder.append(this.getRowId());
        builder.append(this.getDataSourceInfo());
        builder.append(this.getDataSourceDetailInfo());
        builder.append(this.getHasErrors());
        return builder.hashCode();
    }

    protected String getSimpleName() {
        return this.SIMPLE_NAME;
    }

    @Override
    public Long getRowId() {
        return this.rowId;
    }

    @Override
    public Row setRowId(Long rowId) {
        this.rowId = rowId;
        return this.instance();
    }

    @Override
    public boolean getHasErrors() {
        return this.hasErrors;
    }

    @Override
    public Row setHasErrors(boolean hasErrors) {
        this.hasErrors = hasErrors;
        return this;
    }

    @Override
    public int compareTo(Row o) {
        UniqueConstraint uc = this.getUniqueConstraint();
        if (uc == null && (uc = o.getUniqueConstraint()) == null) {
            return 0;
        }
        for (ReferenceColumn column : uc.getColumns()) {
            Object obj2;
            Object obj1 = this.get(column.getName());
            int ret = CommonUtils.compare(obj1, obj2 = o.get(column.getName()));
            if (ret == 0) continue;
            return ret;
        }
        return 0;
    }

    @Override
    public boolean like(Object obj) {
        if (!(obj instanceof Row)) {
            return false;
        }
        UniqueConstraint uc = this.getUniqueConstraint();
        if (uc == null) {
            return this.equals(obj);
        }
        Object[] keyValues = new Object[uc.getColumns().size()];
        ReferenceColumnCollection rcc = uc.getColumns();
        int size = rcc.size();
        Row cstRow = (Row)obj;
        for (int i = 0; i < size; ++i) {
            ReferenceColumn rc = (ReferenceColumn)rcc.get(i);
            keyValues[i] = cstRow.get(rc.getName());
        }
        boolean find = true;
        for (int i = 0; i < size; ++i) {
            ReferenceColumn rc = (ReferenceColumn)rcc.get(i);
            Object val = this.get(rc.getName());
            if (CommonUtils.eq(keyValues[i], val)) continue;
            find = false;
            break;
        }
        return find;
    }

    protected UniqueConstraint getUniqueConstraint() {
        Table table = this.getAncestor(Table.class);
        List<UniqueConstraint> ucs = table.getConstraints().getUniqueConstraints();
        if (ucs.size() == 0) {
            return null;
        }
        UniqueConstraint uc = CommonUtils.first(ucs);
        return uc;
    }

    @Override
    public boolean like(Object obj, EqualsHandler equalsHandler) {
        if (!(obj instanceof Row)) {
            return false;
        }
        Table table = this.getAncestor(Table.class);
        List<UniqueConstraint> ucs = table.getConstraints().getUniqueConstraints();
        if (ucs.size() == 0) {
            return this.equals(obj);
        }
        UniqueConstraint uc = CommonUtils.first(ucs);
        Object[] keyValues = new Object[uc.getColumns().size()];
        ReferenceColumnCollection rcc = uc.getColumns();
        int size = rcc.size();
        Row cstRow = (Row)obj;
        for (int i = 0; i < size; ++i) {
            ReferenceColumn rc = (ReferenceColumn)rcc.get(i);
            keyValues[i] = cstRow.get(rc.getName());
        }
        boolean find = true;
        for (int i = 0; i < size; ++i) {
            ReferenceColumn rc = (ReferenceColumn)rcc.get(i);
            Object val = this.get(rc.getName());
            if (!equalsHandler.valueEquals(rc.getName(), this, cstRow, keyValues[i], val, EqualsUtils.getEqualsSupplier(keyValues[i], val))) continue;
            find = false;
            break;
        }
        return find;
    }

    @Override
    public DbObjectDifference diff(Row obj) {
        DbObjectDifference diff = new DbObjectDifference(this, obj);
        return diff;
    }

    @Override
    public Timestamp getCreatedAt() {
        return this.createdAt;
    }

    @Override
    public Row setCreatedAt(Timestamp created) {
        this.createdAt = created;
        return this.instance();
    }

    @Override
    public Timestamp getLastAlteredAt() {
        return this.lastAlteredAt;
    }

    @Override
    public Row setLastAlteredAt(Timestamp lastAltered) {
        this.lastAlteredAt = lastAltered;
        return this.instance();
    }

    @Override
    public DbObjectDifference diff(Row obj, EqualsHandler equalsHandler) {
        DbObjectDifference diff = new DbObjectDifference(this, obj, equalsHandler);
        return diff;
    }

    @Override
    public Row applyAll(Consumer<DbObject<?>> consumer) {
        this.equals(this, new GetAllDbObjectEqualsHandler(consumer));
        return this.instance();
    }

    @Override
    public Long getDataSourceRowNumber() {
        return this.dataSourceRowNumber;
    }

    @Override
    public Row setDataSourceRowNumber(Long value) {
        this.dataSourceRowNumber = value;
        return this.instance();
    }
}

